/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedList<E>
extends ArrayList<E> {
    private Comparator<? super E> comp;

    public SortedList(Comparator<? super E> comp) {
        this.comp = comp;
    }

    @Override
    public boolean add(E o) {
        super.add(o);
        for (int index = super.size() - 2; index >= 0; --index) {
            Object e = this.get(index);
            int compare = this.comp.compare(o, e);
            if (compare >= 0) {
                this.set(index + 1, o);
                break;
            }
            this.set(index + 1, e);
            if (index != 0) continue;
            this.set(index, o);
        }
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }
}

