/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Indexer;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFloatArray
implements Serializable {
    private static final long serialVersionUID = 42L;
    float[] data = new float[0];
    int[] indices = new int[0];
    int length = 0;

    private void grow() {
        int curSize = this.data.length;
        int newSize = curSize + 10;
        float[] newData = new float[newSize];
        System.arraycopy(this.data, 0, newData, 0, curSize);
        this.data = newData;
        int[] newIndices = new int[newSize];
        System.arraycopy(this.indices, 0, newIndices, 0, curSize);
        for (int i = curSize; i < newIndices.length; ++i) {
            newIndices[i] = Integer.MAX_VALUE;
            newData[i] = Float.POSITIVE_INFINITY;
        }
        this.indices = newIndices;
    }

    public float getCount(int index) {
        int res = Arrays.binarySearch(this.indices, index);
        if (res >= 0 && res < this.length) {
            return this.data[res];
        }
        return 0.0f;
    }

    public void incrementCount(int index0, float x0) {
        float curCount = this.getCount(index0);
        this.setCount(index0, curCount + x0);
    }

    public int size() {
        return this.length;
    }

    public void setCount(int index0, float x) {
        int res = Arrays.binarySearch(this.indices, index0);
        if (res >= 0 && res < this.length) {
            this.data[res] = x;
            return;
        }
        if (this.length + 1 >= this.data.length) {
            this.grow();
        }
        int insertionPoint = -(res + 1);
        assert (insertionPoint >= 0 && insertionPoint <= this.length) : String.format("length: %d insertion: %d", this.length, insertionPoint);
        System.arraycopy(this.data, insertionPoint, this.data, insertionPoint + 1, this.length - insertionPoint);
        System.arraycopy(this.indices, insertionPoint, this.indices, insertionPoint + 1, this.length - insertionPoint);
        this.indices[insertionPoint] = index0;
        this.data[insertionPoint] = x;
        ++this.length;
    }

    public int getActiveDimension(int i) {
        assert (i < this.length);
        return this.indices[i];
    }

    public float getActiveCount(int i) {
        assert (i < this.length);
        return this.data[i];
    }

    public void scale(float c) {
        int i = 0;
        while (i < this.length) {
            int n = i++;
            this.data[n] = this.data[n] * c;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (int i = 0; i < this.length; ++i) {
            builder.append(String.format("%d : %.5f", this.indices[i], Float.valueOf(this.data[i])));
            builder.append(" ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public String toString(Indexer<?> indexer) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (int i = 0; i < this.length; ++i) {
            builder.append(String.format("%s : %.5f", indexer.getObject(this.indices[i]), Float.valueOf(this.data[i])));
            builder.append(" ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public float dotProduct(SparseFloatArray other) {
        float sum = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            int dim = this.indices[i];
            sum += this.data[i] * other.getCount(dim);
        }
        return sum;
    }

    public static void main(String[] args) {
        SparseFloatArray sv = new SparseFloatArray();
        sv.setCount(0, 1.0f);
        sv.setCount(1, 2.0f);
        sv.incrementCount(1, 1.0f);
        sv.incrementCount(-1, 10.0f);
        System.out.println(sv);
    }
}

