/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats {
    double sum = 0.0;
    double max = Double.NEGATIVE_INFINITY;
    double min = Double.POSITIVE_INFINITY;
    double sumSquared = 0.0;
    boolean doQuartile;
    List<Double> elems;
    int count = 0;

    public Stats(boolean doQuatrtitle) {
        this.doQuartile = doQuatrtitle;
    }

    public Stats() {
        this(false);
    }

    public double getSum() {
        return this.sum;
    }

    public void observe(double x) {
        this.sum += x;
        this.max = Math.max(this.max, x);
        this.min = Math.min(this.min, x);
        this.sumSquared += x * x;
        ++this.count;
        if (this.doQuartile) {
            if (this.elems == null) {
                this.elems = new ArrayList<Double>();
            }
            this.elems.add(x);
        }
    }

    public List<Double> getQuantiles(int n) {
        if (!this.doQuartile) {
            throw new IllegalStateException();
        }
        double frac = 1.0 / (double)n;
        Collections.sort(this.elems);
        ArrayList<Double> quantiles = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double farToGo = (double)(i + 1) * frac;
            assert (farToGo <= 1.0);
            int pos = (int)(farToGo * (double)(this.elems.size() - 1));
            assert (pos < this.elems.size()) : "illegal pos " + pos;
            quantiles.add(this.elems.get(pos));
        }
        return quantiles;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getAverage() {
        return this.sum / (double)this.count;
    }

    public double getVariance() {
        return this.sumSquared / (double)this.count - Math.pow(this.getAverage(), 2.0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("min: %.3f max: %.3f avg: %.3f var: %.3f n: %d", this.min, this.max, this.getAverage(), this.getVariance(), this.count));
        return builder.toString();
    }
}

