/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

public class StopWatch {
    public long startTime;
    public long endTime;
    public long ms;
    public int n;
    private boolean isRunning = false;

    public StopWatch() {
    }

    public StopWatch(long ms) {
        this.startTime = 0L;
        this.endTime = ms;
        this.ms = ms;
    }

    public void reset() {
        this.ms = 0L;
        this.isRunning = false;
    }

    public StopWatch start() {
        assert (!this.isRunning);
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public StopWatch stop() {
        assert (this.isRunning);
        this.endTime = System.currentTimeMillis();
        this.isRunning = false;
        this.ms = this.endTime - this.startTime;
        this.n = 1;
        return this;
    }

    public StopWatch accumStop() {
        assert (this.isRunning);
        this.endTime = System.currentTimeMillis();
        this.isRunning = false;
        this.ms += this.endTime - this.startTime;
        ++this.n;
        return this;
    }

    public void add(StopWatch w) {
        assert (!this.isRunning && !w.isRunning);
        this.ms += w.ms;
        this.n += w.n;
    }

    public long getCurrTimeLong() {
        return this.ms + (this.isRunning() ? System.currentTimeMillis() - this.startTime : 0L);
    }

    public String toString() {
        long msCopy = this.ms;
        long m = msCopy / 60000L;
        msCopy %= 60000L;
        long h = m / 60L;
        m %= 60L;
        long d = h / 24L;
        h %= 24L;
        long y = d / 365L;
        d %= 365L;
        long s = msCopy / 1000L;
        StringBuilder sb = new StringBuilder();
        if (y > 0L) {
            sb.append(y);
            sb.append('y');
            sb.append(d);
            sb.append('d');
        }
        if (d > 0L) {
            sb.append(d);
            sb.append('d');
            sb.append(h);
            sb.append('h');
        } else if (h > 0L) {
            sb.append(h);
            sb.append('h');
            sb.append(m);
            sb.append('m');
        } else if (m > 0L) {
            sb.append(m);
            sb.append('m');
            sb.append(s);
            sb.append('s');
        } else if (s > 9L) {
            sb.append(s);
            sb.append('s');
        } else if (s > 0L) {
            sb.append((double)(this.ms / 100L) / 10.0);
            sb.append('s');
        } else {
            sb.append((double)this.ms / 1000.0);
            sb.append('s');
        }
        return sb.toString();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Deprecated
    public static void start(String s) {
    }

    @Deprecated
    public static void accumStop(String s) {
    }
}

