/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util.functional;

import edu.berkeley.nlp.util.functional.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates {
    public static <I> Predicate<I> getTruePredicate() {
        return new Predicate<I>(){

            @Override
            public Boolean apply(I input) {
                return true;
            }
        };
    }

    public static <I> Predicate<I> getInversePredicate(final Predicate<I> pred) {
        return new Predicate<I>(){

            @Override
            public Boolean apply(I input) {
                return (Boolean)pred.apply(input) == false;
            }
        };
    }

    public static <I> Predicate<I> getOrPredicate(final Predicate<I> ... preds) {
        return new Predicate<I>(){

            @Override
            public Boolean apply(I input) {
                for (Predicate pred : preds) {
                    if (!((Boolean)pred.apply(input)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate getNonNullPredicate() {
        return new Predicate(){

            public Boolean apply(Object input) {
                return input != null;
            }
        };
    }

    public static <I> Predicate<I> getAndPredicate(final Predicate<I> ... preds) {
        return new Predicate<I>(){

            @Override
            public Boolean apply(I input) {
                for (Predicate pred : preds) {
                    if (((Boolean)pred.apply(input)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

