/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.app.antsforage.AntsForage;
import sim.app.antsforage.DecisionInfo;
import sim.app.antsforage.DecisionMaker;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.field.grid.DoubleGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Int2D;

public class Ant
extends OvalPortrayal2D
implements Steppable {
    public static final int ADD_PHEROMONE = 0;
    public static final int MAX_PHEROMONE = 1;
    public static final int LOCAL_PHEROMONE = 2;
    public static final int PHEROMONE_TYPE = 2;
    public static final boolean TOROIDAL_WORLD = false;
    public static final int ORIENTED_ANT = 0;
    public static final int NSEW_ANT = 1;
    public static final int EIGHT_NEIGHBOURS_ANT = 2;
    public static final int ANT_TYPE = 0;
    public static final boolean GREEDY_REPOSITIONING = true;
    public static final boolean GREEDY_EXPLORATION = true;
    public static final int N = 0;
    public static final int NE = 1;
    public static final int E = 2;
    public static final int SE = 3;
    public static final int S = 4;
    public static final int SW = 5;
    public static final int W = 6;
    public static final int NW = 7;
    public double pheromoneToLeaveBehind;
    public double minPheromone;
    public double maxPheromone;
    public int timeToLive;
    double subtractingRatio;
    double pheromoneRatio;
    int orientation;
    public boolean hasFoodItem;
    public static final double ANT_K = 0.001;
    public static final double ANT_N = 10.0;
    boolean justCreated;
    private Color noFoodColor = Color.black;
    private Color foodColor = Color.red;
    public Stoppable toDiePointer = null;

    public boolean getHasFoodItem() {
        return this.hasFoodItem;
    }

    public void setHasFoodItem(boolean val) {
        this.hasFoodItem = val;
    }

    public Ant(int orientation, double pheromoneToLeaveBehind, double minPheromone, double maxPheromone, int timeToLive) {
        this.orientation = orientation;
        this.pheromoneToLeaveBehind = pheromoneToLeaveBehind;
        this.minPheromone = minPheromone;
        this.maxPheromone = maxPheromone;
        this.timeToLive = timeToLive;
        this.subtractingRatio = 1.0 / (double)timeToLive * maxPheromone;
        this.pheromoneRatio = 1.0 * maxPheromone;
        this.hasFoodItem = false;
        this.justCreated = true;
    }

    protected void addInformation(SimState state, int x, int y, int orientation) {
        AntsForage af = (AntsForage)state;
        DecisionInfo di = af.decisionInfo;
        DecisionMaker decisionMaker = af.decisionMaker;
        if (x < 0 || x >= 100 || y < 0 || y >= 100) {
            return;
        }
        if ((af.buggrid.getObjectsAtLocation(x, y) == null || af.buggrid.getObjectsAtLocation((int)x, (int)y).numObjs < 10) && af.obstacles.field[x][y] <= 0.5) {
            di.position.x = x;
            di.position.y = y;
            di.orientation = orientation;
            di.homePheromoneAmount = 0.001 + af.toHomeGrid.field[di.position.x][di.position.y];
            di.foodPheromoneAmount = 0.001 + af.toFoodGrid.field[di.position.x][di.position.y];
            decisionMaker.addInfo(di);
        }
    }

    public DecisionInfo decideAction(SimState state, int myx, int myy, int orientation) {
        AntsForage af = (AntsForage)state;
        DecisionMaker decisionMaker = af.decisionMaker;
        decisionMaker.reset();
        switch (0) {
            case 0: {
                switch (orientation) {
                    case 0: {
                        this.addInformation(state, myx - 1, myy + 1, (orientation + 7) % 8);
                        this.addInformation(state, myx, myy + 1, orientation);
                        this.addInformation(state, myx + 1, myy + 1, (orientation + 1) % 8);
                        break;
                    }
                    case 1: {
                        this.addInformation(state, myx, myy + 1, (orientation + 7) % 8);
                        this.addInformation(state, myx + 1, myy + 1, orientation);
                        this.addInformation(state, myx + 1, myy, (orientation + 1) % 8);
                        break;
                    }
                    case 2: {
                        this.addInformation(state, myx + 1, myy + 1, (orientation + 7) % 8);
                        this.addInformation(state, myx + 1, myy, orientation);
                        this.addInformation(state, myx + 1, myy - 1, (orientation + 1) % 8);
                        break;
                    }
                    case 3: {
                        this.addInformation(state, myx + 1, myy, (orientation + 7) % 8);
                        this.addInformation(state, myx + 1, myy - 1, orientation);
                        this.addInformation(state, myx, myy - 1, (orientation + 1) % 8);
                        break;
                    }
                    case 4: {
                        this.addInformation(state, myx + 1, myy - 1, (orientation + 7) % 8);
                        this.addInformation(state, myx, myy - 1, orientation);
                        this.addInformation(state, myx - 1, myy - 1, (orientation + 1) % 8);
                        break;
                    }
                    case 5: {
                        this.addInformation(state, myx, myy - 1, (orientation + 7) % 8);
                        this.addInformation(state, myx - 1, myy - 1, orientation);
                        this.addInformation(state, myx - 1, myy, (orientation + 1) % 8);
                        break;
                    }
                    case 6: {
                        this.addInformation(state, myx - 1, myy - 1, (orientation + 7) % 8);
                        this.addInformation(state, myx - 1, myy, orientation);
                        this.addInformation(state, myx - 1, myy + 1, (orientation + 1) % 8);
                        break;
                    }
                    case 7: {
                        this.addInformation(state, myx - 1, myy, (orientation + 7) % 8);
                        this.addInformation(state, myx - 1, myy + 1, orientation);
                        this.addInformation(state, myx, myy + 1, (orientation + 1) % 8);
                    }
                }
                break;
            }
            case 1: {
                this.addInformation(state, myx - 1, myy, (orientation + 7) % 8);
                this.addInformation(state, myx + 1, myy, (orientation + 7) % 8);
                this.addInformation(state, myx, myy - 1, (orientation + 7) % 8);
                this.addInformation(state, myx, myy + 1, (orientation + 7) % 8);
                break;
            }
            case 2: {
                this.addInformation(state, myx - 1, myy - 1, (orientation + 7) % 8);
                this.addInformation(state, myx - 1, myy, (orientation + 7) % 8);
                this.addInformation(state, myx - 1, myy + 1, (orientation + 7) % 8);
                this.addInformation(state, myx + 1, myy - 1, (orientation + 7) % 8);
                this.addInformation(state, myx + 1, myy, (orientation + 7) % 8);
                this.addInformation(state, myx + 1, myy + 1, (orientation + 7) % 8);
                this.addInformation(state, myx - 1, myy, (orientation + 7) % 8);
                this.addInformation(state, myx + 1, myy, (orientation + 7) % 8);
            }
        }
        if (this.hasFoodItem) {
            return decisionMaker.getHomeGreedyDecision(state);
        }
        return decisionMaker.getFoodGreedyDecision(state);
    }

    public void addPheromone(DoubleGrid2D grid, int x, int y, double pheromone) {
        switch (2) {
            case 0: {
                double[] dArray = grid.field[x];
                int n = y;
                dArray[n] = dArray[n] + Math.abs(this.pheromoneToLeaveBehind);
                if (!(grid.field[x][y] > this.maxPheromone)) break;
                grid.field[x][y] = this.maxPheromone;
                break;
            }
            case 1: {
                grid.field[x][y] = Math.max(grid.field[x][y], pheromone);
                break;
            }
            case 2: {
                double amount = Math.max(grid.field[x][y], pheromone);
                if (x > 0 && y > 0) {
                    amount = Math.max(Math.max(grid.field[x - 1][y - 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (x > 0) {
                    amount = Math.max(Math.max(grid.field[x - 1][y] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (x > 0 && y < grid.field[x].length - 1) {
                    amount = Math.max(Math.max(grid.field[x - 1][y + 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (y > 0) {
                    amount = Math.max(Math.max(grid.field[x][y - 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (y < grid.field.length - 1) {
                    amount = Math.max(Math.max(grid.field[x][y + 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (x < grid.field.length - 1 && y > 0) {
                    amount = Math.max(Math.max(grid.field[x + 1][y - 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (x < grid.field.length - 1) {
                    amount = Math.max(Math.max(grid.field[x + 1][y] - this.subtractingRatio, this.minPheromone), amount);
                }
                if (x < grid.field.length - 1 && y < grid.field[x].length - 1) {
                    amount = Math.max(Math.max(grid.field[x + 1][y + 1] - this.subtractingRatio, this.minPheromone), amount);
                }
                grid.field[x][y] = amount;
                this.pheromoneRatio = amount;
            }
        }
    }

    public DecisionInfo decideGreedyAction(SimState state, int myx, int myy, int orientation) {
        AntsForage af = (AntsForage)state;
        DecisionMaker decisionMaker = af.decisionMaker;
        decisionMaker.reset();
        this.addInformation(state, myx, myy + 1, 0);
        this.addInformation(state, myx + 1, myy + 1, 1);
        this.addInformation(state, myx + 1, myy, 2);
        this.addInformation(state, myx + 1, myy - 1, 3);
        this.addInformation(state, myx, myy - 1, 4);
        this.addInformation(state, myx - 1, myy - 1, 5);
        this.addInformation(state, myx - 1, myy, 6);
        this.addInformation(state, myx - 1, myy + 1, 7);
        if (this.hasFoodItem) {
            return decisionMaker.getHomeGreedyDecision(state);
        }
        return decisionMaker.getFoodGreedyDecision(state);
    }

    public void step(SimState state) {
        int besto;
        int besty;
        int bestx;
        AntsForage af = (AntsForage)state;
        DecisionMaker decisionMaker = af.decisionMaker;
        Int2D location = af.buggrid.getObjectLocation(this);
        int myx = location.x;
        int myy = location.y;
        if (this.justCreated) {
            DecisionInfo temp = this.decideGreedyAction(state, myx, myy, this.orientation);
            if (temp == null) {
                return;
            }
            this.orientation = temp.orientation;
            this.justCreated = false;
        }
        DecisionInfo movingDecision = null;
        if (this.hasFoodItem) {
            movingDecision = this.decideGreedyAction(state, myx, myy, this.orientation);
        } else {
            decisionMaker.reset();
            this.addInformation(state, myx, myy + 1, 0);
            this.addInformation(state, myx + 1, myy + 1, 1);
            this.addInformation(state, myx + 1, myy, 2);
            this.addInformation(state, myx + 1, myy - 1, 3);
            this.addInformation(state, myx, myy - 1, 4);
            this.addInformation(state, myx - 1, myy - 1, 5);
            this.addInformation(state, myx - 1, myy, 6);
            this.addInformation(state, myx - 1, myy + 1, 7);
            int max = 0;
            int howMany = 1;
            for (int i = 1; i < decisionMaker.numInfos; ++i) {
                if (decisionMaker.info[max].foodPheromoneAmount == decisionMaker.info[i].foodPheromoneAmount) {
                    ++howMany;
                    continue;
                }
                if (!(decisionMaker.info[max].foodPheromoneAmount < decisionMaker.info[i].foodPheromoneAmount)) continue;
                max = i;
                howMany = 1;
            }
            movingDecision = howMany == 1 ? this.decideGreedyAction(state, myx, myy, this.orientation) : this.decideAction(state, myx, myy, this.orientation);
        }
        if (movingDecision == null) {
            movingDecision = this.decideGreedyAction(state, myx, myy, this.orientation);
            if (movingDecision == null) {
                bestx = myx;
                besty = myy;
                besto = this.orientation;
            } else {
                bestx = movingDecision.position.x;
                besty = movingDecision.position.y;
                besto = movingDecision.orientation;
            }
        } else {
            bestx = movingDecision.position.x;
            besty = movingDecision.position.y;
            besto = movingDecision.orientation;
        }
        if (bestx != myx || besty != myy) {
            if (this.hasFoodItem) {
                this.addPheromone(af.toFoodGrid, myx, myy, this.pheromoneRatio);
            } else {
                this.addPheromone(af.toHomeGrid, myx, myy, this.pheromoneRatio);
            }
            this.pheromoneRatio = bestx != myx && besty != myy ? (this.pheromoneRatio -= this.subtractingRatio * 1.4142) : (this.pheromoneRatio -= this.subtractingRatio);
            if (this.pheromoneRatio < 0.0) {
                this.die(state);
                return;
            }
            af.buggrid.setObjectLocation(this, bestx, besty);
            this.orientation = besto;
            if (besty >= 75 && besty <= 75 && bestx >= 75 && bestx <= 75) {
                if (this.hasFoodItem) {
                    ++af.foodCollected;
                    this.hasFoodItem = false;
                    this.pheromoneRatio = 1.0 * this.maxPheromone;
                    DecisionInfo temp = this.decideGreedyAction(state, myx, myy, this.orientation);
                    this.orientation = temp != null ? temp.orientation : (this.orientation + 4) % 8;
                }
            } else if (besty >= 25 && besty <= 25 && bestx >= 25 && bestx <= 25 && !this.hasFoodItem) {
                this.hasFoodItem = true;
                this.pheromoneRatio = 1.0 * this.maxPheromone;
                DecisionInfo temp = this.decideGreedyAction(state, myx, myy, this.orientation);
                this.orientation = temp != null ? temp.orientation : (this.orientation + 4) % 8;
            }
            --this.timeToLive;
            if (this.timeToLive <= 0) {
                this.die(state);
                return;
            }
        }
    }

    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.hasFoodItem) {
            graphics.setColor(this.foodColor);
        } else {
            graphics.setColor(this.noFoodColor);
        }
        int x = (int)(info.draw.x - info.draw.width / 2.0);
        int y = (int)(info.draw.y - info.draw.height / 2.0);
        int width = (int)info.draw.width;
        int height = (int)info.draw.height;
        graphics.fillOval(x, y, width, height);
    }

    public void die(SimState state) {
        AntsForage antsforage = (AntsForage)state;
        --antsforage.numberOfAnts;
        antsforage.buggrid.remove(this);
        if (this.toDiePointer != null) {
            this.toDiePointer.stop();
        }
    }
}

