/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import sim.app.antsforage.Ant;
import sim.app.antsforage.DecisionInfo;
import sim.app.antsforage.DecisionMaker;
import sim.app.antsforage.Diffuser;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;

public class AntsForage
extends SimState {
    public static final int HOME_XMIN = 75;
    public static final int HOME_XMAX = 75;
    public static final int HOME_YMIN = 75;
    public static final int HOME_YMAX = 75;
    public static final int FOOD_XMIN = 25;
    public static final int FOOD_XMAX = 25;
    public static final int FOOD_YMIN = 25;
    public static final int FOOD_YMAX = 25;
    public static final int MAX_ANTS_PER_LOCATION = 10;
    public static final int TIME_TO_LIVE = 1000;
    public static final int NEW_ANTS_PER_TIME_STEP = 2;
    public static final int MAX_ANTS = 1000;
    public static final int INITIALANTS = 2;
    public static final double MIN_PHEROMONE = 0.0;
    public static final double MAX_PHEROMONE = 1000.0;
    public static final double PHEROMONE_TO_LEAVE_BEHIND = 1.0;
    public static final double EVAPORATE_CONSTANT = 1.0E-4;
    public static final double DIFFUSION_CONSTANT = 1.0E-4;
    public static final int GRID_HEIGHT = 100;
    public static final int GRID_WIDTH = 100;
    public static final int NO_OBSTACLES = 0;
    public static final int ONE_OBSTACLE = 1;
    public static final int TWO_OBSTACLES = 2;
    public static final int ONE_LONG_OBSTACLE = 3;
    public static final int OBSTACLES = 2;
    public DoubleGrid2D sites = new DoubleGrid2D(100, 100, 0.0);
    public DoubleGrid2D toFoodGrid = new DoubleGrid2D(100, 100, 0.0);
    public DoubleGrid2D toHomeGrid = new DoubleGrid2D(100, 100, 0.0);
    public DoubleGrid2D valgrid2 = new DoubleGrid2D(100, 100, 0.0);
    public SparseGrid2D buggrid = new SparseGrid2D(100, 100);
    public DoubleGrid2D obstacles = new DoubleGrid2D(100, 100, 0.0);
    DecisionMaker decisionMaker = new DecisionMaker();
    DecisionInfo decisionInfo = new DecisionInfo();
    public int foodCollected = 0;
    public int numberOfAnts = 0;

    public AntsForage(long seed) {
        super(seed);
    }

    public void start() {
        int y;
        int x;
        super.start();
        this.sites = new DoubleGrid2D(100, 100, 0.0);
        this.toFoodGrid = new DoubleGrid2D(100, 100, 0.0);
        this.toHomeGrid = new DoubleGrid2D(100, 100, 0.0);
        this.valgrid2 = new DoubleGrid2D(100, 100, 0.0);
        this.buggrid = new SparseGrid2D(100, 100);
        this.obstacles = new DoubleGrid2D(100, 100, 0.0);
        this.foodCollected = 0;
        switch (2) {
            case 0: {
                break;
            }
            case 1: {
                for (x = 0; x < 100; ++x) {
                    for (y = 0; y < 100; ++y) {
                        this.obstacles.field[x][y] = 0.0;
                        if (!(((double)(x - 55) * 0.707 + (double)(y - 35) * 0.707) * ((double)(x - 55) * 0.707 + (double)(y - 35) * 0.707) / 36.0 + ((double)(x - 55) * 0.707 - (double)(y - 35) * 0.707) * ((double)(x - 55) * 0.707 - (double)(y - 35) * 0.707) / 1024.0 <= 1.0)) continue;
                        this.obstacles.field[x][y] = 1.0;
                    }
                }
                break;
            }
            case 2: {
                for (x = 0; x < 100; ++x) {
                    for (y = 0; y < 100; ++y) {
                        this.obstacles.field[x][y] = 0.0;
                        if (((double)(x - 45) * 0.707 + (double)(y - 25) * 0.707) * ((double)(x - 45) * 0.707 + (double)(y - 25) * 0.707) / 36.0 + ((double)(x - 45) * 0.707 - (double)(y - 25) * 0.707) * ((double)(x - 45) * 0.707 - (double)(y - 25) * 0.707) / 1024.0 <= 1.0) {
                            this.obstacles.field[x][y] = 1.0;
                        }
                        if (!(((double)(x - 35) * 0.707 + (double)(y - 70) * 0.707) * ((double)(x - 35) * 0.707 + (double)(y - 70) * 0.707) / 36.0 + ((double)(x - 35) * 0.707 - (double)(y - 70) * 0.707) * ((double)(x - 35) * 0.707 - (double)(y - 70) * 0.707) / 1024.0 <= 1.0)) continue;
                        this.obstacles.field[x][y] = 1.0;
                    }
                }
                break;
            }
            case 3: {
                for (x = 0; x < 100; ++x) {
                    for (y = 0; y < 100; ++y) {
                        this.obstacles.field[x][y] = 0.0;
                        if ((x - 60) * (x - 60) / 1600 + (y - 50) * (y - 50) / 25 > 1) continue;
                        this.obstacles.field[x][y] = 1.0;
                    }
                }
                break;
            }
        }
        for (x = 75; x <= 75; ++x) {
            for (y = 75; y <= 75; ++y) {
                this.sites.field[x][y] = 1.0;
            }
        }
        for (x = 25; x <= 25; ++x) {
            for (y = 25; y <= 25; ++y) {
                this.sites.field[x][y] = 0.5;
            }
        }
        Steppable antFarm = new Steppable(){

            public void step(SimState state) {
                for (int x = 0; x < 2 && AntsForage.this.numberOfAnts < 1000; ++x) {
                    Ant bug = new Ant(AntsForage.this.random.nextInt(8), 1.0, 0.0, 1000.0, 1000);
                    AntsForage.this.buggrid.setObjectLocation(bug, 75, 75);
                    bug.toDiePointer = AntsForage.this.schedule.scheduleRepeating(bug);
                    ++AntsForage.this.numberOfAnts;
                }
            }
        };
        this.numberOfAnts = 0;
        for (int x2 = 0; x2 < 2; ++x2) {
            Ant bug = new Ant(this.random.nextInt(8), 1.0, 0.0, 1000.0, 1000);
            this.buggrid.setObjectLocation(bug, 75, 75);
            bug.toDiePointer = this.schedule.scheduleRepeating(bug);
            ++this.numberOfAnts;
        }
        this.schedule.scheduleRepeating(0.0, 1, new Diffuser(this.toHomeGrid, this.valgrid2, 1.0E-4, 1.0E-4), 1.0);
        this.schedule.scheduleRepeating(0.0, 1, new Diffuser(this.toFoodGrid, this.valgrid2, 1.0E-4, 1.0E-4), 1.0);
        this.schedule.scheduleRepeating(0.0, 1, antFarm, 1.0);
    }

    public static void main(String[] args) {
        AntsForage.doLoop(AntsForage.class, args);
        System.exit(0);
    }
}

