/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import java.io.Serializable;
import sim.app.antsforage.DecisionInfo;
import sim.engine.SimState;

public class DecisionMaker
implements Serializable {
    public DecisionInfo[] info = new DecisionInfo[8];
    public int numInfos = 0;

    public DecisionMaker() {
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i] = new DecisionInfo();
        }
    }

    public void reset() {
        this.numInfos = 0;
    }

    public void addInfo(DecisionInfo di) {
        this.info[this.numInfos].position.x = di.position.x;
        this.info[this.numInfos].position.y = di.position.y;
        this.info[this.numInfos].orientation = di.orientation;
        this.info[this.numInfos].homePheromoneAmount = di.homePheromoneAmount;
        this.info[this.numInfos].foodPheromoneAmount = di.foodPheromoneAmount;
        ++this.numInfos;
    }

    public DecisionInfo getHomeDecision(SimState state) {
        for (int i = 0; i < this.numInfos; ++i) {
            this.processForHomeDecision(this.info[i]);
        }
        return this.getDecision(state);
    }

    public DecisionInfo getFoodDecision(SimState state) {
        for (int i = 0; i < this.numInfos; ++i) {
            this.processForFoodDecision(this.info[i]);
        }
        return this.getDecision(state);
    }

    protected void processForHomeDecision(DecisionInfo info) {
        info.profit = info.homePheromoneAmount;
    }

    protected void processForFoodDecision(DecisionInfo info) {
        info.profit = info.foodPheromoneAmount;
    }

    public DecisionInfo getDecision(SimState state) {
        int index;
        int x;
        if (this.numInfos == 0) {
            return null;
        }
        double sum = 0.0;
        for (x = 0; x < this.numInfos; ++x) {
            if (this.info[x].profit < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            sum += this.info[x].profit;
        }
        if (sum == 0.0) {
            throw new ArithmeticException("Distribution has all 0 probabilities");
        }
        for (x = 0; x < this.numInfos; ++x) {
            this.info[x].profit /= sum;
        }
        sum = 0.0;
        for (x = 0; x < this.numInfos; ++x) {
            this.info[x].profit = sum += this.info[x].profit;
        }
        for (x = this.numInfos - 1; x > 0 && this.info[x].profit == this.info[x - 1].profit; --x) {
            this.info[x].profit = 1.0;
        }
        this.info[x].profit = 1.0;
        double prob = state.random.nextDouble();
        if (this.numInfos == 1) {
            return this.info[0];
        }
        for (x = 0; x < this.numInfos - 1; ++x) {
            int index2;
            if (!(this.info[x].profit > prob)) continue;
            if (this.info[index2].profit == 0.0) {
                for (index2 = x; index2 < this.numInfos - 1 && this.info[index2].profit == 0.0; ++index2) {
                }
            } else {
                while (index2 > 0 && this.info[index2].profit == this.info[index2 - 1].profit) {
                    --index2;
                }
            }
            return this.info[index2];
        }
        if (this.info[index].profit == 0.0) {
            for (index = this.numInfos - 1; index < this.numInfos - 1 && this.info[index].profit == 0.0; ++index) {
            }
        } else {
            while (index > 0 && this.info[index].profit == this.info[index - 1].profit) {
                --index;
            }
        }
        return this.info[index];
    }

    public DecisionInfo getHomeGreedyDecision(SimState state) {
        int i;
        if (this.numInfos == 0) {
            return null;
        }
        for (i = 0; i < this.numInfos; ++i) {
            this.processForHomeDecision(this.info[i]);
        }
        int index = 0;
        for (i = 0; i < this.numInfos; ++i) {
            if (!(this.info[i].profit > this.info[index].profit)) continue;
            index = i;
        }
        int howMany = 0;
        for (int i2 = 0; i2 < this.numInfos; ++i2) {
            if (this.info[i2].profit != this.info[index].profit) continue;
            ++howMany;
        }
        int x = state.random.nextInt(howMany);
        for (int i3 = 0; i3 < this.numInfos; ++i3) {
            if (this.info[i3].profit != this.info[index].profit) continue;
            if (x == 0) {
                return this.info[i3];
            }
            --x;
        }
        return null;
    }

    public DecisionInfo getFoodGreedyDecision(SimState state) {
        int i;
        if (this.numInfos == 0) {
            return null;
        }
        for (i = 0; i < this.numInfos; ++i) {
            this.processForFoodDecision(this.info[i]);
        }
        int index = 0;
        for (i = 0; i < this.numInfos; ++i) {
            if (!(this.info[i].profit > this.info[index].profit)) continue;
            index = i;
        }
        int howMany = 0;
        for (int i2 = 0; i2 < this.numInfos; ++i2) {
            if (this.info[i2].profit != this.info[index].profit) continue;
            ++howMany;
        }
        int x = state.random.nextInt(howMany);
        for (int i3 = 0; i3 < this.numInfos; ++i3) {
            if (this.info[i3].profit != this.info[index].profit) continue;
            if (x == 0) {
                return this.info[i3];
            }
            --x;
        }
        return null;
    }
}

