/*
 * Decompiled with CFR 0.152.
 */
package sim.app.antsforage;

import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;

public class Diffuser
implements Steppable {
    DoubleGrid2D updateGrid;
    DoubleGrid2D tempGrid;
    double evaporationRate;
    double diffusionRate;

    public Diffuser(DoubleGrid2D updateGrid, DoubleGrid2D tempGrid, double evaporationRate, double diffusionRate) {
        this.updateGrid = updateGrid;
        this.tempGrid = tempGrid;
        this.evaporationRate = evaporationRate;
        this.diffusionRate = diffusionRate;
    }

    public void step(SimState state) {
        DoubleGrid2D _valgrid = this.updateGrid;
        double[][] _valgrid_field = this.updateGrid.field;
        double[][] _valgrid2_field = this.tempGrid.field;
        int _gridWidth = _valgrid.getWidth();
        int _gridHeight = _valgrid.getHeight();
        double _evaporationRate = this.evaporationRate;
        double _diffusionRate = this.diffusionRate;
        double[] _past = _valgrid_field[_valgrid.stx(-1)];
        double[] _current = _valgrid_field[0];
        for (int x = 0; x < _gridWidth; ++x) {
            double[] _next = _valgrid_field[_valgrid.stx(x + 1)];
            double[] _put = _valgrid2_field[_valgrid.stx(x)];
            int yminus1 = _valgrid.sty(-1);
            int y = 0;
            while (y < _gridHeight) {
                int yplus1 = _valgrid.sty(y + 1);
                double average = (_past[yminus1] + _past[y] + _past[yplus1] + _current[yminus1] + _current[y] + _current[yplus1] + _next[yminus1] + _next[y] + _next[yplus1]) / 9.0;
                _put[y] = (1.0 - _evaporationRate) * (_current[y] + _diffusionRate * (average - _current[y]));
                yminus1 = y++;
            }
            _past = _current;
            _current = _next;
        }
        _valgrid.setTo(this.tempGrid);
    }
}

