/*
 * Decompiled with CFR 0.152.
 */
package sim.app.balls3d;

import sim.app.balls3d.Balls3D;
import sim.app.balls3d.Band;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous3D;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.Double3D;

public class Ball
implements Steppable {
    public double forcex;
    public double forcey;
    public double forcez;
    public double mass;
    public double oldMass;
    public double velocityx;
    public double velocityy;
    public double velocityz;
    public boolean collision;
    public boolean oldCollision;
    public double diameter;
    Bag myBag = new Bag();

    public double getVelocityX() {
        return this.velocityx;
    }

    public void setVelocityX(double val) {
        this.velocityx = val;
    }

    public double getVelocityY() {
        return this.velocityy;
    }

    public void setVelocityY(double val) {
        this.velocityy = val;
    }

    public double getVelocityZ() {
        return this.velocityz;
    }

    public void setVelocityZ(double val) {
        this.velocityz = val;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double val) {
        if (val > 0.0) {
            this.mass = val;
            this.diameter = Math.sqrt(val);
        }
    }

    public Ball(double vx, double vy, double vz, double m) {
        this.velocityx = vx;
        this.velocityy = vy;
        this.velocityz = vz;
        this.mass = m;
        this.oldMass = m;
        this.diameter = Math.sqrt(m);
    }

    public void computeCollision(Balls3D tut) {
        Double3D me = tut.balls.getObjectLocation(this);
        Bag b = tut.balls.getObjectsExactlyWithinDistance(me, 5.0);
        this.collision = b.numObjs > 1;
    }

    public void addForce(Double3D otherBallLoc, Double3D myLoc, Band band) {
        double dx = otherBallLoc.x - myLoc.x;
        double dy = otherBallLoc.y - myLoc.y;
        double dz = otherBallLoc.z - myLoc.z;
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double l = band.laxDistance;
        double k = band.strength / 512.0;
        double forcemagnitude = (len - l) * k;
        if (len - l > 0.0) {
            this.forcex += dx * forcemagnitude / len;
            this.forcey += dy * forcemagnitude / len;
            this.forcez += dz * forcemagnitude / len;
        }
    }

    public void computeForce(SimState state) {
        Double3D him;
        Ball other;
        Band b;
        Edge e;
        int x;
        Balls3D tut = (Balls3D)state;
        Network bands = tut.bands;
        Continuous3D balls = tut.balls;
        Double3D me = balls.getObjectLocation(this);
        this.forcex = 0.0;
        this.forcey = 0.0;
        this.forcez = 0.0;
        Bag in = bands.getEdgesIn(this);
        Bag out = bands.getEdgesOut(this);
        if (in != null) {
            for (x = 0; x < in.numObjs; ++x) {
                e = (Edge)in.objs[x];
                b = (Band)e.info;
                other = (Ball)e.from();
                him = balls.getObjectLocation(other);
                this.addForce(him, me, b);
            }
        }
        if (out != null) {
            for (x = 0; x < out.numObjs; ++x) {
                e = (Edge)out.objs[x];
                b = (Band)e.info;
                other = (Ball)e.to();
                him = balls.getObjectLocation(other);
                this.addForce(him, me, b);
            }
        }
    }

    public void step(SimState state) {
        Balls3D tut = (Balls3D)state;
        double ax = this.forcex / this.mass;
        double ay = this.forcey / this.mass;
        double az = this.forcez / this.mass;
        this.velocityx += ax;
        this.velocityy += ay;
        this.velocityz += az;
        Double3D pos = tut.balls.getObjectLocation(this);
        Double3D newpos = new Double3D(pos.x + this.velocityx, pos.y + this.velocityy, pos.z + this.velocityz);
        tut.balls.setObjectLocation((Object)this, newpos);
        this.computeCollision(tut);
    }
}

