/*
 * Decompiled with CFR 0.152.
 */
package sim.app.cto;

import sim.app.cto.CooperativeObservation;
import sim.util.Double2D;

public class KMeansEngine {
    static final double ALFA = 0.25;
    Double2D[] clusterPoints;
    Boolean[] usable;
    Double2D[] means;
    int[] labels;
    int[] n;
    double[] weight;
    CooperativeObservation co;

    public KMeansEngine(CooperativeObservation co) {
        this.co = co;
        this.clusterPoints = new Double2D[10];
        this.usable = new Boolean[10];
        this.means = new Double2D[10];
        for (int i = 0; i < 10; ++i) {
            this.clusterPoints[i] = new Double2D();
            this.means[i] = new Double2D();
            this.usable[i] = Boolean.FALSE;
        }
        this.labels = new int[40];
        this.n = new int[10];
        this.weight = new double[10];
        Thread thread = new Thread(){

            public void run() {
                KMeansEngine.this.doKMeans();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double2D getGoalPosition(int id) {
        Boolean bl = this.usable[id];
        synchronized (bl) {
            if (this.usable[id].booleanValue()) {
                return this.clusterPoints[id];
            }
            return null;
        }
    }

    public final double distanceBetweenPointsSQR(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doKMeans() {
        while (true) {
            int i;
            for (i = 0; i < 10; ++i) {
                this.weight[i] = 0.0;
                if (this.means[i].x == 0.0 && this.means[i].y == 0.0) {
                    this.clusterPoints[i] = this.means[i];
                }
                this.means[i] = this.co.agentPos[i];
            }
            for (i = 0; i < 40; ++i) {
                int min = -1;
                double distance = -1.0;
                for (int j = 0; j < 10; ++j) {
                    double currDist = this.distanceBetweenPointsSQR(this.co.targetPos[i].x, this.co.targetPos[i].y, this.co.agentPos[j].x, this.co.agentPos[j].y);
                    if (distance != -1.0 && !(distance > currDist)) continue;
                    min = j;
                    distance = currDist;
                }
                this.labels[i] = min;
            }
            for (i = 0; i < 10; ++i) {
                this.means[i] = new Double2D(0.0, 0.0);
                this.n[i] = 0;
            }
            for (i = 0; i < 40; ++i) {
                if (this.labels[i] == -1) continue;
                this.means[this.labels[i]] = new Double2D(this.means[this.labels[i]].x + this.co.targetPos[i].x, this.means[this.labels[i]].y + this.co.targetPos[i].y);
                int n = this.labels[i];
                this.n[n] = this.n[n] + 1;
            }
            for (i = 0; i < 10; ++i) {
                Boolean bl = this.usable[i];
                synchronized (bl) {
                    if (this.n[i] != 0) {
                        this.means[i] = new Double2D(this.means[i].x / (double)this.n[i], this.means[i].y / (double)this.n[i]);
                        this.clusterPoints[i] = new Double2D(0.75 * this.clusterPoints[i].x + 0.25 * this.means[i].x, 0.75 * this.clusterPoints[i].y + 0.25 * this.means[i].y);
                        this.usable[i] = Boolean.TRUE;
                    } else {
                        this.usable[i] = Boolean.FALSE;
                    }
                    continue;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

