/*
 * Decompiled with CFR 0.152.
 */
package sim.app.flockers;

import ec.util.MersenneTwisterFast;
import sim.app.flockers.Flockers;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;
import sim.portrayal.Oriented2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Flocker
implements Steppable,
Oriented2D {
    public Double2D loc = new Double2D(0.0, 0.0);
    public Double2D lastd = new Double2D(0.0, 0.0);
    public Continuous2D flockers;
    public Flockers theFlock;
    public boolean dead = false;

    public Flocker(Double2D location) {
        this.loc = location;
    }

    public Bag getNeighbors() {
        return this.flockers.getObjectsExactlyWithinDistance(this.loc, this.theFlock.neighborhood, true);
    }

    public double getOrientation() {
        return this.orientation2D();
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean val) {
        this.dead = val;
    }

    public double orientation2D() {
        if (this.lastd.x == 0.0 && this.lastd.y == 0.0) {
            return 0.0;
        }
        return Math.atan2(this.lastd.y, this.lastd.x);
    }

    public Double2D momentum() {
        return this.lastd;
    }

    public Double2D consistency(Bag b, Continuous2D flockers) {
        if (b == null || b.numObjs == 0) {
            return new Double2D(0.0, 0.0);
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        int count = 0;
        for (i = 0; i < b.numObjs; ++i) {
            Flocker other = (Flocker)b.objs[i];
            if (other.dead) continue;
            double dx = flockers.tdx(this.loc.x, other.loc.x);
            double dy = flockers.tdy(this.loc.y, other.loc.y);
            Double2D m = ((Flocker)b.objs[i]).momentum();
            ++count;
            x += m.x;
            y += m.y;
        }
        if (count > 0) {
            x /= (double)count;
            y /= (double)count;
        }
        return new Double2D(x, y);
    }

    public Double2D cohesion(Bag b, Continuous2D flockers) {
        if (b == null || b.numObjs == 0) {
            return new Double2D(0.0, 0.0);
        }
        double x = 0.0;
        double y = 0.0;
        int count = 0;
        int i = 0;
        for (i = 0; i < b.numObjs; ++i) {
            Flocker other = (Flocker)b.objs[i];
            if (other.dead) continue;
            double dx = flockers.tdx(this.loc.x, other.loc.x);
            double dy = flockers.tdy(this.loc.y, other.loc.y);
            ++count;
            x += dx;
            y += dy;
        }
        if (count > 0) {
            x /= (double)count;
            y /= (double)count;
        }
        return new Double2D(-x / 10.0, -y / 10.0);
    }

    public Double2D avoidance(Bag b, Continuous2D flockers) {
        if (b == null || b.numObjs == 0) {
            return new Double2D(0.0, 0.0);
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        int count = 0;
        for (i = 0; i < b.numObjs; ++i) {
            Flocker other = (Flocker)b.objs[i];
            if (other == this) continue;
            double dx = flockers.tdx(this.loc.x, other.loc.x);
            double dy = flockers.tdy(this.loc.y, other.loc.y);
            double lensquared = dx * dx + dy * dy;
            ++count;
            x += dx / (lensquared * lensquared + 1.0);
            y += dy / (lensquared * lensquared + 1.0);
        }
        if (count > 0) {
            x /= (double)count;
            y /= (double)count;
        }
        return new Double2D(400.0 * x, 400.0 * y);
    }

    public Double2D randomness(MersenneTwisterFast r) {
        double x = r.nextDouble() * 2.0 - 1.0;
        double y = r.nextDouble() * 2.0 - 1.0;
        double l = Math.sqrt(x * x + y * y);
        return new Double2D(0.05 * x / l, 0.05 * y / l);
    }

    public void step(SimState state) {
        Flockers flock = (Flockers)state;
        this.loc = flock.flockers.getObjectLocation(this);
        if (this.dead) {
            return;
        }
        Bag b = this.getNeighbors();
        Double2D avoid = this.avoidance(b, flock.flockers);
        Double2D cohe = this.cohesion(b, flock.flockers);
        Double2D rand = this.randomness(flock.random);
        Double2D cons = this.consistency(b, flock.flockers);
        Double2D mome = this.momentum();
        double dx = flock.cohesion * cohe.x + flock.avoidance * avoid.x + flock.consistency * cons.x + flock.randomness * rand.x + flock.momentum * mome.x;
        double dy = flock.cohesion * cohe.y + flock.avoidance * avoid.y + flock.consistency * cons.y + flock.randomness * rand.y + flock.momentum * mome.y;
        double dis = Math.sqrt(dx * dx + dy * dy);
        if (dis > 0.0) {
            dx = dx / dis * flock.jump;
            dy = dy / dis * flock.jump;
        }
        this.lastd = new Double2D(dx, dy);
        this.loc = new Double2D(flock.flockers.stx(this.loc.x + dx), flock.flockers.sty(this.loc.y + dy));
        flock.flockers.setObjectLocation((Object)this, this.loc);
    }
}

