/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs;

import sim.app.heatbugs.Diffuser;
import sim.app.heatbugs.HeatBug;
import sim.app.heatbugs.ThreadedDiffuser;
import sim.engine.SimState;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.Interval;

public class HeatBugs
extends SimState {
    public double minIdealTemp = 17000.0;
    public double maxIdealTemp = 31000.0;
    public double minOutputHeat = 6000.0;
    public double maxOutputHeat = 10000.0;
    public double evaporationRate = 0.993;
    public double diffusionRate = 1.0;
    public static final double MAX_HEAT = 32000.0;
    public double randomMovementProbability = 0.1;
    public int gridHeight;
    public int gridWidth;
    public int bugCount;
    HeatBug[] bugs;
    public DoubleGrid2D valgrid;
    public DoubleGrid2D valgrid2;
    public SparseGrid2D buggrid;

    public double getMinimumIdealTemperature() {
        return this.minIdealTemp;
    }

    public void setMinimumIdealTemperature(double temp) {
        if (temp <= this.maxIdealTemp) {
            this.minIdealTemp = temp;
        }
    }

    public double getMaximumIdealTemperature() {
        return this.maxIdealTemp;
    }

    public void setMaximumIdealTemperature(double temp) {
        if (temp >= this.minIdealTemp) {
            this.maxIdealTemp = temp;
        }
    }

    public double getMinimumOutputHeat() {
        return this.minOutputHeat;
    }

    public void setMinimumOutputHeat(double temp) {
        if (temp <= this.maxOutputHeat) {
            this.minOutputHeat = temp;
        }
    }

    public double getMaximumOutputHeat() {
        return this.maxOutputHeat;
    }

    public void setMaximumOutputHeat(double temp) {
        if (temp >= this.minOutputHeat) {
            this.maxOutputHeat = temp;
        }
    }

    public double getEvaporationConstant() {
        return this.evaporationRate;
    }

    public void setEvaporationConstant(double temp) {
        if (temp >= 0.0 && temp <= 1.0) {
            this.evaporationRate = temp;
        }
    }

    public Object domEvaporationConstant() {
        return new Interval(0.0, 1.0);
    }

    public double getDiffusionConstant() {
        return this.diffusionRate;
    }

    public void setDiffusionConstant(double temp) {
        if (temp >= 0.0 && temp <= 1.0) {
            this.diffusionRate = temp;
        }
    }

    public Object domDiffusionConstant() {
        return new Interval(0.0, 1.0);
    }

    public double getRandomMovementProbability() {
        return this.randomMovementProbability;
    }

    public double[] getBugXPos() {
        try {
            double[] d = new double[this.bugs.length];
            for (int x = 0; x < this.bugs.length; ++x) {
                d[x] = this.buggrid.getObjectLocation((Object)this.bugs[x]).x;
            }
            return d;
        }
        catch (Exception e) {
            return new double[0];
        }
    }

    public double[] getBugYPos() {
        try {
            double[] d = new double[this.bugs.length];
            for (int x = 0; x < this.bugs.length; ++x) {
                d[x] = this.buggrid.getObjectLocation((Object)this.bugs[x]).y;
            }
            return d;
        }
        catch (Exception e) {
            return new double[0];
        }
    }

    public void setRandomMovementProbability(double t) {
        if (t >= 0.0 && t <= 1.0) {
            this.randomMovementProbability = t;
            for (int i = 0; i < this.bugCount; ++i) {
                if (this.bugs[i] == null) continue;
                this.bugs[i].setRandomMovementProbability(this.randomMovementProbability);
            }
        }
    }

    public Object domRandomMovementProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getMaximumHeat() {
        return 32000.0;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int val) {
        if (val > 0) {
            this.gridHeight = val;
        }
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int val) {
        if (val > 0) {
            this.gridWidth = val;
        }
    }

    public int getBugCount() {
        return this.bugCount;
    }

    public void setBugCount(int val) {
        if (val >= 0) {
            this.bugCount = val;
        }
    }

    public HeatBugs(long seed) {
        this(seed, 100, 100, 100);
    }

    public HeatBugs(long seed, int width, int height, int count) {
        super(seed);
        this.gridWidth = width;
        this.gridHeight = height;
        this.bugCount = count;
        this.createGrids();
    }

    protected void createGrids() {
        this.bugs = new HeatBug[this.bugCount];
        this.valgrid = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
        this.valgrid2 = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
        this.buggrid = new SparseGrid2D(this.gridWidth, this.gridHeight);
    }

    public void start() {
        super.start();
        this.createGrids();
        for (int x = 0; x < this.bugCount; ++x) {
            this.bugs[x] = new HeatBug(this.random.nextDouble() * (this.maxIdealTemp - this.minIdealTemp) + this.minIdealTemp, this.random.nextDouble() * (this.maxOutputHeat - this.minOutputHeat) + this.minOutputHeat, this.randomMovementProbability);
            this.buggrid.setObjectLocation(this.bugs[x], this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
            this.schedule.scheduleRepeating(this.bugs[x]);
        }
        if (HeatBugs.availableProcessors() > 1) {
            this.schedule.scheduleRepeating(0.0, 1, new ThreadedDiffuser(), 1.0);
        } else {
            this.schedule.scheduleRepeating(0.0, 1, new Diffuser(), 1.0);
        }
    }

    public static int availableProcessors() {
        Runtime runtime = Runtime.getRuntime();
        try {
            return (Integer)runtime.getClass().getMethod("availableProcessors", null).invoke((Object)runtime, (Object[])null);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static void main(String[] args) {
        HeatBugs.doLoop(HeatBugs.class, args);
        System.exit(0);
    }
}

