/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.event.MouseInputAdapter;
import sim.app.heatbugs.HeatBug;
import sim.app.heatbugs.HeatBugs;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.field.grid.SparseGrid2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.gui.SimpleColorMap;

public class HeatBugsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D heatPortrayal = new FastValueGridPortrayal2D("Heat");
    SparseGridPortrayal2D bugPortrayal = new SparseGridPortrayal2D();

    public static void main(String[] args) {
        HeatBugsWithUI heatbugs = new HeatBugsWithUI();
        Console c = new Console(heatbugs);
        c.setVisible(true);
    }

    public HeatBugsWithUI() {
        super(new HeatBugs(System.currentTimeMillis()));
    }

    public HeatBugsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "HeatBugs";
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.heatPortrayal.setMap(new SimpleColorMap(0.0, 32000.0, Color.black, Color.red));
        this.bugPortrayal.setPortrayalForAll(new OvalPortrayal2D(Color.white));
        this.heatPortrayal.setField(((HeatBugs)this.state).valgrid);
        this.bugPortrayal.setField(((HeatBugs)this.state).buggrid);
        this.display.reset();
        this.display.repaint();
    }

    public void init(final Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle(this.displayFrame.getTitle() + (HeatBugs.availableProcessors() > 1 ? " (Multiprocessor)" : ""));
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.heatPortrayal, "Heat");
        this.display.attach(this.bugPortrayal, "Bugs");
        this.display.setBackdrop(Color.black);
        MouseInputAdapter adapter = new MouseInputAdapter(){
            HeatBug bug = null;

            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                SparseGrid2D field = (SparseGrid2D)HeatBugsWithUI.this.bugPortrayal.getField();
                if (field == null) {
                    return;
                }
                this.bug = null;
                Rectangle2D.Double rect = new Rectangle2D.Double(point.x, point.y, 1.0, 1.0);
                Bag hit = new Bag();
                HeatBugsWithUI.this.bugPortrayal.hitObjects(HeatBugsWithUI.this.display.getDrawInfo2D((FieldPortrayal2D)HeatBugsWithUI.this.bugPortrayal, (Rectangle2D)rect), hit);
                if (hit.numObjs > 0) {
                    this.bug = (HeatBug)((LocationWrapper)hit.objs[hit.numObjs - 1]).getObject();
                }
            }

            public void mouseReleased(MouseEvent e) {
                this.bug = null;
            }

            public void mouseDragged(MouseEvent e) {
                Point point = e.getPoint();
                SparseGrid2D field = (SparseGrid2D)HeatBugsWithUI.this.bugPortrayal.getField();
                if (this.bug == null || field == null) {
                    return;
                }
                Int2D mouseLoc = HeatBugsWithUI.this.bugPortrayal.getLocation(HeatBugsWithUI.this.display.getDrawInfo2D((FieldPortrayal2D)HeatBugsWithUI.this.bugPortrayal, point));
                field.setObjectLocation((Object)this.bug, mouseLoc);
                c.refresh();
            }
        };
        this.display.insideDisplay.addMouseListener(adapter);
        this.display.insideDisplay.addMouseMotionListener(adapter);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

