/*
 * Decompiled with CFR 0.152.
 */
package sim.app.keepaway;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.keepaway.Ball;
import sim.app.keepaway.Bot;
import sim.app.keepaway.Keepaway;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;

public class KeepawayWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D entityPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        KeepawayWithUI botball = new KeepawayWithUI();
        Console c = new Console(botball);
        c.setVisible(true);
    }

    public KeepawayWithUI() {
        super(new Keepaway(System.currentTimeMillis()));
    }

    public KeepawayWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Keep-Away Soccer";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.entityPortrayal.setField(((Keepaway)this.state).fieldEnvironment);
        this.entityPortrayal.setPortrayalForClass(Bot.class, new RectanglePortrayal2D(Color.red));
        this.entityPortrayal.setPortrayalForClass(Ball.class, new OvalPortrayal2D(Color.white));
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.entityPortrayal, "Bots and Balls");
        this.display.setBackdrop(new Color(0, 80, 0));
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

