/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lightcycles;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import sim.app.lightcycles.Cycle;
import sim.app.lightcycles.LightCycles;
import sim.app.lightcycles.LightCyclesWithUI;
import sim.display.Console;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;

public class ControlUI {
    LightCyclesWithUI lcui;
    LightCycles lc;
    Cycle c;
    SparseGridPortrayal2D cyclePortrayal;

    public ControlUI(LightCyclesWithUI nlc, SparseGridPortrayal2D ncp) {
        this.lcui = nlc;
        this.lc = (LightCycles)this.lcui.state;
        this.cyclePortrayal = ncp;
        this.lcui.display.insideDisplay.setRequestFocusEnabled(true);
        try {
            this.initListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initListeners() {
        this.lcui.display.insideDisplay.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    for (int x = 0; x < ControlUI.this.lc.cycleGrid.allObjects.numObjs; ++x) {
                        if (ControlUI.this.c != null) {
                            if (ControlUI.this.c == (Cycle)ControlUI.this.lc.cycleGrid.allObjects.objs[x] && x != ControlUI.this.lc.cycleGrid.allObjects.numObjs - 1) {
                                ControlUI.this.cyclePortrayal.setPortrayalForObject(ControlUI.this.c, new OvalPortrayal2D(Color.white));
                                ControlUI.this.c.cpu = true;
                                ControlUI.this.c = (Cycle)ControlUI.this.lc.cycleGrid.allObjects.objs[x + 1];
                                break;
                            }
                            if (ControlUI.this.c != (Cycle)ControlUI.this.lc.cycleGrid.allObjects.objs[x] || x != ControlUI.this.lc.cycleGrid.allObjects.numObjs - 1) continue;
                            ControlUI.this.cyclePortrayal.setPortrayalForObject(ControlUI.this.c, new OvalPortrayal2D(Color.white));
                            ControlUI.this.c.cpu = true;
                            ControlUI.this.c = (Cycle)ControlUI.this.lc.cycleGrid.allObjects.objs[0];
                            break;
                        }
                        ControlUI.this.c = (Cycle)ControlUI.this.lc.cycleGrid.allObjects.objs[x];
                        break;
                    }
                    ControlUI.this.c.cpu = false;
                    ControlUI.this.cyclePortrayal.setPortrayalForObject(ControlUI.this.c, new RectanglePortrayal2D((Paint)Color.green, 1.5));
                    ControlUI.this.lcui.controller.refresh();
                } else if (ControlUI.this.c != null && e.getKeyCode() == 37) {
                    ControlUI.this.c.dir = ControlUI.this.c.dir == 1 ? 3 : (ControlUI.this.c.dir == 2 ? 4 : (ControlUI.this.c.dir == 3 ? 2 : 1));
                } else if (ControlUI.this.c != null && e.getKeyCode() == 39) {
                    ControlUI.this.c.dir = ControlUI.this.c.dir == 1 ? 4 : (ControlUI.this.c.dir == 2 ? 3 : (ControlUI.this.c.dir == 3 ? 1 : 2));
                } else if (e.getKeyCode() == 65) {
                    ((Console)ControlUI.this.lcui.controller).pressPlay();
                } else if (e.getKeyCode() == 83) {
                    ((Console)ControlUI.this.lcui.controller).pressPause();
                } else if (e.getKeyCode() == 68) {
                    ((Console)ControlUI.this.lcui.controller).pressStop();
                }
            }
        });
        this.lcui.display.insideDisplay.addMouseListener(new MouseAdapter(){

            public void getFocus() {
                ControlUI.this.lcui.display.insideDisplay.requestFocus();
            }

            public void mouseClicked(MouseEvent e) {
                this.getFocus();
            }

            public void mouseEntered(MouseEvent e) {
                this.getFocus();
            }
        });
    }
}

