/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lsystem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sim.app.lsystem.LSystem;
import sim.app.lsystem.LSystemWithUI;
import sim.util.gui.LabelledList;

public class DrawUI
extends JPanel {
    JButton buttonSet = new JButton("Set");
    JTextField distField = new JTextField("2", 2);
    JTextField angleField = new JTextField("90", 4);
    LSystemWithUI lsui;
    LSystem ls;

    public DrawUI(LSystemWithUI nLsui) {
        this.lsui = nLsui;
        this.ls = (LSystem)this.lsui.state;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        this.buttonSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawUI.this.ls.l.segsize = Double.valueOf(DrawUI.this.distField.getText());
                DrawUI.this.ls.l.angle = Double.valueOf(DrawUI.this.angleField.getText()) * Math.PI / 180.0;
                DrawUI.this.ls.l.theta = -1.5707963267948966;
            }
        });
        this.setLayout(new BorderLayout());
        LabelledList list = new LabelledList(){
            Insets insets = new Insets(5, 5, 5, 5);

            public Insets getInsets() {
                return this.insets;
            }
        };
        list.addLabelled("Distance: ", this.distField);
        list.addLabelled("Angle: ", this.angleField);
        Box b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(5, 5, 5, 5);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.buttonSet);
        b.add(Box.createGlue());
        list.addLabelled("", b);
        this.add((Component)list, "Center");
        this.setVisible(true);
    }
}

