/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lsystem;

import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import sim.app.lsystem.DrawUI;
import sim.app.lsystem.LSystem;
import sim.app.lsystem.LSystemData;
import sim.app.lsystem.Rule;
import sim.app.lsystem.RuleUI;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;

public class LSystemWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    public static Console c;
    private ContinuousPortrayal2D systemPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        LSystemWithUI lsystem = new LSystemWithUI();
        c = new Console(lsystem);
        c.setVisible(true);
    }

    public LSystemWithUI() {
        super(new LSystem(System.currentTimeMillis()));
    }

    public LSystemWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Lindenmayer Systems";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.systemPortrayal.setField(((LSystem)this.state).drawEnvironment);
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this, 1L);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.systemPortrayal, "LSystem");
        this.display.setBackdrop(Color.white);
        LSystem ls = (LSystem)this.state;
        LSystemData.setVector(ls.l.code, "F");
        ls.l.seed = "F";
        ls.l.rules.add(new Rule(70, "F[+F]F[-F]F"));
        ((Console)c).getTabPane().removeTabAt(3);
        DrawUI draw = new DrawUI(this);
        ((Console)c).getTabPane().addTab("Draw", new JScrollPane(draw));
        ((Console)c).getTabPane().addTab("Rules", new RuleUI(this, draw));
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

