/*
 * Decompiled with CFR 0.152.
 */
package sim.app.networktest;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import sim.app.networktest.NetworkTest;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Double2D;

public class CustomNode
extends SimplePortrayal2D
implements Steppable {
    public String id;
    Double2D desiredLocation = null;
    Double2D suggestedLocation = null;
    int steps = 0;
    public Font nodeFont = new Font("SansSerif", 0, 12);

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public CustomNode(String id) {
        this.id = id;
    }

    public void step(SimState state) {
        double dy;
        double dx;
        double temp;
        NetworkTest nt = (NetworkTest)state;
        Double2D location = nt.environment.getObjectLocation(this);
        --this.steps;
        if (this.desiredLocation == null || this.steps <= 0) {
            this.desiredLocation = new Double2D((state.random.nextDouble() - 0.5) * 152.0 + location.x, (state.random.nextDouble() - 0.5) * 112.0 + location.y);
            this.steps = 50 + state.random.nextInt(50);
        }
        if ((temp = Math.sqrt((dx = this.desiredLocation.x - location.x) * dx + (dy = this.desiredLocation.y - location.y) * dy)) < 1.0) {
            this.steps = 0;
        } else {
            dx /= temp;
            dy /= temp;
        }
        if (!nt.acceptablePosition(this, new Double2D(location.x + dx, location.y + dy))) {
            this.steps = 0;
        } else {
            nt.environment.setObjectLocation((Object)this, new Double2D(location.x + dx, location.y + dy));
        }
    }

    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double diamx = info.draw.width * 8.0;
        double diamy = info.draw.height * 8.0;
        graphics.setColor(Color.red);
        graphics.fillOval((int)(info.draw.x - diamx / 2.0), (int)(info.draw.y - diamy / 2.0), (int)diamx, (int)diamy);
        graphics.setFont(this.nodeFont.deriveFont(this.nodeFont.getSize2D() * (float)info.draw.width));
        graphics.setColor(Color.blue);
        graphics.drawString(this.id, (int)(info.draw.x - diamx / 2.0), (int)(info.draw.y - diamy / 2.0));
    }

    public boolean hitObject(Object object, DrawInfo2D info) {
        double diamx = info.draw.width * 8.0;
        double diamy = info.draw.height * 8.0;
        Ellipse2D.Double ellipse = new Ellipse2D.Double((int)(info.draw.x - diamx / 2.0), (int)(info.draw.y - diamy / 2.0), (int)diamx, (int)diamy);
        return ellipse.intersects(info.clip.x, info.clip.y, info.clip.width, info.clip.height);
    }
}

