/*
 * Decompiled with CFR 0.152.
 */
package sim.app.networktest;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.event.MouseInputAdapter;
import sim.app.networktest.NetworkTest;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.portrayal.simple.CircledPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;

public class NetworkTestWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    NetworkPortrayal2D edgePortrayal = new NetworkPortrayal2D();
    ContinuousPortrayal2D nodePortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        NetworkTestWithUI vid = new NetworkTestWithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public NetworkTestWithUI() {
        super(new NetworkTest(System.currentTimeMillis()));
    }

    public NetworkTestWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Network Test";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.edgePortrayal.setField(new SpatialNetwork2D(((NetworkTest)this.state).environment, ((NetworkTest)this.state).network));
        SimpleEdgePortrayal2D p = new SimpleEdgePortrayal2D(Color.lightGray, Color.lightGray, Color.black);
        p.setShape(1);
        p.setBaseWidth(10.0);
        this.edgePortrayal.setPortrayalForAll(p);
        this.nodePortrayal.setField(((NetworkTest)this.state).environment);
        this.nodePortrayal.setPortrayalForAll(new CircledPortrayal2D(null, 20.0, 10.0, Color.green, true));
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    public void init(final Controller c) {
        super.init(c);
        this.display = new Display2D(800.0, 600.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Network Test Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.edgePortrayal, "Edges");
        this.display.attach(this.nodePortrayal, "Nodes");
        MouseInputAdapter adapter = new MouseInputAdapter(){
            Object node = null;
            LocationWrapper nodeWrapper = null;
            Double2D nodeLocDelta = null;

            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                Continuous2D field = (Continuous2D)NetworkTestWithUI.this.nodePortrayal.getField();
                if (field == null) {
                    return;
                }
                this.node = null;
                Rectangle2D.Double rect = new Rectangle2D.Double(point.x, point.y, 1.0, 1.0);
                Bag hit = new Bag();
                NetworkTestWithUI.this.nodePortrayal.hitObjects(NetworkTestWithUI.this.display.getDrawInfo2D((FieldPortrayal2D)NetworkTestWithUI.this.nodePortrayal, (Rectangle2D)rect), hit);
                if (hit.numObjs > 0) {
                    this.nodeWrapper = (LocationWrapper)hit.objs[hit.numObjs - 1];
                    this.node = this.nodeWrapper.getObject();
                    NetworkTestWithUI.this.display.performSelection(this.nodeWrapper);
                    Double2D nodeLoc = field.getObjectLocation(this.node);
                    Double2D mouseLoc = NetworkTestWithUI.this.nodePortrayal.getLocation(NetworkTestWithUI.this.display.getDrawInfo2D((FieldPortrayal2D)NetworkTestWithUI.this.nodePortrayal, point));
                    this.nodeLocDelta = new Double2D(nodeLoc.x - mouseLoc.x, nodeLoc.y - mouseLoc.y);
                }
                c.refresh();
            }

            public void mouseReleased(MouseEvent e) {
                this.node = null;
            }

            public void mouseDragged(MouseEvent e) {
                Point point = e.getPoint();
                Continuous2D field = (Continuous2D)NetworkTestWithUI.this.nodePortrayal.getField();
                if (this.node == null || field == null) {
                    return;
                }
                Double2D mouseLoc = NetworkTestWithUI.this.nodePortrayal.getLocation(NetworkTestWithUI.this.display.getDrawInfo2D((FieldPortrayal2D)NetworkTestWithUI.this.nodePortrayal, point));
                Double2D newBallLoc = new Double2D(this.nodeLocDelta.x + mouseLoc.x, this.nodeLocDelta.y + mouseLoc.y);
                field.setObjectLocation(this.node, newBallLoc);
                c.refresh();
            }
        };
        this.display.insideDisplay.addMouseListener(adapter);
        this.display.insideDisplay.addMouseMotionListener(adapter);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

