/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso;

import ec.util.MersenneTwisterFast;
import sim.app.pso.Booth;
import sim.app.pso.Evaluatable;
import sim.app.pso.Griewangk;
import sim.app.pso.Particle;
import sim.app.pso.Rastrigin;
import sim.app.pso.Rosenbrock;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;
import sim.util.MutableDouble2D;

public class PSO
extends SimState {
    public Continuous2D space;
    public double width = 10.24;
    public double height = 10.24;
    public Particle[] particles;
    int prevSuccessCount = -1;
    public int numParticles = 1000;
    public int neighborhoodSize = 10;
    public double initialVelocityRange = 1.0;
    public double velocityScalar = 2.7;
    public int fitnessFunction = 0;
    public double[] fitnessFunctionLowerBound = new double[]{920.0, 950.0, 998.0, 200.0};
    public double successThreshold = 1.0E-8;
    public double bestVal = 0.0;
    MutableDouble2D bestPosition = new MutableDouble2D();

    public int getNumParticles() {
        return this.numParticles;
    }

    public void setNumParticles(int val) {
        if (val >= 0) {
            this.numParticles = val;
        }
    }

    public int getNeighborhoodSize() {
        return this.neighborhoodSize;
    }

    public void setNeighborhoodSize(int val) {
        if (val >= 0 && val <= this.numParticles) {
            this.neighborhoodSize = val;
        }
    }

    public double getInitialVelocityRange() {
        return this.initialVelocityRange;
    }

    public void setInitialVelocityRange(double val) {
        if (val >= 0.0) {
            this.initialVelocityRange = val;
        }
    }

    public double getVelocityScalar() {
        return this.velocityScalar;
    }

    public void setVelocityScalar(double val) {
        if (val >= 0.0) {
            this.velocityScalar = val;
        }
    }

    public int getFitnessFunction() {
        return this.fitnessFunction;
    }

    public void setFitnessFunction(int val) {
        this.fitnessFunction = val;
    }

    public Object domFitnessFunction() {
        return new String[]{"Booth", "Rastrigin", "Griewangk", "Rosenbrock"};
    }

    private Evaluatable mapFitnessFunction(int val) {
        switch (val) {
            case 0: {
                return new Booth();
            }
            case 1: {
                return new Rastrigin();
            }
            case 2: {
                return new Griewangk();
            }
            case 3: {
                return new Rosenbrock();
            }
        }
        return new Booth();
    }

    public double getSuccessThreshold() {
        return this.successThreshold;
    }

    public void setSuccessThreshold(double val) {
        if (val >= 0.0) {
            this.successThreshold = val;
        }
    }

    public PSO(long seed) {
        super(seed);
    }

    public PSO(MersenneTwisterFast random) {
        super(random);
    }

    public PSO(MersenneTwisterFast random, Schedule schedule) {
        super(random, schedule);
    }

    public void updateBest(double currVal, double currX, double currY) {
        if (currVal > this.bestVal) {
            this.bestVal = currVal;
            this.bestPosition.setTo(currX, currY);
        }
    }

    public double getNeighborhoodBest(int index, MutableDouble2D pos) {
        double bv = Double.NEGATIVE_INFINITY;
        int start = index - this.neighborhoodSize / 2;
        if (start < 0) {
            start += this.numParticles;
        }
        for (int i = 0; i < this.neighborhoodSize; ++i) {
            Particle p = this.particles[(start + i) % this.numParticles];
            if (!(p.bestVal > bv)) continue;
            bv = p.bestVal;
            pos.setTo(p.bestPosition);
        }
        return 1.0;
    }

    public void start() {
        this.bestVal = 0.0;
        super.start();
        this.particles = new Particle[this.numParticles];
        this.space = new Continuous2D(this.height, this.width, this.height);
        Evaluatable f = this.mapFitnessFunction(this.fitnessFunction);
        for (int i = 0; i < this.numParticles; ++i) {
            Particle p;
            double x = this.random.nextDouble() * this.width - this.width * 0.5;
            double y = this.random.nextDouble() * this.height - this.height * 0.5;
            double vx = this.random.nextDouble() * this.initialVelocityRange - this.initialVelocityRange * 0.5;
            double vy = this.random.nextDouble() * this.initialVelocityRange - this.initialVelocityRange * 0.5;
            this.particles[i] = p = new Particle(x, y, vx, vy, this, f, i);
            this.schedule.scheduleRepeating(0.0, 1, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdateFitness();
                }
            });
            this.schedule.scheduleRepeating(0.0, 2, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdateVelocity();
                }
            });
            this.schedule.scheduleRepeating(0.0, 3, new Steppable(){

                public void step(SimState state) {
                    p.stepUpdatePosition();
                }
            });
        }
        this.schedule.scheduleRepeating(0.0, 4, new Steppable(){

            public void step(SimState state) {
                int successCount = 0;
                for (int i = 0; i < PSO.this.space.allObjects.numObjs; ++i) {
                    Particle p = (Particle)PSO.this.space.allObjects.get(i);
                    if (!(Math.abs(p.getFitness() - 1000.0) <= PSO.this.successThreshold)) continue;
                    ++successCount;
                }
                if (successCount != PSO.this.prevSuccessCount) {
                    PSO.this.prevSuccessCount = successCount;
                    if (successCount == PSO.this.numParticles) {
                        state.kill();
                    }
                }
            }
        });
    }

    public static void main(String[] args) {
        PSO.doLoop(PSO.class, args);
        System.exit(0);
    }
}

