/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso3d;

import sim.app.pso3d.Evaluatable3D;
import sim.app.pso3d.PSO3D;
import sim.util.Double3D;
import sim.util.MutableDouble3D;

public class Particle3D {
    public static final long serialVersionUID = 15L;
    double bestVal = 0.0;
    MutableDouble3D bestPosition = new MutableDouble3D();
    MutableDouble3D position = new MutableDouble3D();
    MutableDouble3D velocity = new MutableDouble3D();
    private PSO3D pso;
    private Evaluatable3D fitnessFunction;
    private int index;

    public Particle3D() {
    }

    public Particle3D(double x, double y, double z, double vx, double vy, double vz, PSO3D pso, Evaluatable3D f, int index) {
        this.position.setTo(x, y, z);
        this.velocity.setTo(vx, vy, vz);
        this.pso = pso;
        this.fitnessFunction = f;
        pso.space.setObjectLocation((Object)this, new Double3D(this.position));
        this.index = index;
    }

    public void updateBest(double currVal, double currX, double currY, double currZ) {
        if (currVal > this.bestVal) {
            this.bestVal = currVal;
            this.bestPosition.setTo(currX, currY, currZ);
            this.pso.updateBest(currVal, currX, currY, currZ);
        }
    }

    public double getFitness() {
        return this.fitnessFunction.calcFitness(this.position.x, this.position.y, this.position.z);
    }

    public void stepUpdateFitness() {
        this.updateBest(this.getFitness(), this.position.x, this.position.y, this.position.z);
    }

    public void stepUpdateVelocity() {
        double x = this.position.x;
        double y = this.position.y;
        double z = this.position.z;
        MutableDouble3D nBestPosition = new MutableDouble3D();
        this.pso.getNeighborhoodBest(this.index, nBestPosition);
        double inertia = this.velocity.x;
        double pDelta = this.bestPosition.x - x;
        double nDelta = nBestPosition.x - x;
        double gDelta = this.pso.bestPosition.x - x;
        double pWeight = Math.random() + 0.4;
        double nWeight = Math.random() + 0.4;
        double gWeight = Math.random() + 0.4;
        double vx = (0.9 * inertia + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
        inertia = this.velocity.y;
        pDelta = this.bestPosition.y - y;
        nDelta = nBestPosition.y - y;
        gDelta = this.pso.bestPosition.y - y;
        pWeight = Math.random() + 0.4;
        nWeight = Math.random() + 0.4;
        gWeight = Math.random() + 0.4;
        double vy = (0.9 * inertia + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
        inertia = this.velocity.z;
        pDelta = this.bestPosition.z - z;
        nDelta = nBestPosition.z - z;
        gDelta = this.pso.bestPosition.z - z;
        pWeight = Math.random() + 0.4;
        nWeight = Math.random() + 0.4;
        gWeight = Math.random() + 0.4;
        double vz = (0.9 * inertia + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
        this.velocity.setTo(vx *= this.pso.velocityScalar, vy *= this.pso.velocityScalar, vz *= this.pso.velocityScalar);
    }

    public void stepUpdatePosition() {
        this.position.addIn(this.velocity);
        this.pso.space.setObjectLocation((Object)this, new Double3D(this.position));
    }
}

