/*
 * Decompiled with CFR 0.152.
 */
package sim.app.schelling;

import sim.app.schelling.Schelling;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Int2D;
import sim.util.IntBag;

public class Agent
implements Steppable {
    Int2D loc;
    IntBag neighborsX = new IntBag(9);
    IntBag neighborsY = new IntBag(9);

    public Agent(int x, int y) {
        this.loc = new Int2D(x, y);
    }

    public void step(SimState state) {
        Schelling sch = (Schelling)state;
        int[][] locs = sch.neighbors.field;
        int x = this.loc.x;
        int y = this.loc.y;
        if (locs[x][y] < 2) {
            return;
        }
        if (sch.emptySpaces.numObjs == 0) {
            return;
        }
        sch.neighbors.getNeighborsMaxDistance(this.loc.x, this.loc.y, sch.neighborhood, false, this.neighborsX, this.neighborsY);
        double val = 0.0;
        int threshold = sch.threshold;
        int numObjs = this.neighborsX.numObjs;
        int[] objsX = this.neighborsX.objs;
        int[] objsY = this.neighborsY.objs;
        int myVal = locs[x][y];
        for (int i = 0; i < numObjs; ++i) {
            if (locs[objsX[i]][objsY[i]] != myVal || objsX[i] == x && objsY[i] == y || !((val += 1.0 / Math.sqrt((x - objsX[i]) * (x - objsX[i]) + (y - objsY[i]) * (y - objsY[i]))) >= (double)threshold)) continue;
            return;
        }
        int newLocIndex = state.random.nextInt(sch.emptySpaces.numObjs);
        Int2D newLoc = (Int2D)sch.emptySpaces.objs[newLocIndex];
        sch.emptySpaces.objs[newLocIndex] = this.loc;
        int swap = locs[newLoc.x][newLoc.y];
        locs[newLoc.x][newLoc.y] = locs[this.loc.x][this.loc.y];
        locs[this.loc.x][this.loc.y] = swap;
        this.loc = newLoc;
    }
}

