/*
 * Decompiled with CFR 0.152.
 */
package sim.app.schelling;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.schelling.Schelling;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class SchellingWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D agentPortrayal = new FastValueGridPortrayal2D("Agents");

    public static void main(String[] args) {
        SchellingWithUI schelling = new SchellingWithUI();
        Console c = new Console(schelling);
        c.setVisible(true);
    }

    public SchellingWithUI() {
        super(new Schelling(System.currentTimeMillis()));
    }

    public SchellingWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Schelling Segregation";
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.agentPortrayal.setMap(new SimpleColorMap(new Color[]{new Color(0, 0, 0, 0), new Color(64, 64, 64), Color.red, Color.blue}));
        this.agentPortrayal.setField(((Schelling)this.state).neighbors);
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.agentPortrayal, "Agents");
        this.display.setBackdrop(Color.black);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

