/*
 * Decompiled with CFR 0.152.
 */
package sim.app.swarmgame;

import sim.app.swarmgame.SwarmGame;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.Oriented2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Agent
implements Steppable,
Oriented2D {
    public Agent a;
    public Agent b;
    public Double2D lastLoc = new Double2D(0.0, 0.0);
    public Double2D loc = new Double2D(0.0, 0.0);

    public double orientation2D() {
        return Math.atan2(this.loc.y - this.lastLoc.y, this.loc.x - this.lastLoc.x);
    }

    public void pick(SwarmGame swarm) {
        Bag agents = swarm.agents.allObjects;
        do {
            this.a = (Agent)agents.objs[swarm.random.nextInt(agents.numObjs)];
        } while (this.a == this);
        do {
            this.b = (Agent)agents.objs[swarm.random.nextInt(agents.numObjs)];
        } while (this.b == this.a || this.b == this);
    }

    public void step(SimState state) {
        SwarmGame swarm = (SwarmGame)state;
        Double2D aLoc = swarm.agents.getObjectLocation(this.a);
        Double2D bLoc = swarm.agents.getObjectLocation(this.b);
        this.loc = swarm.agents.getObjectLocation(this);
        double dis = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double dx0 = 0.0;
        double dy0 = 0.0;
        double dx1 = 0.0;
        double dy1 = 0.0;
        double dx2 = 0.0;
        double dy2 = 0.0;
        double dx3 = 0.0;
        double dy3 = 0.0;
        double dx4 = 0.0;
        double dy4 = 0.0;
        dx = aLoc.x - this.loc.x;
        dy = aLoc.y - this.loc.y;
        dis = Math.sqrt(dx * dx + dy * dy);
        if (dis > 0.0) {
            dx0 = dx / dis;
            dy0 = dy / dis;
        }
        if ((dis = Math.sqrt((dx = this.loc.x - bLoc.x) * dx + (dy = this.loc.y - bLoc.y) * dy)) > 0.0) {
            dx1 = dx / dis;
            dy1 = dy / dis;
        }
        if ((dis = Math.sqrt((dx = (aLoc.x + bLoc.x) / 2.0 - this.loc.x) * dx + (dy = (aLoc.y + bLoc.y) / 2.0 - this.loc.y) * dy)) > 0.0) {
            dx2 = dx / dis;
            dy2 = dy / dis;
        }
        if ((dis = Math.sqrt((dx = aLoc.x + (aLoc.x - bLoc.x) - this.loc.x) * dx + (dy = aLoc.y + (aLoc.y - bLoc.y) - this.loc.y) * dy)) > 0.0) {
            dx3 = dx / dis;
            dy3 = dy / dis;
        }
        if ((dis = Math.sqrt((dx = state.random.nextDouble() - 0.5) * dx + (dy = state.random.nextDouble() - 0.5) * dy)) > 0.0) {
            dx4 = dx / dis;
            dy4 = dy / dis;
        }
        dx = swarm.stalker_v * dx0 + swarm.avoider_v * dx1 + swarm.defender_v * dx2 + swarm.aggressor_v * dx3 + swarm.random_v * dx4;
        dy = swarm.stalker_v * dy0 + swarm.avoider_v * dy1 + swarm.defender_v * dy2 + swarm.aggressor_v * dy3 + swarm.random_v * dy4;
        dis = Math.sqrt(dx * dx + dy * dy);
        dx = dx / dis * swarm.jump;
        dy = dy / dis * swarm.jump;
        this.lastLoc = this.loc;
        this.loc = new Double2D(this.loc.x + dx, this.loc.y + dy);
        swarm.agents.setObjectLocation((Object)this, this.loc);
    }
}

