/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial1and2;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.tutorial1and2.Tutorial1;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class Tutorial2
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D gridPortrayal = new FastValueGridPortrayal2D();

    public Tutorial2() {
        super(new Tutorial1(System.currentTimeMillis()));
    }

    public Tutorial2(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial 2: Life";
    }

    public void setupPortrayals() {
        this.gridPortrayal.setField(((Tutorial1)this.state).grid);
        this.gridPortrayal.setMap(new SimpleColorMap(new Color[]{new Color(0, 0, 0, 0), Color.blue}));
    }

    public void start() {
        super.start();
        this.setupPortrayals();
        this.display.reset();
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        Tutorial1 tut = (Tutorial1)this.state;
        this.display = new Display2D(tut.gridWidth * 4, tut.gridHeight * 4, this, 1L);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.gridPortrayal, "Life");
        this.display.setBackdrop(Color.black);
    }

    public static void main(String[] args) {
        Tutorial2 tutorial2 = new Tutorial2();
        Console c = new Console(tutorial2);
        c.setVisible(true);
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
        this.display.reset();
        this.display.repaint();
    }
}

