/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial3;

import sim.app.tutorial3.Particle;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.Int2D;

public class Tutorial3
extends SimState {
    public DoubleGrid2D trails;
    public SparseGrid2D particles;
    public int gridWidth = 100;
    public int gridHeight = 100;
    public int numParticles = 500;
    static final long serialVersionUID = 9115981605874680023L;

    public Tutorial3(long seed) {
        super(seed);
    }

    public void start() {
        super.start();
        this.trails = new DoubleGrid2D(this.gridWidth, this.gridHeight);
        this.particles = new SparseGrid2D(this.gridWidth, this.gridHeight);
        for (int i = 0; i < this.numParticles; ++i) {
            Particle p = new Particle(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            this.schedule.scheduleRepeating(p);
            this.particles.setObjectLocation((Object)p, new Int2D(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight)));
        }
        Steppable decreaser = new Steppable(){
            static final long serialVersionUID = 6330208160095250478L;

            public void step(SimState state) {
                Tutorial3.this.trails.multiply(0.9);
            }
        };
        this.schedule.scheduleRepeating(0.0, 2, decreaser, 1.0);
    }

    public static void main(String[] args) {
        Tutorial3.doLoop(Tutorial3.class, args);
        System.exit(0);
    }
}

