/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial4;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import sim.app.tutorial4.BigParticle;
import sim.display.Controller;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.field.grid.SparseGrid2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.util.Int2D;

public class BigParticleInspector
extends Inspector {
    public Inspector originalInspector;

    public BigParticleInspector(Inspector originalInspector, LocationWrapper wrapper, GUIState guiState) {
        this.originalInspector = originalInspector;
        SparseGridPortrayal2D gridportrayal = (SparseGridPortrayal2D)wrapper.getFieldPortrayal();
        final SparseGrid2D grid = (SparseGrid2D)gridportrayal.getField();
        final BigParticle particle = (BigParticle)wrapper.getObject();
        final SimState state = guiState.state;
        final Controller console = guiState.controller;
        Box box = new Box(0);
        JButton button = new JButton("Roll the Dice");
        box.add(button);
        box.add(Box.createGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)originalInspector, "Center");
        this.add((Component)box, "North");
        button.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Schedule schedule = state.schedule;
                synchronized (schedule) {
                    particle.xdir = state.random.nextInt(3) - 1;
                    particle.ydir = state.random.nextInt(3) - 1;
                    grid.setObjectLocation((Object)particle, new Int2D(state.random.nextInt(grid.getWidth()), state.random.nextInt(grid.getHeight())));
                    console.refresh();
                }
            }
        });
    }

    public void updateInspector() {
        this.originalInspector.updateInspector();
    }
}

