/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial4;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.tutorial4.BigParticle;
import sim.app.tutorial4.BigParticleInspector;
import sim.app.tutorial4.Particle;
import sim.app.tutorial4.Tutorial4;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;
import sim.util.gui.SimpleColorMap;

public class Tutorial4WithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    public Display2D display2;
    public JFrame displayFrame2;
    SparseGridPortrayal2D particlesPortrayal = new SparseGridPortrayal2D();
    SparseGridPortrayal2D particlesPortrayal2 = new SparseGridPortrayal2D();
    FastValueGridPortrayal2D trailsPortrayal = new FastValueGridPortrayal2D("Trail");

    public static void main(String[] args) {
        Tutorial4WithUI t = new Tutorial4WithUI();
        Console c = new Console(t);
        c.setVisible(true);
    }

    public Tutorial4WithUI() {
        super(new Tutorial4(System.currentTimeMillis()));
    }

    public Tutorial4WithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial4: Particles";
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.trailsPortrayal.setField(((Tutorial4)this.state).trails);
        this.trailsPortrayal.setMap(new SimpleColorMap(0.0, 1.0, Color.black, Color.white));
        this.particlesPortrayal.setField(((Tutorial4)this.state).particles);
        this.particlesPortrayal.setPortrayalForClass(Particle.class, new OvalPortrayal2D(Color.green));
        this.particlesPortrayal.setPortrayalForClass(BigParticle.class, new RectanglePortrayal2D(Color.red, 1.5){

            public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
                return new BigParticleInspector(super.getInspector(wrapper, state), wrapper, state);
            }
        });
        this.particlesPortrayal2.setField(((Tutorial4)this.state).particles);
        this.particlesPortrayal2.setPortrayalForAll(new RectanglePortrayal2D(Color.green));
        this.display.reset();
        this.display2.reset();
        this.display.repaint();
        this.display2.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.setBackdrop(Color.black);
        this.display.attach(this.trailsPortrayal, "Trails");
        this.display.attach(this.particlesPortrayal, "Particles");
        this.display2 = new Display2D(400.0, 600.0, this, 1L);
        this.displayFrame2 = this.display2.createFrame();
        this.displayFrame2.setTitle("The Other Display");
        c.registerFrame(this.displayFrame2);
        this.displayFrame2.setVisible(true);
        this.display2.setBackdrop(Color.blue);
        this.display2.attach(this.particlesPortrayal2, "Squished Particles!");
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public Inspector getInspector() {
        Inspector i = super.getInspector();
        i.setVolatile(true);
        return i;
    }
}

