/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial5;

import sim.app.tutorial5.Ball;
import sim.app.tutorial5.Band;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.Double2D;

public class Tutorial5
extends SimState {
    public Continuous2D balls = new Continuous2D(5.0, 100.0, 100.0);
    public Network bands = new Network();
    public int numBalls = 50;
    public int numBands = 60;
    public static final double maxMass = 10.0;
    public static final double minMass = 1.0;
    public static final double minLaxBandDistance = 10.0;
    public static final double maxLaxBandDistance = 50.0;
    public static final double minBandStrength = 5.0;
    public static final double maxBandStrength = 10.0;
    public static final double collisionDistance = 5.0;
    static final long serialVersionUID = -7164072518609011190L;

    public int getNumBalls() {
        return this.numBalls;
    }

    public void setNumBalls(int val) {
        if (val >= 2) {
            this.numBalls = val;
        }
    }

    public int getNumBands() {
        return this.numBands;
    }

    public void setNumBands(int val) {
        if (val >= 0) {
            this.numBands = val;
        }
    }

    public Tutorial5(long seed) {
        super(seed);
    }

    public void start() {
        int i;
        super.start();
        this.balls = new Continuous2D(5.0, 100.0, 100.0);
        this.bands = new Network();
        Steppable[] s = new Steppable[this.numBalls];
        for (int i2 = 0; i2 < this.numBalls; ++i2) {
            final Ball ball = new Ball(0.0, 0.0, this.random.nextDouble() * 9.0 + 1.0);
            this.balls.setObjectLocation((Object)ball, new Double2D(this.random.nextDouble() * 100.0, this.random.nextDouble() * 100.0));
            this.bands.addNode(ball);
            this.schedule.scheduleRepeating(ball);
            s[i2] = new Steppable(){
                static final long serialVersionUID = -4269174171145445918L;

                public void step(SimState state) {
                    ball.computeForce(state);
                }
            };
        }
        this.schedule.scheduleRepeating(0.0, 1, new Sequence(s), 1.0);
        Bag ballObjs = this.balls.getAllObjects();
        for (i = 0; i < this.numBands; ++i) {
            Ball from;
            Band band = new Band(this.random.nextDouble() * 40.0 + 10.0, this.random.nextDouble() * 5.0 + 5.0);
            Ball to = from = (Ball)ballObjs.objs[this.random.nextInt(ballObjs.numObjs)];
            while (to == from) {
                to = (Ball)ballObjs.objs[this.random.nextInt(ballObjs.numObjs)];
            }
            this.bands.addEdge(from, to, band);
        }
        ballObjs = this.balls.getAllObjects();
        for (i = 0; i < ballObjs.numObjs; ++i) {
            ((Ball)ballObjs.objs[i]).computeCollision(this);
        }
    }

    public static void main(String[] args) {
        Tutorial5.doLoop(Tutorial5.class, args);
        System.exit(0);
    }
}

