/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial5;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.tutorial5.BandPortrayal2D;
import sim.app.tutorial5.Tutorial5;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;

public class Tutorial5WithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    NetworkPortrayal2D edgePortrayal = new NetworkPortrayal2D();
    ContinuousPortrayal2D nodePortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        Tutorial5WithUI vid = new Tutorial5WithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public Tutorial5WithUI() {
        super(new Tutorial5(System.currentTimeMillis()));
    }

    public Tutorial5WithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial 5: Hooke's Law";
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Tutorial5 tut = (Tutorial5)this.state;
        this.edgePortrayal.setField(new SpatialNetwork2D(tut.balls, tut.bands));
        this.edgePortrayal.setPortrayalForAll(new BandPortrayal2D());
        this.nodePortrayal.setField(tut.balls);
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, this, 1L);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Tutorial 5 Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.edgePortrayal, "Bands");
        this.display.attach(this.nodePortrayal, "Balls");
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

