/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial6;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import sim.app.tutorial6.Tutorial6;
import sim.display.Console;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.simple.SpherePortrayal3D;
import sim.portrayal3d.simple.TransformedPortrayal3D;
import sim.util.Bag;

public class Tutorial6WithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    ContinuousPortrayal3D bodyPortrayal = new ContinuousPortrayal3D();

    public static void main(String[] args) {
        Tutorial6WithUI vid = new Tutorial6WithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public Tutorial6WithUI() {
        super(new Tutorial6(System.currentTimeMillis()));
    }

    public Tutorial6WithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial 6: Planets";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    public static Image loadImage(String filename) {
        return new ImageIcon(Tutorial6.class.getResource(filename)).getImage();
    }

    public void setupPortrayals() {
        this.display.destroySceneGraph();
        Tutorial6 tut = (Tutorial6)this.state;
        this.bodyPortrayal.setField(tut.bodies);
        Bag objs = tut.bodies.getAllObjects();
        String[] imageNames = new String[]{"sunmap.jpg", "mercurymap.jpg", "venusmap.jpg", "earthmap.jpg", "marsmap.jpg", "jupitermap.jpg", "saturnmap.jpg", "uranusmap.jpg", "neptunemap.jpg", "plutomap.jpg"};
        for (int i = 0; i < 10; ++i) {
            TransformedPortrayal3D trans = new TransformedPortrayal3D(new SpherePortrayal3D(Tutorial6WithUI.loadImage(imageNames[i]), (float)(Math.log(Tutorial6.DIAMETER[i]) * 50.0), 50));
            trans.rotateX(90.0);
            this.bodyPortrayal.setPortrayalForObject(objs.objs[i], trans);
        }
        this.display.reset();
        this.display.createSceneGraph();
    }

    public void init(Controller c) {
        super.init(c);
        Tutorial6 tut = (Tutorial6)this.state;
        this.bodyPortrayal.setField(tut.bodies);
        this.display = new Display3D(600.0, 600.0, this, 1L);
        this.display.attach(this.bodyPortrayal, "The Solar System");
        this.display.scale(1.0 / (Tutorial6.DISTANCE[9] * 1.05));
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }
}

