/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial7;

import sim.app.tutorial7.Fly;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid3D;

public class Tutorial7
extends SimState {
    public SparseGrid3D flies;
    public DoubleGrid2D xProjection;
    public DoubleGrid2D yProjection;
    public DoubleGrid2D zProjection;
    int width = 30;
    int height = 30;
    int length = 30;
    static final long serialVersionUID = -7776187839992045098L;

    public void setWidth(int val) {
        if (val > 0) {
            this.width = val;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int val) {
        if (val > 0) {
            this.height = val;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setLength(int val) {
        if (val > 0) {
            this.length = val;
        }
    }

    public int getLength() {
        return this.length;
    }

    public Tutorial7(long seed) {
        super(seed);
    }

    public void start() {
        super.start();
        this.flies = new SparseGrid3D(this.width, this.height, this.length);
        this.xProjection = new DoubleGrid2D(this.height, this.length);
        this.yProjection = new DoubleGrid2D(this.width, this.length);
        this.zProjection = new DoubleGrid2D(this.width, this.height);
        this.schedule.scheduleRepeating(new Steppable(){
            static final long serialVersionUID = -4596371762755892330L;

            public void step(SimState state) {
                Tutorial7.this.xProjection.setTo(0.0);
                Tutorial7.this.yProjection.setTo(0.0);
                Tutorial7.this.zProjection.setTo(0.0);
            }
        });
        for (int i = 0; i < 100; ++i) {
            Fly fly = new Fly();
            this.flies.setObjectLocation(fly, this.random.nextInt(this.width), this.random.nextInt(this.height), this.random.nextInt(this.length));
            this.schedule.scheduleRepeating(0.0, 1, fly, 1.0);
        }
    }

    public static void main(String[] args) {
        Tutorial7.doLoop(Tutorial7.class, args);
        System.exit(0);
    }
}

