/*
 * Decompiled with CFR 0.152.
 */
package sim.app.virus;

import sim.app.virus.Agent;
import sim.app.virus.Evil;
import sim.app.virus.Good;
import sim.app.virus.Human;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Bag;
import sim.util.Double2D;

public class VirusInfectionDemo
extends SimState {
    public static final double XMIN = 0.0;
    public static final double XMAX = 800.0;
    public static final double YMIN = 0.0;
    public static final double YMAX = 600.0;
    public static final double DIAMETER = 8.0;
    public static final double HEALING_DISTANCE = 20.0;
    public static final double HEALING_DISTANCE_SQUARED = 400.0;
    public static final double INFECTION_DISTANCE = 20.0;
    public static final double INFECTION_DISTANCE_SQUARED = 400.0;
    public static final int NUM_HUMANS = 100;
    public static final int NUM_GOODS = 4;
    public static final int NUM_EVILS = 4;
    public Continuous2D environment = null;

    public VirusInfectionDemo(long seed) {
        super(seed);
    }

    boolean conflict(Agent agent1, Double2D a, Agent agent2, Double2D b) {
        return (a.x > b.x && a.x < b.x + 8.0 || a.x + 8.0 > b.x && a.x + 8.0 < b.x + 8.0) && (a.y > b.y && a.y < b.y + 8.0 || a.y + 8.0 > b.y && a.y + 8.0 < b.y + 8.0);
    }

    public boolean withinInfectionDistance(Agent agent1, Double2D a, Agent agent2, Double2D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) <= 400.0;
    }

    public boolean withinHealingDistance(Agent agent1, Double2D a, Agent agent2, Double2D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) <= 400.0;
    }

    boolean acceptablePosition(Agent agent, Double2D location) {
        if (location.x < 4.0 || location.x > 796.0 || location.y < 4.0 || location.y > 596.0) {
            return false;
        }
        Bag mysteriousObjects = this.environment.getObjectsWithinDistance(location, 16.0);
        if (mysteriousObjects != null) {
            for (int i = 0; i < mysteriousObjects.numObjs; ++i) {
                Agent ta;
                if (mysteriousObjects.objs[i] == null || mysteriousObjects.objs[i] == agent || !this.conflict(agent, location, ta = (Agent)mysteriousObjects.objs[i], this.environment.getObjectLocation(ta))) continue;
                return false;
            }
        }
        return true;
    }

    public void start() {
        super.start();
        this.environment = new Continuous2D(25.0, 800.0, 600.0);
        for (int x = 0; x < 108; ++x) {
            Double2D loc = null;
            Agent agent = null;
            int times = 0;
            do {
                loc = new Double2D(this.random.nextDouble() * 792.0 + 0.0 + 4.0, this.random.nextDouble() * 592.0 + 0.0 + 4.0);
                agent = x < 100 ? new Human("Human" + x, loc) : (x < 104 ? new Good("Good" + (x - 100), loc) : new Evil("Evil" + (x - 100 - 4), loc));
                if (++times != 1000) continue;
                System.err.println("Cannot place agents. Exiting....");
                System.exit(1);
            } while (!this.acceptablePosition(agent, loc));
            this.environment.setObjectLocation((Object)agent, loc);
            this.schedule.scheduleRepeating(agent);
        }
    }

    public static void main(String[] args) {
        VirusInfectionDemo.doLoop(VirusInfectionDemo.class, args);
        System.exit(0);
    }
}

