/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.woims.WoimsDemo;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;

public class WoimsDemoWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D woimsPortrayal = new ContinuousPortrayal2D();
    ContinuousPortrayal2D obstaclesPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        WoimsDemoWithUI woims = new WoimsDemoWithUI();
        Console c = new Console(woims);
        c.setVisible(true);
    }

    public WoimsDemoWithUI() {
        super(new WoimsDemo(System.currentTimeMillis()));
    }

    public WoimsDemoWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Woims";
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.woimsPortrayal.setField(((WoimsDemo)this.state).woimsEnvironment);
        this.obstaclesPortrayal.setField(((WoimsDemo)this.state).obstaclesEnvironment);
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, this, 1L);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Woims Demonstration Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.woimsPortrayal, "Woims");
        this.display.attach(this.obstaclesPortrayal, "Obstacles");
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

