/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims3d;

import java.io.Serializable;
import sim.util.Double3D;

public class Vector3D
implements Serializable {
    public double x;
    public double y;
    public double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Double3D d) {
        this.x = d.x;
        this.y = d.y;
        this.z = d.z;
    }

    public final Vector3D add(Vector3D b) {
        return new Vector3D(this.x + b.x, this.y + b.y, this.z + b.z);
    }

    public final Vector3D add(Double3D b) {
        return new Vector3D(this.x + b.x, this.y + b.y, this.z + b.z);
    }

    public final Vector3D subtract(Vector3D b) {
        return new Vector3D(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public final Vector3D subtract(Double3D b) {
        return new Vector3D(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public final Vector3D amplify(double alpha) {
        return new Vector3D(this.x * alpha, this.y * alpha, this.z * alpha);
    }

    public final Vector3D normalize() {
        if (this.x != 0.0 || this.y != 0.0 || this.z != 0.0) {
            double temp = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            return new Vector3D(this.x / temp, this.y / temp, this.z / temp);
        }
        return new Vector3D(0.0, 0.0, 0.0);
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final Vector3D setLength(double dist) {
        if (dist == 0.0) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        double temp = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Vector3D(this.x * dist / temp, this.y * dist / temp, this.z * dist / temp);
    }
}

