/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims3d;

import javax.swing.JFrame;
import sim.app.woims3d.WoimsDemo3D;
import sim.display.Console;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.simple.WireFrameBoxPortrayal3D;

public class WoimsDemo3DWithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    ContinuousPortrayal3D p2;
    WireFrameBoxPortrayal3D wireFrameP;

    public static String getName() {
        return "3D Woims";
    }

    public static void main(String[] args) {
        WoimsDemo3DWithUI woims = new WoimsDemo3DWithUI(new WoimsDemo3D(System.currentTimeMillis()));
        Console c = new Console(woims);
        c.setVisible(true);
    }

    public WoimsDemo3DWithUI() {
        this(new WoimsDemo3D(System.currentTimeMillis()));
    }

    public WoimsDemo3DWithUI(SimState state) {
        super(state);
        WoimsDemo3D wd = (WoimsDemo3D)state;
        this.p2 = new ContinuousPortrayal3D();
        this.p2.setField(wd.environment);
        this.wireFrameP = new WireFrameBoxPortrayal3D(-10.0, -10.0, -10.0, wd.environment.width + 20.0, wd.environment.height + 20.0, wd.environment.length + 20.0);
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.display.destroySceneGraph();
        this.p2.setField(((WoimsDemo3D)this.state).environment);
        this.display.createSceneGraph();
        this.display.reset();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display3D(600.0, 600.0, this, 1L);
        this.display.attach(this.p2, "Woims");
        this.display.attach(this.wireFrameP, "WireFrame");
        this.display.translate(-100.0, -100.0, -100.0);
        this.display.scale(0.005);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

