/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import ec.util.MersenneTwisterFast;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.SimApplet;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.util.Bag;
import sim.util.Utilities;
import sim.util.gui.AbstractScrollable;
import sim.util.gui.HTMLBrowser;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;

public class Console
extends JFrame
implements Controller {
    public static final int DEFAULT_WIDTH = 380;
    public static final int DEFAULT_HEIGHT = 380;
    public static final int DEFAULT_GUTTER = 5;
    public GUIState simulation;
    public static Vector classNames = new Vector();
    public static Vector shortNames = new Vector();
    public static boolean allowOtherClassNames;
    public static final ImageIcon I_PLAY_ON;
    public static final ImageIcon I_PLAY_OFF;
    public static final ImageIcon I_STOP_ON;
    public static final ImageIcon I_STOP_OFF;
    public static final ImageIcon I_PAUSE_ON;
    public static final ImageIcon I_PAUSE_OFF;
    public static final ImageIcon I_STEP_ON;
    public static final ImageIcon I_STEP_OFF;
    JComponent infoPanel;
    JLabel time;
    JSlider slider;
    JLabel sliderText;
    JSlider stepSlider;
    JLabel stepSliderText;
    JSlider prioritySlider;
    JLabel prioritySliderText;
    JCheckBox repeatButton;
    JButton stopButton;
    JButton playButton;
    JButton pauseButton;
    JTabbedPane tabPane;
    JList frameListDisplay;
    Vector frameList;
    PropertyField endField;
    PropertyField pauseField;
    PropertyField timeEndField;
    PropertyField timePauseField;
    PropertyField randomField;
    JMenuBar menuBar;
    JSplitPane innerInspectorPanel;
    JPanel inspectorPanel;
    JCheckBox incrementSeedOnPlay;
    JList inspectorList;
    JPanel inspectorSwitcher;
    CardLayout inspectorCardLayout;
    JButton detatchButton;
    JButton removeButton;
    Inspector modelInspector;
    JScrollPane modelInspectorScrollPane;
    Box buttonBox;
    JComboBox timeBox;
    int randomSeed = (int)System.currentTimeMillis();
    int numStepsPerStepButtonPress = 1;
    boolean shouldRepeat = false;
    int threadPriority = 5;
    long whenShouldEnd = Long.MAX_VALUE;
    long whenShouldPause = Long.MAX_VALUE;
    double whenShouldEndTime = Double.POSITIVE_INFINITY;
    double whenShouldPauseTime = Double.POSITIVE_INFINITY;
    long playSleep = 0L;
    Thread playThread;
    final Object playThreadLock = new Object();
    boolean threadShouldStop = false;
    public static final int PS_STOPPED = 0;
    public static final int PS_PLAYING = 1;
    public static final int PS_PAUSED = 2;
    int playState = 0;
    static boolean isQuitting;
    static final Object isQuittingLock;
    static WeakHashMap allConsoles;
    static int numConsoles;
    boolean isClosing = false;
    final Object isClosingLock = new Object();
    static boolean sacrificial;
    static JFrame aboutFrame;
    static Object classLock;
    static boolean classListLoaded;
    File simulationFile = null;
    double lastTime = -1.0;
    double lastRate = 0.0;
    long lastSteps = 0L;
    static final int SHOWING_TIME = 0;
    static final int SHOWING_STEPS = 1;
    static final int SHOWING_TPS = 2;
    static final int SHOWING_NOTHING = -1;
    int showing = 0;
    NumberFormat rateFormat;
    String lastText = null;
    Runnable blocker = new Runnable(){

        public void run() {
        }
    };
    Vector inspectorNames = new Vector();
    Vector inspectorStoppables = new Vector();
    Vector inspectorToolbars = new Vector();
    WeakHashMap allInspectors = new WeakHashMap();

    public static ImageIcon iconFor(String name) {
        return new ImageIcon(Console.class.getResource(name));
    }

    public Console(GUIState simulation) {
        super(GUIState.getName(simulation.getClass()));
        Color transparentBackground = new JPanel().getBackground();
        this.simulation = simulation;
        this.rateFormat = NumberFormat.getInstance();
        this.rateFormat.setMaximumFractionDigits(3);
        this.rateFormat.setMinimumIntegerDigits(1);
        this.buttonBox = new Box(0);
        this.playButton = new JButton(I_PLAY_OFF);
        this.playButton.setPressedIcon(I_PLAY_ON);
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressPlay();
            }
        });
        this.playButton.setBorderPainted(false);
        this.playButton.setContentAreaFilled(false);
        this.playButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonBox.add(this.playButton);
        this.pauseButton = new JButton(I_PAUSE_OFF);
        this.pauseButton.setPressedIcon(I_PAUSE_ON);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressPause();
            }
        });
        this.pauseButton.setBorderPainted(false);
        this.pauseButton.setContentAreaFilled(false);
        this.pauseButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonBox.add(this.pauseButton);
        this.stopButton = new JButton(I_STOP_OFF);
        this.stopButton.setIcon(I_STOP_ON);
        this.stopButton.setPressedIcon(I_STOP_OFF);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressStop();
            }
        });
        this.stopButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stopButton.setBorderPainted(false);
        this.stopButton.setContentAreaFilled(false);
        this.buttonBox.add(this.stopButton);
        this.timeBox = new JComboBox<Object>(new Object[]{"Time", "Steps", "Rate", "None"});
        this.timeBox.setSelectedIndex(0);
        this.timeBox.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                JLabel jLabel = Console.this.time;
                synchronized (jLabel) {
                    Console.this.showing = Console.this.timeBox.getSelectedIndex();
                }
                Console.this.updateTime();
            }
        });
        Box timeBox1 = new Box(1);
        timeBox1.add(Box.createGlue());
        timeBox1.add(this.timeBox);
        timeBox1.add(Box.createGlue());
        this.time = new JLabel("");
        this.time.setPreferredSize(new JLabel("8888888888888888888").getPreferredSize());
        this.time.setMinimumSize(new JLabel("888").getMinimumSize());
        this.buttonBox.add(this.time);
        this.buttonBox.add(Box.createGlue());
        this.buttonBox.add(new JLabel(" "));
        this.buttonBox.add(timeBox1);
        if (Display2D.isMacOSX()) {
            this.buttonBox.add(new JLabel("    "));
        }
        this.infoPanel = new HTMLBrowser(GUIState.getInfo(simulation.getClass()));
        this.frameList = new Vector();
        this.frameListDisplay = new JList(this.frameList);
        this.frameListDisplay.setCellRenderer(new ListCellRenderer(){
            protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                JFrame frame = (JFrame)value;
                if (frame.isVisible()) {
                    renderer.setForeground(Color.black);
                } else {
                    renderer.setForeground(Color.gray);
                }
                renderer.setText(frame.getTitle());
                return renderer;
            }
        });
        Box b = new Box(0);
        JButton button = new JButton("Show All");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressShowAll();
            }
        });
        b.add(button);
        button = new JButton("Show");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressShow();
            }
        });
        b.add(button);
        button = new JButton("Hide");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressHide();
            }
        });
        b.add(button);
        button = new JButton("Hide All");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.pressHideAll();
            }
        });
        b.add(button);
        b.add(Box.createGlue());
        JPanel frameListPanel = new JPanel();
        frameListPanel.setLayout(new BorderLayout());
        frameListPanel.add((Component)new JScrollPane(this.frameListDisplay), "Center");
        frameListPanel.add((Component)b, "South");
        LabelledList controlPanel = new LabelledList(){
            Insets insets = new Insets(2, 4, 2, 4);

            public Insets getInsets() {
                return this.insets;
            }
        };
        this.slider = new JSlider(0, 100, 0);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = Console.this.slider.getValue();
                long speed = (long)(64000.0 / (Math.pow(4.0, 5.0) - 1.0) * (Math.pow(4.0, (double)val / 20.0) - 1.0));
                if (!Console.this.slider.getValueIsAdjusting()) {
                    Console.this.setPlaySleep(speed);
                }
                Console.this.sliderText.setText("" + (double)speed / 1000.0);
            }
        });
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.slider);
        this.sliderText = new JLabel("0.0");
        this.sliderText.setMinimumSize(new JLabel("88.888").getMinimumSize());
        this.sliderText.setPreferredSize(new JLabel("88.888").getPreferredSize());
        b.add(this.sliderText);
        controlPanel.addLabelled("Delay (Sec/Step) ", b);
        this.prioritySlider = new JSlider(1, 10, 5);
        this.prioritySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = Console.this.prioritySlider.getValue();
                if (!Console.this.prioritySlider.getValueIsAdjusting()) {
                    Console.this.setThreadPriority(val);
                }
                Console.this.prioritySliderText.setText("" + val + (val == 5 ? ": norm" : ""));
            }
        });
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.prioritySlider);
        this.prioritySliderText = new JLabel("5: norm");
        this.prioritySliderText.setMinimumSize(new JLabel("88: norm").getMinimumSize());
        this.prioritySliderText.setPreferredSize(new JLabel("88: norm").getPreferredSize());
        b.add(this.prioritySliderText);
        controlPanel.addLabelled("Thread Priority ", b);
        this.stepSlider = new JSlider(1, 20, 1);
        this.stepSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Console.this.numStepsPerStepButtonPress = Console.this.stepSlider.getValue();
                Console.this.stepSliderText.setText("" + Console.this.numStepsPerStepButtonPress);
            }
        });
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.stepSlider);
        this.stepSliderText = new JLabel("1");
        this.stepSliderText.setMinimumSize(new JLabel("8.888").getMinimumSize());
        this.stepSliderText.setPreferredSize(new JLabel("8.888").getPreferredSize());
        b.add(this.stepSliderText);
        controlPanel.addLabelled("Steps per Step-Button ", b);
        this.endField = new PropertyField(""){

            public String newValue(String value) {
                long l = -1L;
                try {
                    l = Long.parseLong(value);
                    if (l < 0L) {
                        l = Long.MAX_VALUE;
                    }
                }
                catch (NumberFormatException num) {
                    l = Long.MAX_VALUE;
                }
                Console.this.setWhenShouldEnd(l);
                if (l == Long.MAX_VALUE) {
                    return "";
                }
                return "" + l;
            }
        };
        this.endField.valField.setColumns(19);
        this.endField.setMaximumSize(this.endField.valField.getPreferredSize());
        this.endField.setPreferredSize(this.endField.valField.getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.endField);
        controlPanel.addLabelled("Automatically Stop at Step ", b);
        this.timeEndField = new PropertyField(""){

            public String newValue(String value) {
                double l = -1.0;
                try {
                    l = Double.parseDouble(value);
                    if (l < 0.0 || l != l) {
                        l = Double.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException num) {
                    l = Double.POSITIVE_INFINITY;
                }
                Console.this.setWhenShouldEndTime(l);
                if (l == Double.POSITIVE_INFINITY) {
                    return "";
                }
                return "" + l;
            }
        };
        this.timeEndField.valField.setColumns(19);
        this.timeEndField.setMaximumSize(this.endField.valField.getPreferredSize());
        this.timeEndField.setPreferredSize(this.endField.valField.getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.timeEndField);
        controlPanel.addLabelled("Automatically Stop After Time ", b);
        this.pauseField = new PropertyField(""){

            public String newValue(String value) {
                long l = Long.MAX_VALUE;
                try {
                    l = Long.parseLong(value);
                    if (l < 0L) {
                        l = Long.MAX_VALUE;
                    }
                }
                catch (NumberFormatException num) {
                    l = Long.MAX_VALUE;
                }
                Console.this.setWhenShouldPause(l);
                if (l == Long.MAX_VALUE) {
                    return "";
                }
                return "" + l;
            }
        };
        this.pauseField.valField.setColumns(19);
        this.pauseField.setMaximumSize(this.pauseField.valField.getPreferredSize());
        this.pauseField.setPreferredSize(this.pauseField.valField.getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.pauseField);
        controlPanel.addLabelled("Automatically Pause at Step ", b);
        this.timePauseField = new PropertyField(""){

            public String newValue(String value) {
                double l = -1.0;
                try {
                    l = Double.parseDouble(value);
                    if (l < 0.0 || l != l) {
                        l = Double.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException num) {
                    l = Double.POSITIVE_INFINITY;
                }
                Console.this.setWhenShouldPauseTime(l);
                if (l == Double.POSITIVE_INFINITY) {
                    return "";
                }
                return "" + l;
            }
        };
        this.timePauseField.valField.setColumns(19);
        this.timePauseField.setMaximumSize(this.pauseField.valField.getPreferredSize());
        this.timePauseField.setPreferredSize(this.pauseField.valField.getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.timePauseField);
        controlPanel.addLabelled("Automatically Pause After Time ", b);
        this.randomField = new PropertyField(""){

            public String newValue(String value) {
                try {
                    int l;
                    Console.this.randomSeed = l = Integer.parseInt(value);
                    Console.this.setRandomNumberGenerator(Console.this.randomSeed);
                    return "" + l;
                }
                catch (NumberFormatException num) {
                    return this.getValue();
                }
            }
        };
        this.randomField.valField.setColumns(10);
        this.randomField.setMaximumSize(this.randomField.valField.getPreferredSize());
        this.randomField.setPreferredSize(this.randomField.valField.getPreferredSize());
        this.randomField.setValue("" + this.randomSeed);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.randomField);
        controlPanel.addLabelled("Random Number Seed ", b);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        this.incrementSeedOnPlay = new JCheckBox();
        this.incrementSeedOnPlay.setSelected(true);
        b.add(this.incrementSeedOnPlay);
        controlPanel.addLabelled("Increment Seed on Stop ", b);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        this.repeatButton = new JCheckBox();
        this.repeatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.setShouldRepeat(Console.this.repeatButton.isSelected());
            }
        });
        this.repeatButton.setSelected(false);
        b.add(this.repeatButton);
        controlPanel.addLabelled("Repeat Play on Stop ", b);
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new BorderLayout());
        this.removeButton = new JButton("Empty List");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.removeAllInspectors(false);
            }
        });
        this.removeButton.setEnabled(false);
        this.detatchButton = new JButton("Detatch");
        this.detatchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.detatchInspector();
            }
        });
        this.detatchButton.setEnabled(false);
        Box removeButtonBox = new Box(0);
        removeButtonBox.add(this.removeButton);
        removeButtonBox.add(this.detatchButton);
        removeButtonBox.add(Box.createGlue());
        this.inspectorList = new JList(this.inspectorNames);
        this.inspectorList.setSelectionMode(0);
        this.inspectorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && Console.this.inspectorList.getSelectedIndex() != -1) {
                    Console.this.inspectorCardLayout.show(Console.this.inspectorSwitcher, "" + Console.this.inspectorList.getSelectedIndex());
                }
            }
        });
        JScrollPane listPane = new JScrollPane(this.inspectorList);
        listPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inspectorSwitcher = new JPanel();
        this.inspectorCardLayout = new CardLayout();
        this.inspectorSwitcher.setLayout(this.inspectorCardLayout);
        this.innerInspectorPanel = new JSplitPane(0, true, listPane, this.inspectorSwitcher);
        this.innerInspectorPanel.setDividerLocation(60);
        this.inspectorPanel = new JPanel();
        this.inspectorPanel.setLayout(new BorderLayout());
        this.inspectorPanel.add((Component)this.innerInspectorPanel, "Center");
        this.inspectorPanel.add((Component)removeButtonBox, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buttonBox, "South");
        this.tabPane = new JTabbedPane(){

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 0);
            }
        };
        this.tabPane.addTab("About", this.infoPanel);
        AbstractScrollable consoleScrollable = new AbstractScrollable(){

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        consoleScrollable.setLayout(new BorderLayout());
        consoleScrollable.add((Component)controlPanel, "Center");
        JScrollPane controlScroll = new JScrollPane(consoleScrollable){
            Insets insets;
            {
                this.insets = new Insets(0, 0, 0, 0);
            }

            public Insets getInsets() {
                return this.insets;
            }
        };
        controlScroll.getViewport().setBackground(transparentBackground);
        this.tabPane.addTab("Console", controlScroll);
        this.tabPane.addTab("Displays", frameListPanel);
        this.tabPane.addTab("Inspectors", this.inspectorPanel);
        this.buildModelInspector();
        this.getContentPane().add((Component)this.tabPane, "Center");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        this.menuBar.add(fileMenu);
        Console.buildClassList();
        JMenuItem _new = new JMenuItem("New Simulation...");
        if (!allowOtherClassNames && classNames.size() == 0) {
            _new.setEnabled(false);
        }
        _new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doNew();
            }
        });
        fileMenu.add(_new);
        JMenuItem open = new JMenuItem("Open...");
        if (SimApplet.isApplet) {
            open.setEnabled(false);
        }
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doOpen();
            }
        });
        fileMenu.add(open);
        JMenuItem save = new JMenuItem("Save");
        if (SimApplet.isApplet) {
            save.setEnabled(false);
        }
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doChangeCode(new Runnable(){

                    public void run() {
                        Console.this.doSave();
                    }
                });
            }
        });
        fileMenu.add(save);
        JMenuItem saveAs = new JMenuItem("Save As...");
        if (SimApplet.isApplet) {
            saveAs.setEnabled(false);
        }
        saveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doChangeCode(new Runnable(){

                    public void run() {
                        Console.this.doSaveAs();
                    }
                });
            }
        });
        fileMenu.add(saveAs);
        JMenuItem _about = new JMenuItem("About MASON");
        _about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doAbout();
            }
        });
        fileMenu.add(_about);
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this.doQuit();
            }
        });
        fileMenu.add(quit);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint(Console.this.getContentPane());
                Utilities.doEnsuredRepaint(Console.this.menuBar);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Console.this.doClose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setSize(380, 380);
        Point defLoc = this.getLocation();
        this.setLocation(-10000, -10000);
        this.setResizable(true);
        this.repaint();
        allConsoles.put(this, this);
        ++numConsoles;
        simulation.init(this);
        Point loc = this.getLocation();
        if (loc.x == -10000 && loc.y == -10000) {
            Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            Iterator i = this.frameList.iterator();
            while (i.hasNext()) {
                bounds = bounds.union(((Component)i.next()).getBounds());
            }
            if (bounds.width + this.getWidth() + 5 <= screen.width) {
                this.setLocation(bounds.width + 5, defLoc.y);
            } else {
                this.setLocation(defLoc);
            }
        }
    }

    void buildModelInspector() {
        if (this.modelInspectorScrollPane != null) {
            this.tabPane.remove(this.modelInspectorScrollPane);
        }
        this.modelInspector = this.simulation.getInspector();
        if (this.modelInspector != null) {
            String name = this.modelInspector.getName();
            if (name == null || name.length() == 0) {
                name = "Model";
            }
            this.modelInspectorScrollPane = new JScrollPane(this.modelInspector){
                Insets insets;
                {
                    this.insets = new Insets(0, 0, 0, 0);
                }

                public Insets getInsets() {
                    return this.insets;
                }
            };
            this.modelInspectorScrollPane.getViewport().setBackground(new JPanel().getBackground());
            this.tabPane.addTab(name, this.modelInspectorScrollPane);
        }
        this.tabPane.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldRepeat(boolean val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.shouldRepeat = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getShouldRepeat() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.shouldRepeat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPriority(int val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.threadPriority = val;
            if (this.playThread != null) {
                this.playThread.setPriority(this.threadPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadPriority() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.threadPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldEnd(long val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldEnd = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWhenShouldEnd() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldEnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldPause(long val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldPause = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWhenShouldPause() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldPause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldEndTime(double val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldEndTime = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWhenShouldEndTime() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldPauseTime(double val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldPauseTime = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWhenShouldPauseTime() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldPauseTime;
        }
    }

    public void setPlaySleep(final long sleep) {
        this.doChangeCode(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = Console.this.playThreadLock;
                synchronized (object) {
                    Console.this.playSleep = sleep;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPlaySleep() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.playSleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThreadShouldStop() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.threadShouldStop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadShouldStop(boolean stop) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.threadShouldStop = stop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlayState(int state) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.playState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.playState;
        }
    }

    void startSimulation() {
        this.removeAllInspectors(true);
        this.setRandomNumberGenerator(this.randomSeed);
        this.simulation.start();
        this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.time(), -1.0);
        if (this.modelInspector != null) {
            Steppable stepper = new Steppable(){

                public void step(final SimState state) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Schedule schedule = state.schedule;
                            synchronized (schedule) {
                                if ((this).Console.this.modelInspector.isVolatile()) {
                                    (this).Console.this.modelInspector.updateInspector();
                                    (this).Console.this.modelInspector.repaint();
                                }
                            }
                        }
                    });
                }
            };
            if (this.modelInspector.isVolatile()) {
                this.simulation.scheduleImmediateRepeat(true, stepper);
            }
        }
    }

    public synchronized JTabbedPane getTabPane() {
        return this.tabPane;
    }

    void setRandomNumberGenerator(final int val) {
        this.doChangeCode(new Runnable(){

            public void run() {
                Console.this.simulation.state.setRandom(new MersenneTwisterFast(val));
            }
        });
        this.randomField.setValue("" + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuit() {
        Object object = isQuittingLock;
        synchronized (object) {
            if (isQuitting) {
                return;
            }
            isQuitting = true;
            Object[] entries = allConsoles.entrySet().toArray();
            for (int x = 0; x < entries.length; ++x) {
                if (entries[x] == null) continue;
                ((Console)((Map.Entry)entries[x]).getKey()).doClose();
            }
            if (!SimApplet.isApplet) {
                try {
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            isQuitting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        Object object = this.isClosingLock;
        synchronized (object) {
            if (this.isClosing) {
                return;
            }
            this.isClosing = true;
        }
        this.pressStop();
        this.simulation.quit();
        this.dispose();
        allConsoles.remove(this);
        if (--numConsoles <= 0) {
            this.doQuit();
        }
    }

    public static void main(String[] args) {
        sacrificial = Display2D.isMacOSX();
        if (!Console.doNew(null, true) && !SimApplet.isApplet) {
            System.exit(0);
        }
    }

    public void doAbout() {
        if (aboutFrame == null) {
            aboutFrame = new JFrame("About MASON");
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(25, 30, 30, 30));
            Box b = new Box(1);
            p.add((Component)b, "Center");
            aboutFrame.getContentPane().add((Component)p, "Center");
            aboutFrame.setResizable(false);
            Font small = new Font("Dialog", 0, 9);
            JLabel j = new JLabel("MASON");
            j.setFont(new Font("Serif", 0, 36));
            b.add(j);
            NumberFormat n = NumberFormat.getInstance();
            n.setMinimumFractionDigits(0);
            j = new JLabel("Version " + n.format(SimState.version()));
            b.add(j);
            JLabel spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("Co-created by George Mason University's");
            b.add(j);
            j = new JLabel("Evolutionary Computation Laboratory and");
            b.add(j);
            j = new JLabel("Center for Social Complexity");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("http://cs.gmu.edu/~eclab/projects/mason/");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("Major contributors include Sean Luke,");
            b.add(j);
            j = new JLabel("Gabriel Catalin Balan, Liviu Panait,");
            b.add(j);
            j = new JLabel("Claudio Cioffi-Revilla, Sean Paus,");
            b.add(j);
            j = new JLabel("Keith Sullivan, and Daniel Kuebrich.");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("MASON is (c) 2005 Sean Luke and George Mason University,");
            j.setFont(small);
            b.add(j);
            j = new JLabel("with various elements copyrighted by the above contributors.");
            j.setFont(small);
            b.add(j);
            j = new JLabel("PNGEncoder is (c) 2000 J. David Eisenberg.  MovieEncoder,", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("SelectionBehavior, and WireFrameBoxPortrayal3D are partly", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("(c) 1996 Sun Microsystems.  MersenneTwisterFast is partly", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("(c) 1993 Michael Lecuyer.  CapturingCanvas3D is based in", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("part on code by Peter Kunszt.", 2);
            j.setFont(small);
            b.add(j);
            aboutFrame.pack();
        }
        if (!aboutFrame.isVisible()) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            d.width -= aboutFrame.getWidth();
            d.height -= aboutFrame.getHeight();
            d.width /= 2;
            d.height /= 2;
            if (d.width < 0) {
                d.width = 0;
            }
            if (d.height < 0) {
                d.height = 0;
            }
            aboutFrame.setLocation(d.width, d.height);
        }
        aboutFrame.setVisible(true);
    }

    public void doNew() {
        Console.doNew(this, false);
    }

    static int showOptionDialog(JFrame originalFrame, JComponent component, String title, Object[] options, boolean resizable) {
        JOptionPane p = new JOptionPane(component, -1, 2, null, options, options[0]);
        JDialog d = p.createDialog(originalFrame, title);
        d.pack();
        d.setResizable(resizable);
        p.selectInitialValue();
        d.setVisible(true);
        for (int counter = 0; counter < options.length; ++counter) {
            if (!options[counter].equals(p.getValue())) continue;
            return counter;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void buildClassList() {
        Object object = classLock;
        synchronized (object) {
            if (classListLoaded) {
                return;
            }
            classListLoaded = true;
        }
        allowOtherClassNames = true;
        try {
            InputStream s = Console.class.getResourceAsStream("simulation.classes");
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(s)));
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 31);
            st.commentChar(35);
            boolean errout = false;
            String nextName = null;
            while (st.nextToken() != -1) {
                if (st.sval == null) continue;
                if ("ONLY".equalsIgnoreCase(st.sval)) {
                    allowOtherClassNames = false;
                    continue;
                }
                if (st.sval.toUpperCase().startsWith("NAME:")) {
                    nextName = st.sval.substring(5).trim();
                    continue;
                }
                String shortName = null;
                if (nextName == null) {
                    try {
                        Class<?> c = Class.forName(st.sval);
                        try {
                            shortName = GUIState.getName(c);
                        }
                        catch (Throwable e) {
                            shortName = GUIState.getTruncatedName(c);
                        }
                    }
                    catch (Throwable e) {
                        if (!errout) {
                            System.err.println("Not all classes loaded, due to error: probably no Java3D");
                        }
                        errout = true;
                    }
                } else {
                    shortName = nextName;
                    nextName = null;
                }
                if (shortName == null) continue;
                classNames.add(st.sval);
                shortNames.add(shortName);
            }
            if (nextName != null) {
                System.err.println("Spurious NAME tag at end of simulation.classes file:\n\tNAME: " + nextName);
            }
            s.close();
        }
        catch (Exception e) {
            System.err.println("Couldn't load the simulation.classes file because of error. \nLikely the file does not exist or could not be opened.\nThe error was:\n");
            e.printStackTrace();
        }
    }

    static boolean doNew(JFrame originalFrame, boolean startingUp) {
        Console.buildClassList();
        String defaultText = "<html><body bgcolor='white'><font face='dialog'><br><br><br><br><p align='center'>Select a MASON simulation from the list at left,<br>or type a Java class name below.</p></font></body></html>";
        String nothingSelectedText = "<html><body bgcolor='white'></body></html>";
        while (true) {
            final JList<Object> list = new JList<Object>(classNames);
            JScrollPane pane = new JScrollPane(list);
            list.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (index >= 0) {
                        label.setText("<html><body><font face='dialog'> " + shortNames.get(index) + "<font size='-2' color='#AAAAAA'><br> " + classNames.get(index) + "</font></font></body></html>");
                    }
                    return label;
                }
            });
            final HTMLBrowser browser = new HTMLBrowser("<html><body bgcolor='white'><font face='dialog'><br><br><br><br><p align='center'>Select a MASON simulation from the list at left,<br>or type a Java class name below.</p></font></body></html>"){

                public Dimension getPreferredSize() {
                    return new Dimension(400, 400);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(10, 10);
                }
            };
            final JTextField field = new JTextField("sim.app.");
            JPanel fieldp = new JPanel();
            fieldp.setLayout(new BorderLayout());
            fieldp.add((Component)field, "Center");
            fieldp.add((Component)new JLabel("Simulation class name: "), "West");
            fieldp.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        try {
                            field.setText((String)list.getSelectedValue());
                            browser.setText(GUIState.getInfo(Class.forName(field.getText())));
                        }
                        catch (Throwable ex) {
                            field.setText((String)list.getSelectedValue());
                            browser.setText("<html><body bgcolor='white'></body></html>");
                        }
                    }
                }
            });
            list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Container c = list;
                        while (c.getParent() != null) {
                            c = c.getParent();
                        }
                        ((Window)c).dispose();
                    }
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)browser, "Center");
            p.add((Component)pane, "West");
            p.add((Component)fieldp, "South");
            int reply = Console.showOptionDialog(null, p, "New Simulation", new Object[]{"Select", startingUp ? "Quit" : "Cancel"}, true);
            if (reply == 1) {
                return false;
            }
            String className = field.getText();
            try {
                Constructor<?> cons = Class.forName(className).getConstructor(new Class[0]);
                GUIState state = (GUIState)Class.forName(className).newInstance();
                Console c = new Console(state);
                c.setVisible(true);
                return true;
            }
            catch (NoSuchMethodException e) {
                Utilities.informOfError(e, "The simulation does not have a default constructor: " + className, originalFrame);
                continue;
            }
            catch (Throwable e) {
                Utilities.informOfError(e, "An error occurred while creating the simulation " + className, originalFrame);
                continue;
            }
            break;
        }
    }

    public void doSaveAs() {
        FileDialog fd = new FileDialog((Frame)this, "Save Simulation As...", 1);
        if (this.simulationFile == null) {
            fd.setFile("Untitled.checkpoint");
        } else {
            fd.setFile(this.simulationFile.getName());
            fd.setDirectory(this.simulationFile.getParentFile().getPath());
        }
        fd.setVisible(true);
        File f = null;
        if (fd.getFile() != null) {
            try {
                f = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".checkpoint"));
                this.simulation.state.writeToCheckpoint(f);
                this.simulationFile = f;
            }
            catch (Exception e) {
                Utilities.informOfError(e, "An error occurred while saving the simulation to the file " + (f == null ? " " : f.getName()), null);
            }
        }
    }

    public void doSave() {
        if (this.simulationFile == null) {
            this.doSaveAs();
        } else {
            try {
                this.simulation.state.writeToCheckpoint(this.simulationFile);
            }
            catch (Exception e) {
                Utilities.informOfError(e, "An error occurred while saving the simulation to the file " + this.simulationFile.getName(), null);
            }
        }
    }

    public void doOpen() {
        FileDialog fd = new FileDialog((Frame)this, "Load Saved Simulation...", 0);
        fd.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return Utilities.ensureFileEndsWith(name, ".checkpoint").equals(name);
            }
        });
        if (this.simulationFile != null) {
            fd.setFile(this.simulationFile.getName());
            fd.setDirectory(this.simulationFile.getParentFile().getPath());
        }
        boolean failed = true;
        int originalPlayState = this.getPlayState();
        if (originalPlayState == 1) {
            this.pressPause();
        }
        fd.setVisible(true);
        File f = null;
        if (fd.getFile() != null) {
            try {
                f = new File(fd.getDirectory(), fd.getFile());
                if (!this.simulation.readNewStateFromCheckpoint(f)) {
                    throw new RuntimeException("Invalid SimState class.  Original state: " + this.simulation.state);
                }
                this.simulationFile = f;
                this.buildModelInspector();
                this.removeAllInspectors(true);
                if (originalPlayState == 0) {
                    this.pressPause(false);
                }
                failed = false;
            }
            catch (Throwable e) {
                Utilities.informOfError(e, "An error occurred while loading the simulation from the file " + (f == null ? fd.getFile() : f.getName()), null);
            }
        }
        if (failed && originalPlayState == 1) {
            this.pressPause();
        }
        this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.time(), -1.0);
        this.randomField.setValue("Unknown");
    }

    synchronized void pressShow() {
        Object[] vals = this.frameListDisplay.getSelectedValues();
        for (int x = 0; x < vals.length; ++x) {
            ((JFrame)vals[x]).toFront();
            ((JFrame)vals[x]).setVisible(true);
        }
        this.frameListDisplay.repaint();
    }

    synchronized void pressShowAll() {
        Object[] vals = this.frameList.toArray();
        for (int x = 0; x < vals.length; ++x) {
            ((JFrame)vals[x]).toFront();
            ((JFrame)vals[x]).setVisible(true);
        }
        this.frameListDisplay.repaint();
    }

    synchronized void pressHide() {
        Object[] vals = this.frameListDisplay.getSelectedValues();
        for (int x = 0; x < vals.length; ++x) {
            ((JFrame)vals[x]).setVisible(false);
        }
        this.frameListDisplay.repaint();
    }

    synchronized void pressHideAll() {
        Object[] vals = this.frameList.toArray();
        for (int x = 0; x < vals.length; ++x) {
            ((JFrame)vals[x]).setVisible(false);
        }
        this.frameListDisplay.repaint();
    }

    public synchronized void pressStop() {
        if (this.getPlayState() != 0) {
            this.stopButton.setIcon(I_STOP_ON);
            this.stopButton.setPressedIcon(I_STOP_OFF);
            this.playButton.setIcon(I_PLAY_OFF);
            this.playButton.setPressedIcon(I_PLAY_ON);
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.repaint();
            this.killPlayThread();
            this.simulation.finish();
            this.stopAllInspectors(true);
            this.setPlayState(0);
            this.repaint();
            if (this.incrementSeedOnPlay.isSelected()) {
                ++this.randomSeed;
                this.setRandomNumberGenerator(this.randomSeed);
            }
        }
        if (this.getShouldRepeat()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Console.this.pressPlay();
                }
            });
        }
    }

    public synchronized void pressPause() {
        this.pressPause(true);
    }

    synchronized void pressPause(boolean shouldStartSimulationIfStopped) {
        if (this.getPlayState() == 1) {
            this.killPlayThread();
            this.pauseButton.setIcon(I_PAUSE_ON);
            this.pauseButton.setPressedIcon(I_PAUSE_OFF);
            this.playButton.setIcon(I_STEP_OFF);
            this.playButton.setPressedIcon(I_STEP_ON);
            this.setPlayState(2);
            this.refresh();
        } else if (this.getPlayState() == 2) {
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.playButton.setIcon(I_PLAY_ON);
            this.playButton.setPressedIcon(I_PLAY_OFF);
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 0) {
            if (shouldStartSimulationIfStopped) {
                this.startSimulation();
            }
            this.stopButton.setIcon(I_STOP_OFF);
            this.stopButton.setPressedIcon(I_STOP_ON);
            this.pauseButton.setIcon(I_PAUSE_ON);
            this.pauseButton.setPressedIcon(I_PAUSE_OFF);
            this.playButton.setIcon(I_STEP_OFF);
            this.playButton.setPressedIcon(I_STEP_ON);
            this.setPlayState(2);
            this.refresh();
        }
        this.repaint();
    }

    public synchronized void pressPlay() {
        if (this.getPlayState() == 0) {
            this.stopButton.setIcon(I_STOP_OFF);
            this.stopButton.setPressedIcon(I_STOP_ON);
            this.playButton.setIcon(I_PLAY_ON);
            this.playButton.setPressedIcon(I_PLAY_OFF);
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.repaint();
            this.startSimulation();
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 2) {
            for (int x = 0; x < this.numStepsPerStepButtonPress; ++x) {
                if (!this.simulation.step() || this.simulation.state.schedule.time() >= this.getWhenShouldEndTime() || this.simulation.state.schedule.getSteps() >= this.getWhenShouldEnd()) {
                    this.pressStop();
                    this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.time(), -1.0);
                    break;
                }
                this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.time(), -1.0);
            }
            this.refresh();
        }
        this.repaint();
    }

    void updateTimeText(final String timeString) {
        if (!timeString.equals(this.lastText)) {
            this.lastText = timeString;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Console.this.time.setText(timeString);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTime() {
        double rate;
        double time;
        long steps;
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            steps = this.lastSteps;
            time = this.lastTime;
            rate = this.lastRate;
        }
        this.updateTime(steps, time, rate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTime(long steps, double time, double rate) {
        int showing;
        boolean simulationExists = this.simulation != null && this.simulation.state != null;
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            this.lastRate = rate;
            this.lastSteps = steps;
            this.lastTime = time;
            showing = this.showing;
        }
        switch (showing) {
            case 0: {
                this.updateTimeText(simulationExists ? this.simulation.state.schedule.getTimestamp(this.lastTime, "At Start", "At End") : "");
                break;
            }
            case 1: {
                this.updateTimeText(simulationExists ? "" + this.lastSteps : "");
                break;
            }
            case 2: {
                if (this.lastRate == 0.0) break;
                this.updateTimeText(this.lastRate < 0.0 ? "" : this.rateFormat.format(this.lastRate));
                break;
            }
            default: {
                this.updateTimeText("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStepsPerSecond() {
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            return this.lastRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void killPlayThread() {
        block8: {
            this.setThreadShouldStop(true);
            try {
                if (this.playThread == null) break block8;
                do {
                    try {
                        Schedule schedule = this.simulation.state.schedule;
                        synchronized (schedule) {
                            this.playThread.interrupt();
                        }
                    }
                    catch (SecurityException ex) {
                        // empty catch block
                    }
                    this.playThread.join(50L);
                } while (this.playThread.isAlive());
                this.playThread = null;
            }
            catch (InterruptedException e) {
                System.err.println("This should never happen: " + e);
            }
        }
    }

    synchronized void spawnPlayThread() {
        this.setThreadShouldStop(false);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    long lastStepTime = System.currentTimeMillis();
                    int currentSteps = 0;
                    double currentRate = 0.0;
                    long RATE_UPDATE_INTERVAL = 500L;
                    if (!Thread.currentThread().isInterrupted() && !Console.this.getThreadShouldStop()) {
                        try {
                            SwingUtilities.invokeAndWait(Console.this.blocker);
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.currentThread().interrupt();
                            }
                            catch (SecurityException ex) {}
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("This should never happen: " + e);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean result = true;
                    while (!Console.this.getThreadShouldStop()) {
                        result = Console.this.simulation.step();
                        double t = Console.this.simulation.state.schedule.time();
                        long s = Console.this.simulation.state.schedule.getSteps();
                        ++currentSteps;
                        long l = System.currentTimeMillis();
                        if (l - lastStepTime >= 500L) {
                            currentRate = (double)currentSteps / ((double)(l - lastStepTime) / 1000.0);
                            currentSteps = 0;
                            lastStepTime = l;
                        }
                        Console.this.updateTime(s, t, currentRate);
                        if (!Thread.currentThread().isInterrupted() && !Console.this.getThreadShouldStop()) {
                            try {
                                SwingUtilities.invokeAndWait(Console.this.blocker);
                            }
                            catch (InterruptedException e) {
                                try {
                                    Thread.currentThread().interrupt();
                                }
                                catch (SecurityException ex) {}
                            }
                            catch (InvocationTargetException e) {
                                System.err.println("This should never happen" + e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!result || Console.this.getThreadShouldStop() || t >= Console.this.getWhenShouldEndTime() || t >= Console.this.getWhenShouldPauseTime() || s >= Console.this.getWhenShouldEnd() || s >= Console.this.getWhenShouldPause()) break;
                        long sleep = Console.this.getPlaySleep();
                        if (sleep <= 0L || Thread.currentThread().isInterrupted() || Console.this.getThreadShouldStop()) continue;
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.currentThread().interrupt();
                            }
                            catch (SecurityException ex) {
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!result || Console.this.simulation.state.schedule.time() >= Console.this.getWhenShouldEndTime() || Console.this.simulation.state.schedule.getSteps() >= Console.this.getWhenShouldEnd()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Console.this.pressStop();
                                }
                                catch (Exception e) {
                                    System.err.println("This should never happen: " + e);
                                }
                            }
                        });
                    } else if (Console.this.simulation.state.schedule.time() >= Console.this.getWhenShouldPauseTime() || Console.this.simulation.state.schedule.getSteps() >= Console.this.getWhenShouldPause()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Console.this.pressPause();
                                    (this).Console.this.pauseField.setValue("");
                                    (this).Console.this.timePauseField.setValue("");
                                    Console.this.setWhenShouldPause(Long.MAX_VALUE);
                                }
                                catch (Exception e) {
                                    System.err.println("This should never happen: " + e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.playThread = new Thread(run);
        this.playThread.setPriority(this.getThreadPriority());
        this.playThread.start();
    }

    public synchronized boolean registerFrame(JFrame frame) {
        this.frameList.add(frame);
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    public synchronized boolean unregisterFrame(JFrame frame) {
        this.frameList.removeElement(frame);
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    public synchronized boolean unregisterAllFrames() {
        this.frameList.removeAllElements();
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    public synchronized void doChangeCode(Runnable r) {
        if (this.playThread != null) {
            this.killPlayThread();
            r.run();
            this.spawnPlayThread();
        } else {
            r.run();
        }
    }

    public void refresh() {
        Enumeration e = this.frameList.elements();
        while (e.hasMoreElements()) {
            ((JFrame)e.nextElement()).getContentPane().repaint();
        }
        Iterator i = this.allInspectors.keySet().iterator();
        while (i.hasNext()) {
            Inspector c = (Inspector)i.next();
            if (c == null || !c.isVolatile()) continue;
            c.updateInspector();
            c.repaint();
        }
        if (this.modelInspector != null && this.modelInspector.isVolatile()) {
            this.modelInspector.updateInspector();
            this.modelInspector.repaint();
        }
        this.getContentPane().repaint();
    }

    void resetInspectors(int preferredSelection) {
        this.inspectorSwitcher = new JPanel();
        this.inspectorCardLayout = new CardLayout();
        this.inspectorSwitcher.setLayout(this.inspectorCardLayout);
        int loc = this.innerInspectorPanel.getDividerLocation();
        this.innerInspectorPanel.setBottomComponent(this.inspectorSwitcher);
        this.innerInspectorPanel.setDividerLocation(loc);
        for (int x = 0; x < this.inspectorToolbars.size(); ++x) {
            this.inspectorSwitcher.add((Component)((JComponent)this.inspectorToolbars.elementAt(x)), "" + x);
        }
        this.inspectorSwitcher.add((Component)new JPanel(), "-1");
        this.inspectorList.setListData(this.inspectorNames);
        if (preferredSelection >= this.inspectorToolbars.size()) {
            preferredSelection = 0;
        }
        if (preferredSelection >= this.inspectorToolbars.size()) {
            preferredSelection = -1;
        }
        this.inspectorCardLayout.show(this.inspectorSwitcher, "" + preferredSelection);
        this.inspectorList.setSelectedIndex(preferredSelection);
        boolean shouldEnableButtons = this.inspectorNames.size() > 0;
        this.detatchButton.setEnabled(shouldEnableButtons);
        this.removeButton.setEnabled(shouldEnableButtons);
    }

    void detatchInspector() {
        int currentInspector = this.inspectorList.getSelectedIndex();
        if (currentInspector == -1) {
            return;
        }
        this.inspectorNames.remove(currentInspector);
        Stoppable stoppable = (Stoppable)this.inspectorStoppables.remove(currentInspector);
        JScrollPane oldInspector = (JScrollPane)this.inspectorToolbars.remove(currentInspector);
        Point oldInspectorLocation = oldInspector.getLocationOnScreen();
        Inspector i = (Inspector)oldInspector.getViewport().getView();
        oldInspector.remove(i);
        JFrame frame = i.createFrame(stoppable);
        frame.setLocation(oldInspectorLocation);
        frame.setVisible(true);
        if (this.inspectorNames.size() == 0) {
            currentInspector = -1;
        } else if (currentInspector == this.inspectorNames.size()) {
            --currentInspector;
        }
        this.resetInspectors(currentInspector);
    }

    public void setInspectors(final Bag inspectors, Bag names) {
        this.removeAllInspectors(false);
        if (inspectors.numObjs != names.numObjs) {
            throw new RuntimeException("Number of inspectors and names do not match");
        }
        for (int x = 0; x < inspectors.numObjs; ++x) {
            if (inspectors.objs[x] == null) continue;
            final int xx = x;
            Steppable stepper = new Steppable(){

                public void step(final SimState state) {
                    SwingUtilities.invokeLater(new Runnable(){
                        Inspector inspector;
                        {
                            this.inspector = (Inspector)(this).inspectors.objs[xx];
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Schedule schedule = state.schedule;
                            synchronized (schedule) {
                                if (this.inspector.isVolatile()) {
                                    this.inspector.updateInspector();
                                    this.inspector.repaint();
                                }
                            }
                        }
                    });
                }
            };
            Stoppable stopper = null;
            try {
                stopper = ((Inspector)inspectors.objs[x]).reviseStopper(this.simulation.scheduleImmediateRepeat(true, stepper));
                this.inspectorStoppables.addElement(stopper);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            this.registerInspector((Inspector)inspectors.objs[x], stopper);
            JScrollPane scrollInspector = new JScrollPane((Component)inspectors.objs[x]);
            scrollInspector.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.inspectorSwitcher.add((Component)scrollInspector, "" + x);
            this.inspectorNames.addElement((String)names.objs[x]);
            this.inspectorToolbars.add(scrollInspector);
        }
        this.resetInspectors(0);
        try {
            this.tabPane.setSelectedComponent(this.inspectorPanel);
            Utilities.doEnsuredRepaint(this.inspectorPanel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void registerInspector(Inspector inspector, Stoppable stopper) {
        this.allInspectors.put(inspector, new WeakReference<Stoppable>(stopper));
    }

    public void stopAllInspectors(boolean killDraggedOutWindowsToo) {
        for (int x = 0; x < this.inspectorStoppables.size(); ++x) {
            Stoppable temp = (Stoppable)this.inspectorStoppables.elementAt(x);
            if (temp == null) continue;
            temp.stop();
        }
        if (killDraggedOutWindowsToo) {
            Iterator i = this.allInspectors.keySet().iterator();
            while (i.hasNext()) {
                Stoppable stopper = (Stoppable)((WeakReference)this.allInspectors.get(i.next())).get();
                if (stopper == null) continue;
                stopper.stop();
            }
        }
    }

    public void removeAllInspectors(boolean killDraggedOutWindowsToo) {
        this.stopAllInspectors(killDraggedOutWindowsToo);
        if (killDraggedOutWindowsToo) {
            Iterator i = this.allInspectors.keySet().iterator();
            while (i.hasNext()) {
                Component inspector;
                for (inspector = (Component)i.next(); inspector != null && !(inspector instanceof JFrame); inspector = inspector.getParent()) {
                }
                if (inspector == null || inspector == this) continue;
                ((JFrame)inspector).dispose();
            }
            this.allInspectors = new WeakHashMap();
        }
        this.inspectorNames = new Vector();
        this.inspectorToolbars = new Vector();
        this.resetInspectors(-1);
    }

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, (Object[])null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        I_PLAY_ON = Console.iconFor("Playing.png");
        I_PLAY_OFF = Console.iconFor("NotPlaying.png");
        I_STOP_ON = Console.iconFor("Stopped.png");
        I_STOP_OFF = Console.iconFor("NotStopped.png");
        I_PAUSE_ON = Console.iconFor("PauseOn.png");
        I_PAUSE_OFF = Console.iconFor("PauseOff.png");
        I_STEP_ON = Console.iconFor("StepOn.png");
        I_STEP_OFF = Console.iconFor("StepOff.png");
        isQuitting = false;
        isQuittingLock = new Object();
        allConsoles = new WeakHashMap();
        aboutFrame = null;
        classLock = new Object();
        classListLoaded = false;
    }
}

