/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import sim.display.Console;
import sim.display.GUIState;
import sim.display.SimApplet;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.util.Bag;
import sim.util.Utilities;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.NumberTextField;
import sim.util.media.PDFEncoder;
import sim.util.media.PngEncoder;

public class Display2D
extends JComponent
implements Steppable {
    public static final boolean isMacOSX = Display2D.isMacOSX();
    public static final boolean isWindows = Display2D.isWindows();
    public static final String javaVersion = Display2D.getVersion();
    public static final ImageIcon LAYERS_ICON;
    public static final ImageIcon LAYERS_ICON_P;
    public static final ImageIcon MOVIE_ON_ICON;
    public static final ImageIcon MOVIE_ON_ICON_P;
    public static final ImageIcon MOVIE_OFF_ICON;
    public static final ImageIcon MOVIE_OFF_ICON_P;
    public static final ImageIcon CAMERA_ICON;
    public static final ImageIcon CAMERA_ICON_P;
    public static final ImageIcon OPTIONS_ICON;
    public static final ImageIcon OPTIONS_ICON_P;
    public boolean useTooltips;
    long lastEncodedSteps = -1L;
    public MovieMaker movieMaker;
    public InnerDisplay2D insideDisplay;
    public OptionPane optionPane = new OptionPane("");
    ArrayList portrayals = new ArrayList();
    JScrollPane display;
    JViewport port;
    Stoppable stopper;
    GUIState simulation;
    public Box header;
    public JPopupMenu popup;
    public JToggleButton togglebutton;
    public JButton movieButton;
    public JButton snapshotButton;
    public JButton optionButton;
    public NumberTextField scaleField;
    public NumberTextField skipField;
    double scale = 1.0;
    final Object scaleLock = new Object();
    long interval = 1L;
    Object intervalLock = new Object();
    boolean clipping = true;
    Paint backdrop = Color.white;
    static final int MAX_TOOLTIP_LINES = 10;
    ArrayList selectedWrappers = new ArrayList();
    static final int SCROLL_BAR_SCROLL_RATIO = 10;
    private Object sacrificialObj = null;

    static boolean isMacOSX() {
        try {
            return System.getProperty("mrj.version") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isWindows() {
        try {
            return !Display2D.isMacOSX() && System.getProperty("os.name").startsWith("Win");
        }
        catch (Throwable e) {
            return false;
        }
    }

    static String getVersion() {
        try {
            return System.getProperty("java.version");
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(Display2D.class.getResource(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double val) {
        Object object = this.scaleLock;
        synchronized (object) {
            if (val > 0.0) {
                this.scale = val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        Object object = this.scaleLock;
        synchronized (object) {
            return this.scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long i) {
        Object object = this.intervalLock;
        synchronized (object) {
            if (i > 0L) {
                this.interval = i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInterval() {
        Object object = this.intervalLock;
        synchronized (object) {
            return this.interval;
        }
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean val) {
        this.clipping = val;
    }

    public void setBackdrop(Paint c) {
        this.backdrop = c;
    }

    public Paint getBackdrop() {
        return this.backdrop;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.quit();
    }

    public void quit() {
        if (this.stopper != null) {
            this.stopper.stop();
        }
        this.stopper = null;
        this.stopMovie();
    }

    public void reset() {
        if (this.stopper != null) {
            this.stopper.stop();
        }
        this.stopper = this.simulation.scheduleImmediateRepeat(true, this);
        for (int x = 0; x < this.selectedWrappers.size(); ++x) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
    }

    public void attach(FieldPortrayal2D portrayal, String name) {
        this.attach(portrayal, name, true);
    }

    public void attach(FieldPortrayal2D portrayal, String name, Rectangle2D.Double bounds) {
        this.attach(portrayal, name, bounds, true);
    }

    public void attach(FieldPortrayal2D portrayal, String name, boolean visible) {
        this.attach(portrayal, name, 0.0, 0.0, visible);
    }

    public void attach(FieldPortrayal2D portrayal, String name, double x, double y, boolean visible) {
        this.attach(portrayal, name, new Rectangle2D.Double(x, y, this.insideDisplay.width, this.insideDisplay.height), visible);
    }

    public void attach(FieldPortrayal2D portrayal, String name, Rectangle2D.Double bounds, boolean visible) {
        FieldPortrayal2DHolder p = new FieldPortrayal2DHolder(portrayal, name, bounds, visible);
        this.portrayals.add(p);
        this.popup.add(p.menuItem);
    }

    public void attach(final Inspector inspector, final String name) {
        JMenuItem consoleMenu = new JMenuItem("Show " + name);
        this.popup.add(consoleMenu);
        consoleMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Bag inspectors = new Bag();
                inspectors.add(inspector);
                Bag names = new Bag();
                names.add(name);
                Display2D.this.simulation.controller.setInspectors(inspectors, names);
            }
        });
    }

    public void createConsoleMenu() {
        if (this.simulation != null && this.simulation.controller != null && this.simulation.controller instanceof Console) {
            final Console c = (Console)this.simulation.controller;
            JMenuItem consoleMenu = new JMenuItem("Show Console");
            this.popup.add(consoleMenu);
            consoleMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    c.setVisible(true);
                }
            });
        }
        this.popup.addSeparator();
    }

    public ArrayList detatchAll() {
        ArrayList old = this.portrayals;
        this.popup.removeAll();
        this.createConsoleMenu();
        this.portrayals = new ArrayList();
        return old;
    }

    public Display2D(double width, double height, GUIState simulation, long interval) {
        this.setInterval(interval);
        this.simulation = simulation;
        this.reset();
        Color transparentBackground = new JPanel().getBackground();
        this.insideDisplay = new InnerDisplay2D(width, height);
        this.display = new JScrollPane(this.insideDisplay, 22, 32);
        this.display.setMinimumSize(new Dimension(0, 0));
        this.display.setBorder(null);
        this.display.getHorizontalScrollBar().setBorder(null);
        this.display.getVerticalScrollBar().setBorder(null);
        this.port = this.display.getViewport();
        this.insideDisplay.setViewRect(this.port.getViewRect());
        this.insideDisplay.setOpaque(true);
        this.insideDisplay.setBackground(UIManager.getColor("Panel.background"));
        this.display.setBackground(UIManager.getColor("Panel.background"));
        this.port.setBackground(UIManager.getColor("Panel.background"));
        this.header = new Box(0);
        this.togglebutton = new JToggleButton(LAYERS_ICON);
        this.togglebutton.setPressedIcon(LAYERS_ICON_P);
        this.togglebutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.togglebutton.setBorderPainted(false);
        this.togglebutton.setContentAreaFilled(false);
        this.togglebutton.setToolTipText("Show and hide different layers");
        this.header.add(this.togglebutton);
        this.popup = new JPopupMenu();
        this.popup.setLightWeightPopupEnabled(false);
        this.togglebutton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Display2D.this.popup.show(e.getComponent(), Display2D.this.togglebutton.getLocation().x, Display2D.this.togglebutton.getSize().height);
            }

            public void mouseReleased(MouseEvent e) {
                Display2D.this.togglebutton.setSelected(false);
            }
        });
        this.insideDisplay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                if (e.getClickCount() == 2) {
                    Display2D.this.createInspectors(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0), Display2D.this.simulation);
                }
                if (e.getClickCount() == 1 || e.getClickCount() == 2) {
                    Display2D.this.performSelection(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0));
                }
                Display2D.this.repaint();
            }

            public void mouseExited(MouseEvent event) {
                Display2D.this.insideDisplay.lastToolTipEvent = null;
            }
        });
        this.insideDisplay.setToolTipText("Display");
        this.movieButton = new JButton(MOVIE_OFF_ICON);
        this.movieButton.setPressedIcon(MOVIE_OFF_ICON_P);
        this.movieButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.movieButton.setBorderPainted(false);
        this.movieButton.setContentAreaFilled(false);
        this.movieButton.setToolTipText("Create a Quicktime movie");
        this.movieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Display2D.this.movieMaker == null) {
                    Display2D.this.startMovie();
                } else {
                    Display2D.this.stopMovie();
                }
            }
        });
        this.header.add(this.movieButton);
        this.snapshotButton = new JButton(CAMERA_ICON);
        this.snapshotButton.setPressedIcon(CAMERA_ICON_P);
        this.snapshotButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.snapshotButton.setBorderPainted(false);
        this.snapshotButton.setContentAreaFilled(false);
        this.snapshotButton.setToolTipText("Create a snapshot (as a PNG or PDF file)");
        this.snapshotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display2D.this.takeSnapshot();
            }
        });
        this.header.add(this.snapshotButton);
        this.optionButton = new JButton(OPTIONS_ICON);
        this.optionButton.setPressedIcon(OPTIONS_ICON_P);
        this.optionButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.optionButton.setBorderPainted(false);
        this.optionButton.setContentAreaFilled(false);
        this.optionButton.setToolTipText("Show the Option Pane");
        this.optionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display2D.this.optionPane.setTitle(Display2D.this.getFrame().getTitle() + " Options");
                Display2D.this.optionPane.pack();
                Display2D.this.optionPane.setVisible(true);
            }
        });
        this.header.add(this.optionButton);
        this.scaleField = new NumberTextField("  Scale: ", 1.0, true){

            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                Display2D.this.insideDisplay.paintLock = true;
                Rectangle r = Display2D.this.port.getViewRect();
                double centerx = (double)r.x + (double)r.width / 2.0;
                double centery = (double)r.y + (double)r.height / 2.0;
                Point topleft = new Point((int)((centerx *= newValue / this.currentValue) - (double)r.width / 2.0), (int)((centery *= newValue / this.currentValue) - (double)r.height / 2.0));
                if (topleft.x < 0) {
                    topleft.x = 0;
                }
                if (topleft.y < 0) {
                    topleft.y = 0;
                }
                Display2D.this.setScale(newValue);
                Display2D.this.optionPane.xOffsetField.setValue(Display2D.this.insideDisplay.xOffset * newValue);
                Display2D.this.optionPane.yOffsetField.setValue(Display2D.this.insideDisplay.yOffset * newValue);
                Display2D.this.port.setView(Display2D.this.insideDisplay);
                Display2D.this.insideDisplay.paintLock = false;
                Display2D.this.port.setViewPosition(topleft);
                Display2D.this.repaint();
                return newValue;
            }
        };
        this.scaleField.setToolTipText("Zoom in and out");
        this.header.add(this.scaleField);
        this.skipField = new NumberTextField("  Skip: ", 1.0, false){

            public double newValue(double newValue) {
                int val = (int)newValue;
                if (val < 1) {
                    val = (int)this.currentValue;
                }
                Display2D.this.setInterval(val);
                Display2D.this.reset();
                return val;
            }
        };
        this.skipField.setToolTipText("Specify the number of steps between screen updates");
        this.header.add(this.skipField);
        this.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.add((Component)this.display, "Center");
        this.createConsoleMenu();
    }

    public Bag[] objectsHitBy(Rectangle2D.Double rect) {
        Bag[] hitObjs = new Bag[this.portrayals.size()];
        Iterator iter = this.portrayals.iterator();
        int x = 0;
        while (iter.hasNext()) {
            hitObjs[x] = new Bag();
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)iter.next();
            if (p.visible) {
                p.portrayal.hitObjects(this.getDrawInfo2D(p, (Rectangle2D)rect), hitObjs[x]);
            }
            ++x;
        }
        return hitObjs;
    }

    public DrawInfo2D getDrawInfo2D(FieldPortrayal2D portrayal, Point2D point) {
        return this.getDrawInfo2D(portrayal, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0));
    }

    public DrawInfo2D getDrawInfo2D(FieldPortrayal2D portrayal, Rectangle2D clip) {
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)iter.next();
            if (p.portrayal != portrayal) continue;
            return this.getDrawInfo2D(p, clip);
        }
        return null;
    }

    DrawInfo2D getDrawInfo2D(FieldPortrayal2DHolder holder, Rectangle2D clip) {
        if (holder == null) {
            return null;
        }
        double scale = this.getScale();
        int origindx = 0;
        int origindy = 0;
        origindx += (int)(this.insideDisplay.xOffset * scale);
        origindy += (int)(this.insideDisplay.yOffset * scale);
        Rectangle fullComponent = this.insideDisplay.getViewRect();
        if (((RectangularShape)fullComponent).getWidth() > this.insideDisplay.width * scale) {
            origindx = (int)((((RectangularShape)fullComponent).getWidth() - this.insideDisplay.width * scale) / 2.0);
        }
        if (((RectangularShape)fullComponent).getHeight() > this.insideDisplay.height * scale) {
            origindy = (int)((((RectangularShape)fullComponent).getHeight() - this.insideDisplay.height * scale) / 2.0);
        }
        Rectangle2D.Double region = new Rectangle2D.Double((int)(holder.bounds.x * scale) + origindx, (int)(holder.bounds.y * scale) + origindy, (int)(holder.bounds.width * scale), (int)(holder.bounds.height * scale));
        return new DrawInfo2D((RectangularShape)region, clip);
    }

    public String createToolTipText(Rectangle2D.Double rect, GUIState simulation) {
        String s = "<html><font face=\"" + this.getFont().getFamily() + "\" size=\"-1\">";
        Bag[] hitObjects = this.objectsHitBy(rect);
        int count = 0;
        for (int x = 0; x < hitObjects.length; ++x) {
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)this.portrayals.get(x);
            for (int i = 0; i < hitObjects[x].numObjs; ++i) {
                if (count > 0) {
                    s = s + "<br>";
                }
                if (count >= 10) {
                    return s + "...<i>etc.</i></font></html>";
                }
                ++count;
                String status = p.portrayal.getStatus((LocationWrapper)hitObjects[x].objs[i]);
                if (status == null) continue;
                s = s + status;
            }
        }
        if (count == 0) {
            return null;
        }
        s = s + "</font></html>";
        return s;
    }

    public void performSelection(LocationWrapper wrapper) {
        Bag b = new Bag();
        b.add(wrapper);
        this.performSelection(b);
    }

    public void performSelection(Bag locationWrappers) {
        LocationWrapper wrapper;
        int x;
        for (x = 0; x < this.selectedWrappers.size(); ++x) {
            wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
        if (locationWrappers == null) {
            return;
        }
        for (x = 0; x < locationWrappers.size(); ++x) {
            wrapper = (LocationWrapper)locationWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, true);
            this.selectedWrappers.add(wrapper);
        }
    }

    public void performSelection(Rectangle2D.Double rect) {
        Bag[] hitObjects = this.objectsHitBy(rect);
        Bag collection = new Bag();
        for (int x = 0; x < hitObjects.length; ++x) {
            collection.addAll(hitObjects[x]);
        }
        this.performSelection(collection);
    }

    public void createInspectors(Rectangle2D.Double rect, GUIState simulation) {
        Bag inspectors = new Bag();
        Bag names = new Bag();
        Bag[] hitObjects = this.objectsHitBy(rect);
        for (int x = 0; x < hitObjects.length; ++x) {
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)this.portrayals.get(x);
            for (int i = 0; i < hitObjects[x].numObjs; ++i) {
                LocationWrapper wrapper = (LocationWrapper)hitObjects[x].objs[i];
                inspectors.add(p.portrayal.getInspector(wrapper, simulation));
                names.add(p.portrayal.getName(wrapper));
            }
        }
        simulation.controller.setInspectors(inspectors, names);
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame(){

            public void dispose() {
                Display2D.this.quit();
                super.dispose();
            }
        };
        frame.setResizable(true);
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint(Display2D.this.header);
                Display2D.this.display.getHorizontalScrollBar().setUnitIncrement(Display2D.this.display.getViewport().getWidth() / 10);
                Display2D.this.display.getVerticalScrollBar().setUnitIncrement(Display2D.this.display.getViewport().getHeight() / 10);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this, "Center");
        frame.setTitle(GUIState.getName(this.simulation.getClass()) + " Display");
        frame.pack();
        return frame;
    }

    public Frame getFrame() {
        Container c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeSnapshot() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            FileDialog fd;
            if (SimApplet.isApplet) {
                Object[] options = new Object[]{"Oops"};
                JOptionPane.showOptionDialog(this, "You cannot save snapshots from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
                return;
            }
            boolean havePDF = false;
            Graphics g = this.insideDisplay.getGraphics();
            BufferedImage img = this.insideDisplay.paint(g, true, false);
            try {
                this.sacrificialObj = Class.forName("com.lowagie.text.Cell").newInstance();
                havePDF = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            g.dispose();
            int result = 2;
            if (havePDF) {
                Object[] options = new Object[]{"Cancel", "Save to PDF", "Save to PNG Bitmap"};
                result = JOptionPane.showOptionDialog(this.getFrame(), "Save window snapshot to what kind of file format?", "Save Format", 0, 3, null, options, options[0]);
            }
            if (result == 2) {
                fd = new FileDialog(this.getFrame(), "Save Snapshot as 24-bit PNG...", 1);
                fd.setFile("Untitled.png");
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".png"))));
                        PngEncoder tmpEncoder = new PngEncoder(img, false, 0, 9);
                        ((OutputStream)stream).write(tmpEncoder.pngEncode());
                        ((OutputStream)stream).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (result == 1) {
                fd = new FileDialog(this.getFrame(), "Save Snapshot as PDF...", 1);
                fd.setFile("Untitled.pdf");
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        PDFEncoder.generatePDF(this.port, new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".pdf")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMovie() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (SimApplet.isApplet) {
                Object[] options = new Object[]{"Oops"};
                JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
                return;
            }
            if (this.movieMaker != null) {
                return;
            }
            this.movieMaker = new MovieMaker(this.getFrame());
            Graphics g = this.insideDisplay.getGraphics();
            BufferedImage typicalImage = this.insideDisplay.paint(g, true, false);
            g.dispose();
            if (!this.movieMaker.start(typicalImage)) {
                this.movieMaker = null;
            } else {
                this.movieButton.setIcon(MOVIE_ON_ICON);
                this.movieButton.setPressedIcon(MOVIE_ON_ICON_P);
                Console console = (Console)this.simulation.controller;
                if (console.getPlayState() == 0) {
                    console.pressPause();
                }
                this.lastEncodedSteps = -1L;
                this.insideDisplay.paintToMovie(null);
                this.simulation.scheduleAtEnd(new Steppable(){

                    public void step(SimState state) {
                        Display2D.this.stopMovie();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMovie() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (this.movieMaker == null) {
                return;
            }
            if (!this.movieMaker.stop()) {
                Object[] options = new Object[]{"Drat"};
                JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
            }
            this.movieMaker = null;
            if (this.movieButton != null) {
                this.movieButton.setIcon(MOVIE_OFF_ICON);
                this.movieButton.setPressedIcon(MOVIE_OFF_ICON_P);
            }
        }
    }

    public void step(SimState state) {
        long steps = this.simulation.state.schedule.getSteps();
        if (steps % this.getInterval() == 0L) {
            if (this.insideDisplay.isShowing()) {
                this.insideDisplay.repaint();
            } else if (this.movieMaker != null) {
                this.insideDisplay.paintToMovie(null);
            }
            this.insideDisplay.updateToolTips();
        }
    }

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, (Object[])null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LAYERS_ICON = Display2D.iconFor("Layers.png");
        LAYERS_ICON_P = Display2D.iconFor("LayersPressed.png");
        MOVIE_ON_ICON = Display2D.iconFor("MovieOn.png");
        MOVIE_ON_ICON_P = Display2D.iconFor("MovieOnPressed.png");
        MOVIE_OFF_ICON = Display2D.iconFor("MovieOff.png");
        MOVIE_OFF_ICON_P = Display2D.iconFor("MovieOffPressed.png");
        CAMERA_ICON = Display2D.iconFor("Camera.png");
        CAMERA_ICON_P = Display2D.iconFor("CameraPressed.png");
        OPTIONS_ICON = Display2D.iconFor("Options.png");
        OPTIONS_ICON_P = Display2D.iconFor("OptionsPressed.png");
    }

    class FieldPortrayal2DHolder {
        public Rectangle2D.Double bounds;
        public FieldPortrayal2D portrayal;
        public String name;
        public JCheckBoxMenuItem menuItem;
        public boolean visible;

        public String toString() {
            return this.name;
        }

        public FieldPortrayal2DHolder(FieldPortrayal2D p, String n, Rectangle2D.Double bounds, boolean visible) {
            this.bounds = bounds;
            this.portrayal = p;
            this.name = n;
            this.visible = visible;
            this.menuItem = new JCheckBoxMenuItem(this.name, visible);
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FieldPortrayal2DHolder.this.visible = FieldPortrayal2DHolder.this.menuItem.isSelected();
                    Display2D.this.repaint();
                }
            });
        }
    }

    public class InnerDisplay2D
    extends JComponent {
        BufferedImage buffer = null;
        public double width;
        public double height;
        public double xOffset;
        public double yOffset;
        public RenderingHints unbufferedHints;
        public RenderingHints bufferedHints;
        WeakReference toolTip = new WeakReference<Object>(null);
        protected MouseEvent lastToolTipEvent = null;
        String lastToolTipText = null;
        boolean paintLock = false;
        Rectangle viewRect = new Rectangle(0, 0, 0, 0);
        final Object viewRectLock = new Object();

        public InnerDisplay2D(double width, double height) {
            this.width = width;
            this.height = height;
            this.setupHints(false, false, false);
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)(this.width * Display2D.this.getScale()), (int)(this.height * Display2D.this.getScale()));
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumsize() {
            return this.getPreferredSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintToMovie(Graphics g) {
            Schedule schedule = Display2D.this.simulation.state.schedule;
            synchronized (schedule) {
                long steps = Display2D.this.simulation.state.schedule.getSteps();
                if (steps > Display2D.this.lastEncodedSteps && steps % Display2D.this.getInterval() == 0L && Display2D.this.simulation.state.schedule.time() < Double.POSITIVE_INFINITY) {
                    Display2D.this.movieMaker.add(this.paint(g, true, false));
                    Display2D.this.lastEncodedSteps = steps;
                } else {
                    this.paint(g, false, false);
                }
            }
        }

        public void setupHints(boolean antialias, boolean niceAlphaInterpolation, boolean niceInterpolation) {
            this.unbufferedHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.unbufferedHints.put(RenderingHints.KEY_INTERPOLATION, niceInterpolation ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.unbufferedHints.put(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.unbufferedHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.unbufferedHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, niceAlphaInterpolation ? RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY : RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.bufferedHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.bufferedHints.put(RenderingHints.KEY_INTERPOLATION, niceInterpolation ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.bufferedHints.put(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.bufferedHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.bufferedHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, niceAlphaInterpolation ? RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY : RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        }

        public JToolTip createToolTip() {
            JToolTip tip = super.createToolTip();
            this.toolTip = new WeakReference<JToolTip>(tip);
            return tip;
        }

        public String getToolTipText(MouseEvent event) {
            if (Display2D.this.useTooltips) {
                this.lastToolTipEvent = event;
                Point point = event.getPoint();
                return Display2D.this.createToolTipText(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0), Display2D.this.simulation);
            }
            return null;
        }

        public void updateToolTips() {
            String s;
            if (Display2D.this.useTooltips && this.lastToolTipEvent != null && ((s = this.getToolTipText(this.lastToolTipEvent)) == null || !s.equals(this.lastToolTipText))) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InnerDisplay2D.this.lastToolTipText = s;
                        InnerDisplay2D.this.setToolTipText(InnerDisplay2D.this.lastToolTipText);
                        JToolTip tip = (JToolTip)InnerDisplay2D.this.toolTip.get();
                        if (tip != null && tip.getComponent() == InnerDisplay2D.this) {
                            tip.setTipText(s);
                        }
                    }
                });
            }
        }

        public synchronized void paintComponent(Graphics g) {
            if (this.paintLock) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.setViewRect(Display2D.this.port.getViewRect());
            }
            this.paintComponent(g, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g, boolean buffer) {
            Schedule schedule = Display2D.this.simulation.state.schedule;
            synchronized (schedule) {
                if (Display2D.this.movieMaker != null) {
                    Display2D.this.insideDisplay.paintToMovie(g);
                } else {
                    this.paint(g, buffer, true);
                }
            }
        }

        Rectangle2D computeClip() {
            Rectangle2D clip = this.getViewRect();
            double scale = Display2D.this.getScale();
            int origindx = 0;
            int origindy = 0;
            if (((RectangularShape)clip).getWidth() > this.width * scale) {
                origindx = (int)((((RectangularShape)clip).getWidth() - this.width * scale) / 2.0);
            }
            if (((RectangularShape)clip).getHeight() > this.height * scale) {
                origindy = (int)((((RectangularShape)clip).getHeight() - this.height * scale) / 2.0);
            }
            if (Display2D.this.isClipping()) {
                Dimension s = this.getPreferredSize();
                clip = ((Rectangle2D)clip).createIntersection(new Rectangle2D.Double(origindx, origindy, s.width, s.height));
            }
            return clip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage paint(Graphics graphics, boolean buffered, boolean shared) {
            Schedule schedule = Display2D.this.simulation.state.schedule;
            synchronized (schedule) {
                BufferedImage result = null;
                Rectangle2D clip = this.computeClip();
                if (!buffered) {
                    this.paintUnbuffered((Graphics2D)graphics, clip);
                } else {
                    result = this.paintBuffered((Graphics2D)graphics, clip);
                }
                if (!shared) {
                    this.buffer = null;
                }
                if (result != null) {
                    result.flush();
                }
                return result;
            }
        }

        BufferedImage paintBuffered(Graphics2D graphics, Rectangle2D clip) {
            double ww = clip.getWidth();
            double hh = clip.getHeight();
            if (this.buffer == null || (double)this.buffer.getWidth(null) != ww || (double)this.buffer.getHeight(null) != hh) {
                this.buffer = this.getGraphicsConfiguration().createCompatibleImage((int)ww, (int)hh);
            }
            Graphics2D g = (Graphics2D)this.buffer.getGraphics();
            g.setColor(Display2D.this.port.getBackground());
            g.fillRect(0, 0, this.buffer.getWidth(null), this.buffer.getHeight(null));
            g.translate(-((int)clip.getX()), -((int)clip.getY()));
            this.paintUnbuffered(g, clip);
            g.dispose();
            if (graphics != null) {
                graphics.setRenderingHints(this.bufferedHints);
                graphics.drawImage((Image)this.buffer, (int)clip.getX(), (int)clip.getY(), null);
            }
            return this.buffer;
        }

        void paintUnbuffered(Graphics2D g, Rectangle2D clip) {
            if (g == null) {
                return;
            }
            g.setRenderingHints(this.unbufferedHints);
            if (Display2D.this.isClipping()) {
                g.setClip(clip);
            }
            if (clip.getWidth() != 0.0 && clip.getHeight() != 0.0) {
                if (Display2D.this.backdrop != null) {
                    g.setPaint(Display2D.this.backdrop);
                    g.fillRect((int)clip.getX(), (int)clip.getY(), (int)clip.getWidth(), (int)clip.getHeight());
                }
                Iterator iter = Display2D.this.portrayals.iterator();
                while (iter.hasNext()) {
                    FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)iter.next();
                    if (!p.visible) continue;
                    int buf = p.portrayal.getBuffering();
                    p.portrayal.setBuffering(Display2D.this.optionPane.buffering);
                    g.setClip(g.getClip());
                    p.portrayal.draw(p.portrayal.getField(), g, Display2D.this.getDrawInfo2D(p, clip));
                    p.portrayal.setBuffering(buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Rectangle getViewRect() {
            Object object = this.viewRectLock;
            synchronized (object) {
                return new Rectangle(this.viewRect);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setViewRect(Rectangle rect) {
            Object object = this.viewRectLock;
            synchronized (object) {
                this.viewRect = new Rectangle(rect);
            }
        }
    }

    public class OptionPane
    extends JFrame {
        public int buffering;
        public JRadioButton useNoBuffer;
        public JRadioButton useBuffer;
        public JRadioButton useDefault;
        public ButtonGroup usageGroup;
        public JCheckBox antialias;
        public JCheckBox alphaInterpolation;
        public JCheckBox interpolation;
        public JCheckBox tooltips;
        public NumberTextField xOffsetField;
        public NumberTextField yOffsetField;

        public OptionPane(String title) {
            super(title);
            this.useNoBuffer = new JRadioButton("By Drawing Separate Rectangles");
            this.useBuffer = new JRadioButton("Using a Stretched Image");
            this.useDefault = new JRadioButton("Let the Program Decide How");
            this.usageGroup = new ButtonGroup();
            this.antialias = new JCheckBox("Antialias Graphics");
            this.alphaInterpolation = new JCheckBox("Better Transparency");
            this.interpolation = new JCheckBox("Bilinear Interpolation of Images");
            this.tooltips = new JCheckBox("Tool Tips");
            this.xOffsetField = new NumberTextField(0.0, 1.0, 50.0){

                public double newValue(double val) {
                    double scale = Display2D.this.getScale();
                    ((OptionPane)OptionPane.this).Display2D.this.insideDisplay.xOffset = val / scale;
                    Display2D.this.repaint();
                    return ((OptionPane)OptionPane.this).Display2D.this.insideDisplay.xOffset * scale;
                }
            };
            this.yOffsetField = new NumberTextField(0.0, 1.0, 50.0){

                public double newValue(double val) {
                    double scale = Display2D.this.getScale();
                    ((OptionPane)OptionPane.this).Display2D.this.insideDisplay.yOffset = val / scale;
                    Display2D.this.repaint();
                    return ((OptionPane)OptionPane.this).Display2D.this.insideDisplay.yOffset * scale;
                }
            };
            this.useDefault.setSelected(true);
            this.useNoBuffer.setToolTipText("<html>When not using transparency on Windows/XWindows,<br>this method is often (but not always) faster</html>");
            this.usageGroup.add(this.useNoBuffer);
            this.usageGroup.add(this.useBuffer);
            this.useBuffer.setToolTipText("<html>When using transparency, <i>or</i> when on a Mac,<br>this method is usually faster, but may require more<br>memory (especially on Windows/XWindows) --<br>increasing heap size can help performance.</html>");
            this.usageGroup.add(this.useDefault);
            JPanel p2 = new JPanel();
            Box b = new Box(1);
            b.add(this.useNoBuffer);
            b.add(this.useBuffer);
            b.add(this.useDefault);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder("Draw Grids of Rectangles..."));
            p.add((Component)b, "Center");
            p2.setLayout(new BorderLayout());
            p2.add((Component)p, "North");
            LabelledList l = new LabelledList("Offset in Pixels");
            l.addLabelled("X Offset", this.xOffsetField);
            l.addLabelled("Y Offset", this.yOffsetField);
            p2.add((Component)l, "Center");
            this.getContentPane().add((Component)p2, "North");
            b = new Box(1);
            b.add(this.antialias);
            b.add(this.interpolation);
            b.add(this.alphaInterpolation);
            b.add(this.tooltips);
            p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder("Graphics Features"));
            p.add((Component)b, "Center");
            this.getContentPane().add((Component)p, "Center");
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((OptionPane)OptionPane.this).Display2D.this.useTooltips = OptionPane.this.tooltips.isSelected();
                    OptionPane.this.buffering = OptionPane.this.useDefault.isSelected() ? 0 : (OptionPane.this.useBuffer.isSelected() ? 1 : 2);
                    ((OptionPane)OptionPane.this).Display2D.this.insideDisplay.setupHints(OptionPane.this.antialias.isSelected(), OptionPane.this.alphaInterpolation.isSelected(), OptionPane.this.interpolation.isSelected());
                    Display2D.this.repaint();
                }
            };
            this.useNoBuffer.addActionListener(listener);
            this.useBuffer.addActionListener(listener);
            this.useDefault.addActionListener(listener);
            this.antialias.addActionListener(listener);
            this.alphaInterpolation.addActionListener(listener);
            this.interpolation.addActionListener(listener);
            this.tooltips.addActionListener(listener);
            this.pack();
        }
    }
}

