/*
 * Decompiled with CFR 0.152.
 */
package sim.display3d;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import sim.display.Console;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.SimApplet;
import sim.display3d.CapturingCanvas3D;
import sim.display3d.SelectionBehavior;
import sim.display3d.ToolTipBehavior;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.simple.Axes;
import sim.util.Bag;
import sim.util.Utilities;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.NumberTextField;
import sim.util.media.PngEncoder;

public class Display3D
extends JPanel
implements Steppable {
    ArrayList portrayals = new ArrayList();
    Stoppable stopper;
    GUIState simulation;
    public JComponent header;
    public JButton movieButton;
    public JButton snapshotButton;
    public JButton optionButton;
    public NumberTextField scaleField;
    public NumberTextField skipField;
    long interval = 1L;
    Object intervalLock = new Object();
    public CapturingCanvas3D canvas = null;
    public SimpleUniverse universe = null;
    public BranchGroup root = null;
    Switch portrayalSwitch = null;
    BitSet portrayalSwitchMask = null;
    Switch auxillarySwitch = null;
    BitSet auxillarySwitchMask = new BitSet(2);
    static final int NUM_AUXILLARY_ELEMENTS = 2;
    static final int AXES_AUX_INDEX = 0;
    static final int BACKGROUND_AUX_INDEX = 1;
    public Switch lightSwitch = null;
    BitSet lightSwitchMask = new BitSet(2);
    static final int NUM_LIGHT_ELEMENTS = 2;
    static final int SPOTLIGHT_INDEX = 0;
    static final int AMBIENT_LIGHT_INDEX = 1;
    public MovieMaker movieMaker = null;
    public JPopupMenu popup;
    public JToggleButton togglebutton;
    int subgraphCount = 0;
    boolean dirty = false;
    Appearance backdropAppearance = null;
    Image backdropImage = null;
    Color backdropColor = null;
    private static final float[] bogusPosition;
    PointArray bogusMover;
    public TransformGroup globalModelTransformGroup;
    ToolTipBehavior toolTipBehavior;
    boolean usingToolTips;
    static final double DEFAULT_FIELD_OF_VIEW = 0.7853981633974483;
    double scale;
    Object scaleLock = new Object();
    RotationInterpolator autoSpin = null;
    RotationInterpolator autoSpinBackground = null;
    public TransformGroup autoSpinTransformGroup = new TransformGroup();
    TransformGroup autoSpinBackgroundTransformGroup = new TransformGroup();
    OrbitBehavior mOrbitBehavior = null;
    public SelectionBehavior mSelectBehavior = null;
    JCheckBox orbitRotateXCheckBox = new JCheckBox("Rotate Left/Right");
    JCheckBox orbitRotateYCheckBox = new JCheckBox("Up/Down");
    JCheckBox orbitTranslateXCheckBox = new JCheckBox("Translate Left/Right");
    JCheckBox orbitTranslateYCheckBox = new JCheckBox("Up/Down");
    JCheckBox orbitZoomCheckBox = new JCheckBox("Move Towards/Away");
    JCheckBox selectBehCheckBox = new JCheckBox("Select");
    JRadioButton polyPoint = new JRadioButton("Vertices", false);
    JRadioButton polyLine = new JRadioButton("Edges", false);
    JRadioButton polyFill = new JRadioButton("Fill", true);
    JRadioButton polyCullNone = new JRadioButton("Both Sides", true);
    JRadioButton polyCullFront = new JRadioButton("Back Side Only", false);
    JRadioButton polyCullBack = new JRadioButton("Front Side Only", false);
    JCheckBox showAxesCheckBox = new JCheckBox("Axes");
    JCheckBox showBackgroundCheckBox = new JCheckBox("Backdrop");
    JCheckBox tooltips = new JCheckBox("ToolTips");
    JCheckBox showSpotlightCheckBox = new JCheckBox("Spotlight");
    JCheckBox showAmbientLightCheckBox = new JCheckBox("Ambient Light");
    JFrame optionsFrame;
    NumberTextField rotAxis_X = new NumberTextField(null, 0.0, false){

        public double newValue(double newValue) {
            Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(newValue, Display3D.this.rotAxis_Y.getValue(), Display3D.this.rotAxis_Z.getValue()));
            Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(newValue, Display3D.this.rotAxis_Y.getValue(), Display3D.this.rotAxis_Z.getValue()));
            if (Display3D.this.spinDuration.currentValue == 0.0 || newValue == 0.0 && Display3D.this.rotAxis_Y.currentValue == 0.0 && Display3D.this.rotAxis_Z.currentValue == 0.0) {
                Display3D.this.setSpinningEnabled(false);
            } else {
                Display3D.this.setSpinningEnabled(true);
            }
            return newValue;
        }
    };
    NumberTextField rotAxis_Y = new NumberTextField(null, 0.0, false){

        public double newValue(double newValue) {
            Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), newValue, Display3D.this.rotAxis_Z.getValue()));
            Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), newValue, Display3D.this.rotAxis_Z.getValue()));
            if (Display3D.this.spinDuration.currentValue == 0.0 || Display3D.this.rotAxis_X.currentValue == 0.0 && newValue == 0.0 && Display3D.this.rotAxis_Z.currentValue == 0.0) {
                Display3D.this.setSpinningEnabled(false);
            } else {
                Display3D.this.setSpinningEnabled(true);
            }
            return newValue;
        }
    };
    NumberTextField rotAxis_Z = new NumberTextField(null, 0.0, false){

        public double newValue(double newValue) {
            Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), Display3D.this.rotAxis_Y.getValue(), newValue));
            Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), Display3D.this.rotAxis_Y.getValue(), newValue));
            if (Display3D.this.spinDuration.currentValue == 0.0 || Display3D.this.rotAxis_X.currentValue == 0.0 && Display3D.this.rotAxis_Y.currentValue == 0.0 && newValue == 0.0) {
                Display3D.this.setSpinningEnabled(false);
            } else {
                Display3D.this.setSpinningEnabled(true);
            }
            return newValue;
        }
    };
    NumberTextField spinDuration = new NumberTextField(null, 0.0, 1.0, 0.02){

        public double newValue(double newValue) {
            long mSecsPerRot = newValue == 0.0 ? 1L : (long)(1000.0 / newValue);
            Display3D.this.autoSpin.getAlpha().setIncreasingAlphaDuration(mSecsPerRot);
            Display3D.this.autoSpinBackground.getAlpha().setIncreasingAlphaDuration(mSecsPerRot);
            if (newValue == 0.0 || Display3D.this.rotAxis_X.currentValue == 0.0 && Display3D.this.rotAxis_Y.currentValue == 0.0 && Display3D.this.rotAxis_Z.currentValue == 0.0) {
                Display3D.this.setSpinningEnabled(false);
            } else {
                Display3D.this.setSpinningEnabled(true);
            }
            return newValue;
        }
    };
    int rasterizationMode = 2;
    int cullingMode = 0;
    ArrayList selectedWrappers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long i) {
        Object object = this.intervalLock;
        synchronized (object) {
            this.interval = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInterval() {
        Object object = this.intervalLock;
        synchronized (object) {
            return this.interval;
        }
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame(){
            boolean previouslyShown = false;

            public void dispose() {
                Display3D.this.quit();
                super.dispose();
            }

            public void addWindowListener(WindowListener l) {
                if (new String("class javax.media.j3d.EventCatcher").compareTo(l.getClass().toString()) == 0) {
                    l = new localWindowListener();
                }
                super.addWindowListener(l);
            }

            public void setVisible(boolean val) {
                super.setVisible(val);
                if (Display3D.this.canvas != null && val && this.previouslyShown && Display2D.isMacOSX) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Display3D.this.remove((Component)((Object)(this).Display3D.this.canvas));
                            Display3D.this.add((Component)((Object)(this).Display3D.this.canvas), "Center");
                        }
                    });
                }
                if (val) {
                    this.previouslyShown = true;
                }
            }
        };
        frame.setResizable(true);
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint(Display3D.this.header);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this, "Center");
        frame.getContentPane().setBackground(Color.yellow);
        frame.setTitle(GUIState.getName(this.simulation.getClass()) + " Display");
        frame.pack();
        return frame;
    }

    Frame getFrame() {
        Container c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (this.stopper != null) {
                this.stopper.stop();
            }
            if (this.getInterval() < 1L) {
                this.setInterval(1L);
            }
            this.stopper = this.simulation.scheduleImmediateRepeat(true, this);
        }
        for (int x = 0; x < this.selectedWrappers.size(); ++x) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
    }

    public void attach(Portrayal3D portrayal, String name) {
        this.attach(portrayal, name, true);
    }

    public void attach(Portrayal3D portrayal, String name, boolean visible) {
        this.destroySceneGraph();
        Portrayal3DHolder p = new Portrayal3DHolder(portrayal, name, visible);
        this.portrayals.add(p);
        this.popup.add(p.menuItem);
        this.dirty = true;
        this.createSceneGraph();
    }

    public void attach(final Inspector inspector, final String name) {
        JMenuItem consoleMenu = new JMenuItem("Show " + name);
        this.popup.add(consoleMenu);
        consoleMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Bag inspectors = new Bag();
                inspectors.add(inspector);
                Bag names = new Bag();
                names.add(name);
                Display3D.this.simulation.controller.setInspectors(inspectors, names);
            }
        });
    }

    public void createConsoleMenu() {
        if (this.simulation != null && this.simulation.controller != null && this.simulation.controller instanceof Console) {
            final Console c = (Console)this.simulation.controller;
            JMenuItem consoleMenu = new JMenuItem("Show Console");
            this.popup.add(consoleMenu);
            consoleMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    c.setVisible(true);
                }
            });
        }
        this.popup.addSeparator();
    }

    public ArrayList detatchAll() {
        ArrayList old = this.portrayals;
        this.popup.removeAll();
        this.createConsoleMenu();
        this.portrayals = new ArrayList();
        this.portrayalSwitchMask = null;
        this.subgraphCount = 0;
        this.dirty = true;
        return old;
    }

    public Display3D(double width, double height, GUIState simulation, long interval) {
        this.setInterval(interval);
        this.simulation = simulation;
        this.reset();
        final Color headerBackground = this.getBackground();
        this.header = new Box(0){

            public synchronized void paintComponent(Graphics g) {
                g.setColor(headerBackground);
                g.fillRect(0, 0, Display3D.this.header.getWidth(), Display3D.this.header.getHeight());
            }
        };
        this.setBackground(Color.black);
        this.togglebutton = new JToggleButton(Display2D.LAYERS_ICON);
        this.togglebutton.setPressedIcon(Display2D.LAYERS_ICON_P);
        this.togglebutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.togglebutton.setBorderPainted(false);
        this.togglebutton.setContentAreaFilled(false);
        this.togglebutton.setToolTipText("Show and hide different layers");
        this.header.add(this.togglebutton);
        this.popup = new JPopupMenu();
        this.popup.setLightWeightPopupEnabled(false);
        this.togglebutton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Display3D.this.popup.show(e.getComponent(), Display3D.this.togglebutton.getLocation().x, Display3D.this.togglebutton.getSize().height);
            }

            public void mouseReleased(MouseEvent e) {
                Display3D.this.togglebutton.setSelected(false);
            }
        });
        this.movieButton = new JButton(Display2D.MOVIE_OFF_ICON);
        this.movieButton.setPressedIcon(Display2D.MOVIE_OFF_ICON_P);
        this.movieButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.movieButton.setBorderPainted(false);
        this.movieButton.setContentAreaFilled(false);
        this.movieButton.setToolTipText("Create a Quicktime movie");
        this.movieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Display3D.this.movieMaker == null) {
                    Display3D.this.startMovie();
                } else {
                    Display3D.this.stopMovie();
                }
            }
        });
        this.header.add(this.movieButton);
        this.snapshotButton = new JButton(Display2D.CAMERA_ICON);
        this.snapshotButton.setPressedIcon(Display2D.CAMERA_ICON_P);
        this.snapshotButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.snapshotButton.setBorderPainted(false);
        this.snapshotButton.setContentAreaFilled(false);
        this.snapshotButton.setToolTipText("Create a snapshot (as a PNG file)");
        this.snapshotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Display3D.this.takeSnapshot();
                    }
                });
            }
        });
        this.header.add(this.snapshotButton);
        this.optionButton = new JButton(Display2D.OPTIONS_ICON);
        this.optionButton.setPressedIcon(Display2D.OPTIONS_ICON_P);
        this.optionButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.optionButton.setBorderPainted(false);
        this.optionButton.setContentAreaFilled(false);
        this.optionButton.setToolTipText("Options");
        this.optionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.optionsFrame.setVisible(true);
            }
        });
        this.header.add(this.optionButton);
        this.scaleField = new NumberTextField("  Scale: ", 1.0, true){

            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                Display3D.this.setScale(newValue);
                return newValue;
            }
        };
        this.scaleField.setToolTipText("Magnifies the scene.  Not the same as zooming (see the options panel)");
        this.header.add(this.scaleField);
        this.skipField = new NumberTextField("  Skip: ", 1.0, false){

            public double newValue(double newValue) {
                int val = (int)newValue;
                if (val < 1) {
                    val = 1;
                }
                Display3D.this.setInterval(val);
                Display3D.this.reset();
                return val;
            }
        };
        this.header.add(this.skipField);
        this.setPreferredSize(new Dimension((int)width, (int)height));
        this.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.createOptionsPanel();
        this.auxillarySwitchMask.clear(0);
        this.auxillarySwitchMask.clear(1);
        this.showBackgroundCheckBox.setSelected(true);
        this.showBackgroundCheckBox.setEnabled(false);
        this.createSceneGraph();
        this.createConsoleMenu();
    }

    public void clearBackdrop() {
        this.backdropAppearance = null;
        this.backdropImage = null;
        this.backdropColor = null;
        this.showBackgroundCheckBox.setEnabled(false);
        this.setShowsBackdrop(false);
    }

    public void setBackdrop(Appearance appearance) {
        this.clearBackdrop();
        this.backdropAppearance = appearance;
        this.showBackgroundCheckBox.setEnabled(appearance != null);
        this.setShowsBackdrop(true);
    }

    public void setBackdrop(Color color) {
        this.clearBackdrop();
        this.backdropColor = color;
        this.showBackgroundCheckBox.setEnabled(color != null);
        this.setShowsBackdrop(true);
    }

    public void setBackdrop(Image image, boolean spherical) {
        this.clearBackdrop();
        if (spherical && image != null) {
            Appearance appearance = new Appearance();
            appearance.setTexture(new TextureLoader(image, null).getTexture());
            this.setBackdrop(appearance);
        } else {
            this.backdropImage = image;
        }
        this.showBackgroundCheckBox.setEnabled(image != null);
        this.setShowsBackdrop(true);
    }

    void rebuildAuxillarySwitch() {
        this.auxillarySwitch = new Switch(-3);
        this.auxillarySwitch.setCapability(18);
        this.auxillarySwitch.setCapability(12);
        this.auxillarySwitch.setCapability(14);
        this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
        Axes x = new Axes(0.01f, true);
        this.auxillarySwitch.insertChild((Node)x.getModel(null, null), 0);
        if (this.backdropAppearance != null || this.backdropColor != null || this.backdropImage != null) {
            Background background = new Background();
            background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
            if (this.backdropAppearance != null) {
                BranchGroup backgroundBG = new BranchGroup();
                Sphere sphere = new Sphere(1.0f, 7, 45, this.backdropAppearance);
                Transform3D strans = new Transform3D();
                strans.rotX(-1.5707963267948966);
                TransformGroup tg = new TransformGroup(strans);
                tg.addChild((Node)sphere);
                this.autoSpinBackgroundTransformGroup.addChild((Node)tg);
                backgroundBG.addChild((Node)this.autoSpinBackgroundTransformGroup);
                background.setGeometry(backgroundBG);
            } else if (this.backdropColor != null) {
                background.setColor(new Color3f(this.backdropColor));
            } else {
                BufferedImage img = this.getGraphicsConfiguration().createCompatibleImage(this.backdropImage.getWidth(null), this.backdropImage.getHeight(null));
                Graphics g = img.getGraphics();
                g.drawImage(this.backdropImage, 0, 0, null);
                background.setImage(new ImageComponent2D(1, img));
                background.setImageScaleMode(2);
                img.flush();
            }
            this.auxillarySwitch.addChild((Node)background);
        } else {
            this.auxillarySwitch.addChild((Node)new Group());
        }
        this.bogusMover = new PointArray(1, 1);
        this.bogusMover.setCapability(1);
        this.moveBogusMover();
        this.auxillarySwitch.addChild((Node)new Shape3D((Geometry)this.bogusMover));
    }

    void moveBogusMover() {
        this.bogusMover.setCoordinate(0, bogusPosition);
    }

    void toggleAxes() {
        this.auxillarySwitchMask.set(0, this.showAxesCheckBox.isSelected());
        this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
    }

    public void setShowsAxes(boolean value) {
        this.showAxesCheckBox.setSelected(value);
        this.toggleAxes();
    }

    void toggleBackdrop() {
        this.auxillarySwitchMask.set(1, this.showBackgroundCheckBox.isSelected());
        this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
    }

    public void setShowsBackdrop(boolean value) {
        this.showBackgroundCheckBox.setSelected(value);
        this.toggleBackdrop();
    }

    void toggleSpotlight() {
        this.lightSwitchMask.set(0, this.showSpotlightCheckBox.isSelected());
        this.lightSwitch.setChildMask(this.lightSwitchMask);
    }

    public void setShowsSpotlight(boolean value) {
        this.showSpotlightCheckBox.setSelected(value);
        this.toggleSpotlight();
    }

    void toggleAmbientLight() {
        this.lightSwitchMask.set(1, this.showAmbientLightCheckBox.isSelected());
        this.lightSwitch.setChildMask(this.lightSwitchMask);
    }

    public void setShowsAmbientLight(boolean value) {
        this.showAmbientLightCheckBox.setSelected(value);
        this.toggleAmbientLight();
    }

    void rebuildGlobalModelTransformGroup() {
        TransformGroup newGroup = new TransformGroup();
        newGroup.setCapability(17);
        newGroup.setCapability(18);
        if (this.globalModelTransformGroup != null) {
            Transform3D trans = new Transform3D();
            this.globalModelTransformGroup.getTransform(trans);
            newGroup.setTransform(trans);
        }
        this.globalModelTransformGroup = newGroup;
    }

    public Transform3D getTransform() {
        Transform3D trans = new Transform3D();
        this.globalModelTransformGroup.getTransform(trans);
        return trans;
    }

    public void setTransform(Transform3D transform) {
        if (transform != null) {
            this.globalModelTransformGroup.setTransform(new Transform3D(transform));
        } else {
            this.globalModelTransformGroup.setTransform(new Transform3D());
        }
    }

    public void transform(Transform3D transform) {
        Transform3D current = this.getTransform();
        current.mul(transform, current);
        this.setTransform(current);
    }

    public void resetTransform() {
        this.globalModelTransformGroup.setTransform(new Transform3D());
    }

    public void rotateX(double degrees) {
        Transform3D other = new Transform3D();
        other.rotX(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateY(double degrees) {
        Transform3D other = new Transform3D();
        other.rotY(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateZ(double degrees) {
        Transform3D other = new Transform3D();
        other.rotZ(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void translate(double dx, double dy, double dz) {
        Transform3D other = new Transform3D();
        other.setTranslation(new Vector3d(dx, dy, dz));
        this.transform(other);
    }

    public void scale(double value) {
        Transform3D other = new Transform3D();
        other.setScale(value);
        this.transform(other);
    }

    public void scale(double sx, double sy, double sz) {
        Transform3D other = new Transform3D();
        other.setScale(new Vector3d(sx, sy, sz));
        this.transform(other);
    }

    public void destroySceneGraph() {
        this.mSelectBehavior.detach();
        this.root.detach();
        this.universe.getLocale().removeBranchGraph(this.root);
        this.canvas.stopRenderer();
    }

    public void createSceneGraph() {
        this.dirty = false;
        if (this.universe == null) {
            this.canvas = new CapturingCanvas3D(SimpleUniverse.getPreferredConfiguration());
            this.add((Component)((Object)this.canvas), "Center");
            this.universe = new SimpleUniverse((Canvas3D)this.canvas);
            this.universe.getViewingPlatform().setNominalViewingTransform();
            this.lightSwitch = new Switch(-3);
            this.lightSwitch.setCapability(18);
            this.lightSwitch.setCapability(12);
            this.lightSwitch.setCapability(14);
            this.lightSwitchMask.set(0);
            this.lightSwitchMask.clear(1);
            this.lightSwitch.setChildMask(this.lightSwitchMask);
            PointLight pl = new PointLight(new Color3f(1.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
            pl.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
            this.lightSwitch.addChild((Node)pl);
            AmbientLight al = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
            al.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
            this.lightSwitch.addChild((Node)al);
            BranchGroup bg = new BranchGroup();
            bg.addChild((Node)this.lightSwitch);
            this.universe.getViewingPlatform().getViewPlatformTransform().addChild((Node)bg);
        } else {
            this.destroySceneGraph();
        }
        BranchGroup oldRoot = this.root;
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.root.setCapability(3);
        this.root.setCapability(17);
        this.autoSpinTransformGroup = new TransformGroup();
        this.autoSpinTransformGroup.setCapability(18);
        this.portrayalSwitch = new Switch(-3);
        this.portrayalSwitch.setCapability(18);
        this.portrayalSwitch.setCapability(12);
        this.portrayalSwitch.setCapability(14);
        this.autoSpinBackgroundTransformGroup = new TransformGroup();
        this.autoSpinBackgroundTransformGroup.setCapability(18);
        this.portrayalSwitchMask = new BitSet(this.subgraphCount);
        int count = 0;
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            Portrayal3DHolder p3h = (Portrayal3DHolder)iter.next();
            Portrayal3D p = p3h.portrayal;
            Object obj = p instanceof FieldPortrayal3D ? ((FieldPortrayal3D)p).getField() : null;
            this.portrayalSwitch.addChild((Node)p.getModel(obj, null));
            if (p3h.visible) {
                this.portrayalSwitchMask.set(count);
            } else {
                this.portrayalSwitchMask.clear(count);
            }
            ++count;
        }
        this.portrayalSwitch.setChildMask(this.portrayalSwitchMask);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY);
        this.mSelectBehavior = new SelectionBehavior(this.canvas, this.root, (Bounds)bounds, this.simulation);
        this.mSelectBehavior.setEnable(this.selectBehCheckBox.isSelected());
        this.toolTipBehavior = new ToolTipBehavior(this.canvas, this.root, (Bounds)bounds, this.simulation);
        this.toolTipBehavior.setEnable(true);
        this.toolTipBehavior.setCanShowToolTips(this.usingToolTips);
        if (this.autoSpin == null) {
            this.autoSpin = new RotationInterpolator(new Alpha(), this.autoSpinTransformGroup);
            this.autoSpin.getAlpha().setLoopCount(0);
            this.autoSpin.setSchedulingBounds((Bounds)bounds);
            this.autoSpinBackground = new RotationInterpolator(new Alpha(), this.autoSpinBackgroundTransformGroup);
            this.autoSpinBackground.getAlpha().setLoopCount(0);
            this.autoSpinBackground.setSchedulingBounds((Bounds)bounds);
            this.setSpinningEnabled(false);
        } else {
            oldRoot.removeChild((Node)this.autoSpin);
            oldRoot.removeChild((Node)this.autoSpinBackground);
        }
        this.rebuildGlobalModelTransformGroup();
        this.rebuildAuxillarySwitch();
        this.mOrbitBehavior = new OrbitBehavior((Canvas3D)this.canvas, 112);
        this.mOrbitBehavior.setRotateEnable(true);
        this.mOrbitBehavior.setRotXFactor(this.orbitRotateXCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setRotYFactor(this.orbitRotateYCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setTranslateEnable(true);
        this.mOrbitBehavior.setTransXFactor(this.orbitTranslateXCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setTransYFactor(this.orbitTranslateYCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setZoomEnable(this.orbitZoomCheckBox.isSelected());
        this.mOrbitBehavior.setSchedulingBounds((Bounds)bounds);
        this.universe.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this.mOrbitBehavior);
        this.globalModelTransformGroup.addChild((Node)this.portrayalSwitch);
        this.autoSpinTransformGroup.addChild((Node)this.globalModelTransformGroup);
        this.autoSpinTransformGroup.addChild((Node)this.auxillarySwitch);
        this.root.addChild((Node)this.autoSpin);
        this.root.addChild((Node)this.autoSpinBackground);
        this.autoSpin.setTarget(this.autoSpinTransformGroup);
        this.autoSpinBackground.setTarget(this.autoSpinBackgroundTransformGroup);
        this.root.addChild((Node)this.autoSpinTransformGroup);
        this.universe.addBranchGraph(this.root);
        this.setCullingMode(this.cullingMode);
        this.setRasterizationMode(this.rasterizationMode);
        this.sceneGraphCreated();
        this.canvas.startRenderer();
    }

    protected void sceneGraphCreated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double val) {
        Object object = this.scaleLock;
        synchronized (object) {
            this.scale = val < 1.0 ? 0.7853981633974483 + 2.356194490192345 * (1.0 - val) * (1.0 - val) : 0.7853981633974483 / val;
            this.canvas.getView().setFieldOfView(this.scale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        Object object = this.scaleLock;
        synchronized (object) {
            return this.scale;
        }
    }

    public synchronized void paintComponent(Graphics g) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Display3D.this.updateSceneGraph(false);
            }
        });
    }

    public void step(SimState state) {
        long steps = state.schedule.getSteps();
        if (steps % this.getInterval() == 0L && state.schedule.time() < Double.POSITIVE_INFINITY && (this.canvas.isShowing() || this.movieMaker != null)) {
            this.updateSceneGraph(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSceneGraph(boolean waitForRenderer) {
        if (this.canvas == null) {
            return;
        }
        if (this.dirty && waitForRenderer) {
            this.createSceneGraph();
            return;
        }
        boolean changes = false;
        Iterator iter = this.portrayals.iterator();
        this.moveBogusMover();
        while (iter.hasNext()) {
            Portrayal3DHolder ph = (Portrayal3DHolder)iter.next();
            if (!this.portrayalSwitchMask.get(ph.subgraphIndex)) continue;
            ph.portrayal.getModel(ph.portrayal instanceof FieldPortrayal3D ? ((FieldPortrayal3D)ph.portrayal).getField() : null, (TransformGroup)this.portrayalSwitch.getChild(ph.subgraphIndex));
            changes = true;
        }
        if (!(waitForRenderer &= changes)) {
            return;
        }
        Object object = this.canvas;
        synchronized (object) {
            try {
                if (!Thread.currentThread().isInterrupted()) {
                    ((Object)((Object)this.canvas)).wait(0L);
                }
            }
            catch (InterruptedException ex) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException ex2) {
                    // empty catch block
                }
            }
        }
        object = this.simulation.state.schedule;
        synchronized (object) {
            if (this.movieMaker != null) {
                this.movieMaker.add(this.canvas.getFrameAsImage());
            }
        }
    }

    Rectangle2D getImageSize() {
        Dimension s = this.canvas.getSize();
        Rectangle2D clip = new Rectangle2D.Double(0.0, 0.0, s.width, s.height);
        if (this.canvas == null) {
            return null;
        }
        Rectangle bounds = this.canvas.getGraphics().getClipBounds();
        if (bounds != null) {
            clip = ((Rectangle2D)clip).createIntersection(bounds);
        }
        return clip;
    }

    public void takeSnapshot() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot save snapshots from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        this.canvas.setWritingParams(this.getImageSize(), false);
        FileDialog fd = new FileDialog(this.getFrame(), "Save Snapshot as 24-bit PNG...", 1);
        fd.setFile("Untitled.png");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            try {
                File snapShotFile = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".png"));
                BufferedImage image = this.canvas.getFrameAsImage();
                PngEncoder tmpEncoder = new PngEncoder(image, false, 0, 9);
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(snapShotFile));
                ((OutputStream)stream).write(tmpEncoder.pngEncode());
                ((OutputStream)stream).close();
                image.flush();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMovie() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        if (this.movieMaker != null) {
            return;
        }
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            this.movieMaker = new MovieMaker(this.getFrame());
            Rectangle2D imgBounds = this.getImageSize();
            this.canvas.setWritingParams(imgBounds, false);
            BufferedImage typicalImage = this.canvas.getFrameAsImage();
            if (!this.movieMaker.start(typicalImage)) {
                this.movieMaker = null;
            } else {
                this.canvas.setWritingParams(imgBounds, true);
                this.movieButton.setIcon(Display2D.MOVIE_ON_ICON);
                this.movieButton.setPressedIcon(Display2D.MOVIE_ON_ICON_P);
                this.simulation.scheduleAtEnd(new Steppable(){

                    public void step(SimState state) {
                        Display3D.this.stopMovie();
                    }
                });
            }
            typicalImage.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMovie() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (this.movieMaker == null) {
                return;
            }
            this.canvas.stopMovie();
            if (!this.movieMaker.stop()) {
                Object[] options = new Object[]{"Drat"};
                JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
            }
            this.movieMaker = null;
            if (this.movieButton != null) {
                this.movieButton.setIcon(Display2D.MOVIE_OFF_ICON);
                this.movieButton.setPressedIcon(Display2D.MOVIE_OFF_ICON_P);
            }
        }
    }

    public void quit() {
        this.stopMovie();
        this.universe.cleanup();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.quit();
    }

    void setSpinningEnabled(boolean value) {
        if (this.autoSpin != null) {
            if (value) {
                this.autoSpin.setEnable(true);
                this.autoSpin.getAlpha().setLoopCount(-1);
                this.autoSpinBackground.setEnable(true);
                this.autoSpinBackground.getAlpha().setLoopCount(-1);
            } else {
                this.autoSpin.setEnable(false);
                this.autoSpin.getAlpha().setLoopCount(0);
                this.autoSpinBackground.setEnable(false);
                this.autoSpinBackground.getAlpha().setLoopCount(0);
            }
        }
    }

    Transform3D getTransformForAxis(double dx, double dy, double dz) {
        Transform3D t = new Transform3D();
        Transform3D t1 = new Transform3D();
        t.rotX(Math.atan2(dz, dy));
        t1.rotZ(-Math.atan2(dx, Math.sqrt(dy * dy + dx * dz)));
        t.mul(t1);
        return t;
    }

    void createOptionsPanel() {
        this.orbitRotateXCheckBox.setToolTipText("Rotates the scene left or right. Drag the left mouse button.");
        this.orbitRotateYCheckBox.setToolTipText("Rotates the scene up or down. Drag the left mouse button.");
        this.orbitTranslateXCheckBox.setToolTipText("Move the scene left or right.  Drag the middle mouse button.");
        this.orbitTranslateYCheckBox.setToolTipText("Move the scene up or down.  Drag the middle mouse button.");
        this.orbitZoomCheckBox.setToolTipText("Moves the eye towards/away from scene.  Not the same as scaling.  Drag the right mouse button.");
        this.selectBehCheckBox.setToolTipText("Selects objects.  Double-click the left mouse button.");
        Box outerBehaviorsPanel = new Box(0);
        outerBehaviorsPanel.setBorder(new TitledBorder("Mouse Actions"));
        Box leftBehaviors = new Box(1);
        leftBehaviors.add(this.orbitRotateXCheckBox);
        this.orbitRotateXCheckBox.setSelected(true);
        leftBehaviors.add(this.orbitTranslateXCheckBox);
        this.orbitTranslateXCheckBox.setSelected(true);
        leftBehaviors.add(this.orbitZoomCheckBox);
        this.orbitZoomCheckBox.setSelected(true);
        leftBehaviors.add(this.selectBehCheckBox);
        this.selectBehCheckBox.setSelected(true);
        leftBehaviors.add(Box.createGlue());
        Box rightBehaviors = new Box(1);
        rightBehaviors.add(this.orbitRotateYCheckBox);
        this.orbitRotateYCheckBox.setSelected(true);
        rightBehaviors.add(this.orbitTranslateYCheckBox);
        this.orbitTranslateYCheckBox.setSelected(true);
        rightBehaviors.add(Box.createGlue());
        JButton resetButton = new JButton("Reset");
        resetButton.setToolTipText("Resets display to original rotation, translation, and zoom.");
        rightBehaviors.add(resetButton);
        outerBehaviorsPanel.add(leftBehaviors);
        outerBehaviorsPanel.add(rightBehaviors);
        outerBehaviorsPanel.add(Box.createGlue());
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.canvas.stopRenderer();
                Display3D.this.scaleField.setValue(1.0);
                Display3D.this.setScale(1.0);
                Display3D.this.universe.getViewingPlatform().setNominalViewingTransform();
                Display3D.this.autoSpinTransformGroup.setTransform(new Transform3D());
                Display3D.this.autoSpinBackgroundTransformGroup.setTransform(new Transform3D());
                Display3D.this.canvas.startRenderer();
            }
        });
        this.orbitRotateXCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mOrbitBehavior != null) {
                    Display3D.this.mOrbitBehavior.setRotXFactor(Display3D.this.orbitRotateXCheckBox.isSelected() ? 1.0 : 0.0);
                }
            }
        });
        this.orbitRotateYCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mOrbitBehavior != null) {
                    Display3D.this.mOrbitBehavior.setRotYFactor(Display3D.this.orbitRotateYCheckBox.isSelected() ? 1.0 : 0.0);
                }
            }
        });
        this.orbitTranslateXCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mOrbitBehavior != null) {
                    Display3D.this.mOrbitBehavior.setTransXFactor(Display3D.this.orbitTranslateXCheckBox.isSelected() ? 1.0 : 0.0);
                }
            }
        });
        this.orbitTranslateYCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mOrbitBehavior != null) {
                    Display3D.this.mOrbitBehavior.setTransYFactor(Display3D.this.orbitTranslateYCheckBox.isSelected() ? 1.0 : 0.0);
                }
            }
        });
        this.orbitZoomCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mOrbitBehavior != null) {
                    Display3D.this.mOrbitBehavior.setZoomEnable(Display3D.this.orbitZoomCheckBox.isSelected());
                }
            }
        });
        this.selectBehCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Display3D.this.mSelectBehavior != null) {
                    Display3D.this.mSelectBehavior.setEnable(Display3D.this.selectBehCheckBox.isSelected());
                }
            }
        });
        LabelledList rotatePanel = new LabelledList("Auto-Rotate About <X,Y,Z> Axis");
        rotatePanel.addLabelled("X", this.rotAxis_X);
        rotatePanel.addLabelled("Y", this.rotAxis_Y);
        rotatePanel.addLabelled("Z", this.rotAxis_Z);
        rotatePanel.addLabelled("Rotations/Sec", this.spinDuration);
        Box polyPanel = new Box(0);
        polyPanel.setBorder(new TitledBorder("Polygon Attributes"));
        ButtonGroup polyLineGroup = new ButtonGroup();
        polyLineGroup.add(this.polyPoint);
        polyLineGroup.add(this.polyLine);
        polyLineGroup.add(this.polyFill);
        ButtonGroup polyCullingGroup = new ButtonGroup();
        polyCullingGroup.add(this.polyCullNone);
        polyCullingGroup.add(this.polyCullFront);
        polyCullingGroup.add(this.polyCullBack);
        Box polyLinebox = Box.createVerticalBox();
        polyLinebox.add(Box.createGlue());
        polyLinebox.add(new JLabel("Draw Polygons As..."));
        polyLinebox.add(this.polyPoint);
        this.polyPoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setRasterizationMode(0);
            }
        });
        polyLinebox.add(this.polyLine);
        this.polyLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setRasterizationMode(1);
            }
        });
        polyLinebox.add(this.polyFill);
        this.polyFill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setRasterizationMode(2);
            }
        });
        polyLinebox.add(Box.createGlue());
        polyLinebox.setBorder(new EmptyBorder(0, 0, 0, 20));
        polyPanel.add(polyLinebox);
        Box polyCullbox = Box.createVerticalBox();
        polyCullbox.add(Box.createGlue());
        polyCullbox.add(new JLabel("Draw Faces As..."));
        polyCullbox.add(this.polyCullNone);
        this.polyCullNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setCullingMode(0);
            }
        });
        polyCullbox.add(this.polyCullBack);
        this.polyCullBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setCullingMode(1);
            }
        });
        polyCullbox.add(this.polyCullFront);
        this.polyCullFront.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.setCullingMode(2);
            }
        });
        polyCullbox.add(Box.createGlue());
        polyCullbox.setBorder(new EmptyBorder(0, 0, 0, 20));
        polyPanel.add(polyCullbox);
        polyPanel.add(Box.createGlue());
        Box auxillaryPanel = new Box(1);
        Box box = new Box(0);
        auxillaryPanel.setBorder(new TitledBorder("Auxillary Elements"));
        box.add(this.showAxesCheckBox);
        this.showAxesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.toggleAxes();
            }
        });
        box.add(this.showBackgroundCheckBox);
        this.showBackgroundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.toggleBackdrop();
            }
        });
        box.add(this.tooltips);
        this.tooltips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.usingToolTips = Display3D.this.tooltips.isSelected();
                if (Display3D.this.toolTipBehavior != null) {
                    Display3D.this.toolTipBehavior.setCanShowToolTips(Display3D.this.usingToolTips);
                }
            }
        });
        box.add(Box.createGlue());
        auxillaryPanel.add(box);
        box = new Box(0);
        box.add(this.showSpotlightCheckBox);
        this.showSpotlightCheckBox.setSelected(true);
        this.showSpotlightCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.toggleSpotlight();
            }
        });
        box.add(this.showAmbientLightCheckBox);
        this.showAmbientLightCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display3D.this.toggleAmbientLight();
            }
        });
        box.add(Box.createGlue());
        auxillaryPanel.add(box);
        Box optionsPanel = new Box(1);
        optionsPanel.add(outerBehaviorsPanel);
        optionsPanel.add(rotatePanel);
        optionsPanel.add(auxillaryPanel);
        optionsPanel.add(polyPanel);
        this.optionsFrame = new JFrame("3D Options");
        this.optionsFrame.getContentPane().add(optionsPanel);
        this.optionsFrame.pack();
        this.optionsFrame.setResizable(false);
        this.optionsFrame.setDefaultCloseOperation(1);
    }

    void setRasterizationMode(int mode) {
        this.rasterizationMode = mode;
        this.polyFill.setSelected(mode == 2);
        this.polyLine.setSelected(mode == 1);
        this.polyPoint.setSelected(mode == 0);
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            PolygonAttributes pa = ((Portrayal3DHolder)iter.next()).portrayal.polygonAttributes();
            try {
                if (pa == null) continue;
                pa.setPolygonMode(mode);
            }
            catch (CapabilityNotSetException e) {}
        }
    }

    void setCullingMode(int mode) {
        this.cullingMode = mode;
        this.polyCullNone.setSelected(mode == 0);
        this.polyCullBack.setSelected(mode == 1);
        this.polyCullFront.setSelected(mode == 2);
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            PolygonAttributes pa = ((Portrayal3DHolder)iter.next()).portrayal.polygonAttributes();
            try {
                if (pa == null) continue;
                pa.setCullFace(mode);
            }
            catch (CapabilityNotSetException e) {}
        }
    }

    public void performSelection(LocationWrapper wrapper) {
        Bag b = new Bag();
        b.add(wrapper);
        this.performSelection(b);
    }

    public void performSelection(Bag locationWrappers) {
        LocationWrapper wrapper;
        int x;
        for (x = 0; x < this.selectedWrappers.size(); ++x) {
            wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
        if (locationWrappers == null) {
            return;
        }
        for (x = 0; x < locationWrappers.size(); ++x) {
            wrapper = (LocationWrapper)locationWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, true);
            this.selectedWrappers.add(wrapper);
        }
        this.updateSceneGraph(false);
    }

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, (Object[])null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bogusPosition = new float[]{0.0f, 0.0f, 0.0f};
    }

    class Portrayal3DHolder {
        public Portrayal3D portrayal;
        public String name;
        public JCheckBoxMenuItem menuItem;
        public int subgraphIndex;
        public boolean visible = true;

        public String toString() {
            return this.name;
        }

        public Portrayal3DHolder(Portrayal3D p, String n, boolean visible) {
            this.portrayal = p;
            this.name = n;
            this.visible = visible;
            this.menuItem = new JCheckBoxMenuItem(this.name, visible);
            this.subgraphIndex = Display3D.this.subgraphCount++;
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Portrayal3DHolder.this.menuItem.isSelected()) {
                        Portrayal3DHolder.this.visible = true;
                        ((Portrayal3DHolder)Portrayal3DHolder.this).Display3D.this.portrayalSwitchMask.set(Portrayal3DHolder.this.subgraphIndex);
                    } else {
                        Portrayal3DHolder.this.visible = false;
                        ((Portrayal3DHolder)Portrayal3DHolder.this).Display3D.this.portrayalSwitchMask.clear(Portrayal3DHolder.this.subgraphIndex);
                    }
                    ((Portrayal3DHolder)Portrayal3DHolder.this).Display3D.this.portrayalSwitch.setChildMask(((Portrayal3DHolder)Portrayal3DHolder.this).Display3D.this.portrayalSwitchMask);
                }
            });
        }
    }

    class localWindowListener
    extends WindowAdapter {
        localWindowListener() {
        }
    }
}

