/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;

class Repeat
implements Steppable,
Stoppable {
    double interval;
    Steppable step;
    Schedule.Key key;

    public Repeat(Steppable step, double interval, Schedule.Key key) {
        if (interval < 0.0) {
            throw new IllegalArgumentException("For the Steppable...\n\n" + step + "\n\n...the interval provided (" + interval + ") is less than zero");
        }
        if (interval != interval) {
            throw new IllegalArgumentException("For the Steppable...\n\n" + step + "\n\n...the interval provided (" + interval + ") is NaN");
        }
        this.step = step;
        this.interval = interval;
        this.key = key;
    }

    public synchronized void step(SimState state) {
        if (this.step != null) {
            try {
                this.key.time += this.interval;
                state.schedule.scheduleOnce(this.key, (Steppable)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.step.step(state);
        }
    }

    public synchronized void stop() {
        this.step = null;
    }
}

