/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import ec.util.MersenneTwisterFast;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sim.engine.AsynchronousSteppable;
import sim.engine.MakesSimState;
import sim.engine.Schedule;

public class SimState
implements Serializable {
    public MersenneTwisterFast random;
    public Schedule schedule;
    HashSet asynchronous = new HashSet();
    Object asynchronousLock = new boolean[1];
    public boolean cleaningAsynchronous = false;
    long job = 0L;
    long seed = 0L;

    public SimState(long seed) {
        this(new MersenneTwisterFast(seed));
    }

    public SimState(MersenneTwisterFast random) {
        this(random, new Schedule());
    }

    public SimState(MersenneTwisterFast random, Schedule schedule) {
        this.random = random;
        this.schedule = schedule;
    }

    public void setRandom(MersenneTwisterFast random) {
        this.random = random;
    }

    public void start() {
        this.cleanupAsynchronous();
        this.schedule.reset();
    }

    public void finish() {
        this.kill();
    }

    public void kill() {
        this.cleanupAsynchronous();
        this.schedule.pushToAfterSimulation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToAsynchronousRegistry(AsynchronousSteppable stop) {
        if (stop == null) {
            return false;
        }
        Object object = this.asynchronousLock;
        synchronized (object) {
            if (this.cleaningAsynchronous) {
                return false;
            }
            this.asynchronous.add(stop);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromAsynchronousRegistry(AsynchronousSteppable stop) {
        if (stop == null) {
            return;
        }
        Object object = this.asynchronousLock;
        synchronized (object) {
            if (!this.cleaningAsynchronous) {
                this.asynchronous.remove(stop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchronousSteppable[] asynchronousRegistry() {
        Object object = this.asynchronousLock;
        synchronized (object) {
            AsynchronousSteppable[] b = new AsynchronousSteppable[this.asynchronous.size()];
            int x = 0;
            Iterator i = this.asynchronous.iterator();
            while (i.hasNext()) {
                b[x++] = (AsynchronousSteppable)i.next();
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupAsynchronous() {
        AsynchronousSteppable[] b = null;
        Object object = this.asynchronousLock;
        synchronized (object) {
            b = this.asynchronousRegistry();
            this.cleaningAsynchronous = true;
        }
        int len = b.length;
        for (int x = 0; x < len; ++x) {
            b[x].stop();
        }
        Object object2 = this.asynchronousLock;
        synchronized (object2) {
            this.asynchronous = new HashSet(this.asynchronous.size());
            this.cleaningAsynchronous = false;
        }
    }

    public void preCheckpoint() {
        AsynchronousSteppable[] b = this.asynchronousRegistry();
        int len = b.length;
        for (int x = 0; x < len; ++x) {
            b[x].pause();
        }
    }

    public void postCheckpoint() {
        AsynchronousSteppable[] b = this.asynchronousRegistry();
        int len = b.length;
        for (int x = 0; x < len; ++x) {
            b[x].resume();
        }
    }

    public void awakeFromCheckpoint() {
        AsynchronousSteppable[] b = this.asynchronousRegistry();
        int len = b.length;
        for (int x = 0; x < len; ++x) {
            b[x].resume();
        }
    }

    public void writeToCheckpoint(OutputStream stream) throws IOException {
        this.preCheckpoint();
        GZIPOutputStream g = new GZIPOutputStream(new BufferedOutputStream(stream));
        ObjectOutputStream s = new ObjectOutputStream(g);
        s.writeObject(this);
        s.flush();
        g.finish();
        g.flush();
        this.postCheckpoint();
    }

    public SimState writeToCheckpoint(File file) {
        try {
            FileOutputStream f = new FileOutputStream(file);
            this.writeToCheckpoint(f);
            f.close();
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimState readFromCheckpoint(File file) {
        try {
            FileInputStream f = new FileInputStream(file);
            SimState state = SimState.readFromCheckpoint(f);
            f.close();
            return state;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimState readFromCheckpoint(InputStream stream) throws IOException, ClassNotFoundException, OptionalDataException, ClassCastException {
        ObjectInputStream s = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(stream)));
        SimState state = (SimState)s.readObject();
        state.awakeFromCheckpoint();
        return state;
    }

    static int indexAfterArgumentForKey(String key, String[] args, int startingAt) {
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equalsIgnoreCase(key)) continue;
            return x + 2;
        }
        return args.length;
    }

    static boolean keyExists(String key, String[] args, int startingAt) {
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    static String argumentForKey(String key, String[] args, int startingAt) {
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equalsIgnoreCase(key)) continue;
            return args[x + 1];
        }
        return null;
    }

    public long job() {
        return this.job;
    }

    public static void doLoop(final Class c, String[] args) {
        SimState.doLoop(new MakesSimState(){

            public SimState newInstance(long seed, String[] args) {
                try {
                    return (SimState)c.getConstructor(Long.TYPE).newInstance(new Long(seed));
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occurred while trying to construct the simulation: " + e);
                }
            }

            public Class simulationClass() {
                return c;
            }
        }, args);
    }

    public static void doLoop(MakesSimState generator, String[] args) {
        if (SimState.keyExists("-help", args, 0)) {
            System.err.println("Format:           java " + generator.simulationClass().getName() + " \\\n" + "                       [-help] [-repeat R] [-seed S] [-until U] \\\n" + "                       [-for F] [-time T] [-docheckpoint D] [-checkpoint C] \n\n" + "-help             Shows this message and exits.\n\n" + "-repeat R         Long value > 0: Runs the job R times.  Unless overridden by a\n" + "                  checkpoint recovery (see -checkpoint), the random seed for\n" + "                  each job is the provided -seed plus the job# (starting at 0).\n" + "                  Default: runs once only: job number is 0.\n\n" + "-seed S           Long value not 0: the random number generator seed, unless \n" + "                  overridden by a checkpoint recovery (see -checkpoint).\n" + "                  Default: the system time in milliseconds.\n\n" + "-until U          Double value >= 0: the simulation must stop when the\n" + "                  simulation time U has been reached or exceeded.\n" + "                  Default: don't stop.\n\n" + "-for N            Long value >= 0: the simulation must stop when N\n" + "                  simulation steps have transpired.\n" + "                  Default: don't stop.\n\n" + "-time T           Long value >= 0: print a timestamp every T simulation steps.\n" + "                  If 0, nothing is printed.\n" + "                  Default: auto-chooses number of steps based on how many\n" + "                  appear to fit in one second of wall clock time.  Rounds to\n" + "                  one of 1, 2, 5, 10, 25, 50, 100, 250, 500, 1000, 2500, etc.\n\n" + "-docheckpoint D   Long value > 0: checkpoint every D simulation steps.\n" + "                  Default: never.\n" + "                  Checkpoint files named\n" + "                  <steps>.<job#>." + generator.simulationClass().getName().substring(generator.simulationClass().getName().lastIndexOf(".") + 1) + ".checkpoint\n\n" + "-checkpoint C     String: loads the simulation from file C, recovering the job\n" + "                  number and the seed.  If the checkpointed simulation was begun\n" + "                  on the command line but was passed through the GUI for a while\n" + "                  (even multiply restarted in the GUI) and then recheckpointed,\n" + "                  then the seed and job numbers will be the same as when they\n" + "                  were last on the command line.  If the checkpointed simulation\n" + "                  was begun on the GUI, then the seed will not be recovered and\n" + "                  job will be set to 0. Further jobs and seeds are incremented\n" + "                  from the recovered job and seed.\n" + "                  Default: starts a new simulation rather than loading one, at\n" + "                  job 0 and with the seed given in -seed.\n");
            System.exit(0);
        }
        NumberFormat n = NumberFormat.getInstance();
        n.setMinimumFractionDigits(0);
        System.err.println("MASON Version " + n.format(SimState.version()) + ".  For further options, try adding ' -help' at end.");
        double until = Double.POSITIVE_INFINITY;
        String until_s = SimState.argumentForKey("-until", args, 0);
        if (until_s != null) {
            try {
                until = Double.parseDouble(until_s);
                if (until < 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid 'until' value: " + until_s + ", must be a positive real value");
            }
        }
        long seed = System.currentTimeMillis();
        String seed_s = SimState.argumentForKey("-seed", args, 0);
        if (seed_s != null) {
            try {
                seed = Long.parseLong(seed_s);
                if (seed == 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid 'seed' value: " + seed_s + ", must be a non-zero integer, or nonexistent to seed by clock time");
            }
        }
        long _for = -1L;
        String _for_s = SimState.argumentForKey("-for", args, 0);
        if (_for_s != null) {
            try {
                _for = Long.parseLong(_for_s);
                if (_for < 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid 'for' value: " + _for_s + ", must be an integer >= 0");
            }
        }
        long time = -1L;
        String time_s = SimState.argumentForKey("-time", args, 0);
        if (time_s != null) {
            try {
                time = Long.parseLong(time_s);
                if (time < 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid 'time' value: " + time_s + ", must be a positive integer");
            }
        }
        long cmod = 0L;
        String cmod_s = SimState.argumentForKey("-docheckpoint", args, 0);
        if (cmod_s != null) {
            try {
                cmod = Long.parseLong(cmod_s);
                if (cmod <= 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid checkpoint modulo: " + cmod_s + ", must be a positive integer");
            }
        }
        long repeat = 1L;
        String repeat_s = SimState.argumentForKey("-repeat", args, 0);
        if (repeat_s != null) {
            try {
                repeat = Long.parseLong(repeat_s);
                if (repeat <= 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid repeat value: " + repeat + ", must be a positive integer");
            }
        }
        long job = 0L;
        for (long rep = 0L; rep < repeat; ++rep) {
            SimState state = null;
            String checkpointFile = SimState.argumentForKey("-checkpoint", args, 0);
            if (rep == 0L && checkpointFile != null) {
                System.err.println("Loading from checkpoint " + checkpointFile);
                state = SimState.readFromCheckpoint(new File(checkpointFile));
                if (state == null) {
                    System.exit(1);
                } else if (state.getClass() != generator.simulationClass()) {
                    System.err.println("Checkpoint contains some other simulation: " + state + ", should have been of class " + generator.simulationClass());
                    System.exit(1);
                }
                job = state.job;
                if (state.seed != 0L) {
                    seed = state.seed;
                    System.err.println("Recovered job: " + job + " Seed: " + seed);
                } else {
                    System.err.println("Renamed job: " + job + " (unknown seed)");
                }
            }
            if (state == null) {
                state = generator.newInstance(seed, args);
                state.job = job;
                state.seed = seed;
                System.err.println("Job: " + job + " Seed: " + seed);
                System.err.println("Starting " + state.getClass().getName());
                state.start();
            }
            ++job;
            ++seed;
            NumberFormat rateFormat = NumberFormat.getInstance();
            rateFormat.setMaximumFractionDigits(5);
            rateFormat.setMinimumIntegerDigits(1);
            boolean retval = false;
            long steps = 0L;
            long oldClock = System.currentTimeMillis();
            Schedule schedule = state.schedule;
            long firstSteps = schedule.getSteps();
            while ((_for == -1L || steps < _for) && schedule.time() <= until) {
                if (!schedule.step(state)) {
                    retval = true;
                    break;
                }
                steps = schedule.getSteps();
                if (time < 0L && System.currentTimeMillis() - oldClock > 1000L) {
                    time = SimState.figureTime(steps - firstSteps);
                }
                if (time > 0L && steps % time == 0L) {
                    long clock = System.currentTimeMillis();
                    System.err.println("Steps: " + steps + " Time: " + state.schedule.getTimestamp("At Start", "Done") + " Rate: " + rateFormat.format(1000.0 * (double)(steps - firstSteps) / (double)(clock - oldClock)));
                    firstSteps = steps;
                    oldClock = clock;
                }
                if (cmod <= 0L || steps % cmod != 0L) continue;
                String s = "" + steps + "." + state.job + "." + state.getClass().getName().substring(state.getClass().getName().lastIndexOf(".") + 1) + ".checkpoint";
                System.err.println("Checkpointing to file: " + s);
                state.writeToCheckpoint(new File(s));
            }
            state.finish();
            if (retval) {
                System.err.println("Exhausted");
                continue;
            }
            System.err.println("Quit");
        }
    }

    public static double version() {
        return 14.0;
    }

    static long figureTime(long time) {
        long n = 1L;
        while (n < time) {
            if (n * 10L / 4L >= time) {
                return n * 10L / 4L;
            }
            if (n * 10L / 2L >= time) {
                return n * 10L / 2L;
            }
            n *= 10L;
        }
        return n;
    }
}

