/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;

public class WeakStep
implements Steppable {
    protected WeakReference weakStep;
    protected WeakReference weakStop;

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeObject(this.weakStep.get());
        p.writeBoolean(this.weakStop != null);
        if (this.weakStop != null) {
            p.writeObject(this.weakStop.get());
        }
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.weakStep = new WeakReference<Object>(p.readObject());
        this.weakStop = p.readBoolean() ? new WeakReference<Object>(p.readObject()) : null;
    }

    public WeakStep(Steppable step) {
        this.weakStep = new WeakReference<Steppable>(step);
    }

    public void setStoppable(Stoppable stop) {
        this.weakStop = new WeakReference<Stoppable>(stop);
    }

    public void step(SimState state) {
        Stoppable stop;
        Steppable step = (Steppable)this.weakStep.get();
        if (step != null) {
            step.step(state);
        } else if (this.weakStop != null && (stop = (Stoppable)this.weakStop.get()) != null) {
            stop.stop();
        }
    }
}

