/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.field.grid.IntGrid2D;
import sim.util.DoubleBag;
import sim.util.IntBag;

public class DoubleGrid2D
extends AbstractGrid2D {
    public double[][] field;

    public double[][] getField() {
        return this.field;
    }

    public DoubleGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new double[width][height];
    }

    public DoubleGrid2D(int width, int height, double initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public DoubleGrid2D(DoubleGrid2D values) {
        this.setTo(values);
    }

    public final void set(int x, int y, double val) {
        this.field[x][y] = val;
    }

    public final double get(int x, int y) {
        return this.field[x][y];
    }

    public final DoubleGrid2D setTo(double thisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = thisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D setTo(DoubleGrid2D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            this.field = new double[width][];
            for (int x = 0; x < width; ++x) {
                this.field[x] = (double[])values.field[x].clone();
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
            }
        }
        return this;
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(max < fieldx[y])) continue;
                max = fieldx[y];
            }
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(min > fieldx[y])) continue;
                min = fieldx[y];
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                mean += fieldx[y];
                ++count;
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid2D upperBound(double toNoMoreThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(fieldx[y] > toNoMoreThanThisMuch)) continue;
                fieldx[y] = toNoMoreThanThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D lowerBound(double toNoLowerThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(fieldx[y] < toNoLowerThanThisMuch)) continue;
                fieldx[y] = toNoLowerThanThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D add(double withThisMuch) {
        int width = this.width;
        int height = this.height;
        if (withThisMuch == 0.0) {
            return this;
        }
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D add(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] + (double)ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D add(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] * (double)ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D floor() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.floor(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D ceiling() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.ceil(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D truncate() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] > 0.0) {
                    Math.floor(fieldx[y]);
                    continue;
                }
                Math.ceil(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D rint() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.rint(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleBag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new DoubleBag();
        }
        this.getNeighborsMaxDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final DoubleBag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new DoubleBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final DoubleBag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new DoubleBag();
        }
        this.getNeighborsHexagonalDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }
}

