/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid3D;
import sim.field.grid.IntGrid3D;
import sim.util.DoubleBag;
import sim.util.IntBag;

public class DoubleGrid3D
extends AbstractGrid3D {
    public double[][][] field;

    public DoubleGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new double[width][height][length];
    }

    public DoubleGrid3D(int width, int height, int length, double initialValue) {
        this(width, height, length);
        this.setTo(initialValue);
    }

    public DoubleGrid3D(DoubleGrid3D values) {
        this.setTo(values);
    }

    public final double set(int x, int y, int z, double val) {
        double returnval = this.field[x][y][z];
        this.field[x][y][z] = val;
        return returnval;
    }

    public final double get(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(max < fieldxy[z])) continue;
                    max = fieldxy[z];
                }
            }
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(min > fieldxy[z])) continue;
                    min = fieldxy[z];
                }
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    mean += fieldxy[z];
                    ++count;
                }
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid3D setTo(double thisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = thisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D setTo(DoubleGrid3D values) {
        if (this.width != values.width || this.height != values.height || this.length != values.length) {
            int width = this.width = values.width;
            int height = this.height = values.height;
            this.length = values.length;
            this.field = new double[width][height][];
            double[][] fieldx = null;
            for (int x = 0; x < width; ++x) {
                fieldx = this.field[x];
                for (int y = 0; y < height; ++y) {
                    fieldx[y] = (double[])values.field[x][y].clone();
                }
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    System.arraycopy(values.field[x][y], 0, this.field[x][y], 0, this.length);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D upperBound(double toNoMoreThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(fieldxy[z] > toNoMoreThanThisMuch)) continue;
                    fieldxy[z] = toNoMoreThanThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D lowerBound(double toNoLowerThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(fieldxy[z] < toNoLowerThanThisMuch)) continue;
                    fieldxy[z] = toNoLowerThanThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(double withThisMuch) {
        if (withThisMuch == 0.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] + withThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + (double)ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] * byThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * (double)ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D floor() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.floor(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D ceiling() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.ceil(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D truncate() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] > 0.0) {
                        Math.floor(fieldxy[z]);
                        continue;
                    }
                    Math.ceil(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D rint() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.rint(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleBag getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        if (result == null) {
            result = new DoubleBag();
        }
        this.getNeighborsMaxDistance(x, y, z, dist, toroidal, xPos, yPos, zPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]]);
        }
        return result;
    }

    public final DoubleBag getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        if (result == null) {
            result = new DoubleBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, z, dist, toroidal, xPos, yPos, zPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]]);
        }
        return result;
    }
}

