/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.util.IntBag;

public class IntGrid2D
extends AbstractGrid2D {
    public int[][] field;

    public IntGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new int[width][height];
    }

    public IntGrid2D(int width, int height, int initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public IntGrid2D(IntGrid2D values) {
        this.setTo(values);
    }

    public final void set(int x, int y, int val) {
        this.field[x][y] = val;
    }

    public final int get(int x, int y) {
        return this.field[x][y];
    }

    public final IntGrid2D setTo(int thisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = thisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D setTo(IntGrid2D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            int[][] nArrayArray = new int[width][];
            this.field = nArrayArray;
            int[][] field = nArrayArray;
            for (int x = 0; x < width; ++x) {
                field[x] = (int[])values.field[x].clone();
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
            }
        }
        return this;
    }

    public final int max() {
        int max = Integer.MIN_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (max >= fieldx[y]) continue;
                max = fieldx[y];
            }
        }
        return max;
    }

    public final int min() {
        int min = Integer.MAX_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (min <= fieldx[y]) continue;
                min = fieldx[y];
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                mean += (double)fieldx[y];
                ++count;
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final IntGrid2D upperBound(int toNoMoreThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] <= toNoMoreThanThisMuch) continue;
                fieldx[y] = toNoMoreThanThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D lowerBound(int toNoLowerThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] >= toNoLowerThanThisMuch) continue;
                fieldx[y] = toNoLowerThanThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D add(int withThisMuch) {
        if ((double)withThisMuch == 0.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D add(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
            }
        }
        return this;
    }

    public final IntGrid2D multiply(int byThisMuch) {
        if ((double)byThisMuch == 1.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D multiply(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
            }
        }
        return this;
    }

    public final IntBag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new IntBag();
        }
        this.getNeighborsMaxDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final IntBag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new IntBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }

    public final IntBag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (result == null) {
            result = new IntBag();
        }
        this.getNeighborsHexagonalDistance(x, y, dist, toroidal, xPos, yPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]]);
        }
        return result;
    }
}

