/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid3D;
import sim.util.IntBag;

public class IntGrid3D
extends AbstractGrid3D {
    public int[][][] field;

    public IntGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new int[width][height][length];
    }

    public IntGrid3D(int width, int height, int length, int initialValue) {
        this(width, height, length);
        this.setTo(initialValue);
    }

    public IntGrid3D(IntGrid3D values) {
        this.setTo(values);
    }

    public final int set(int x, int y, int z, int val) {
        int returnval = this.field[x][y][z];
        this.field[x][y][z] = val;
        return returnval;
    }

    public final int get(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public final int max() {
        int max = Integer.MIN_VALUE;
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (max >= fieldxy[z]) continue;
                    max = fieldxy[z];
                }
            }
        }
        return max;
    }

    public final int min() {
        int min = Integer.MAX_VALUE;
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (min <= fieldxy[z]) continue;
                    min = fieldxy[z];
                }
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    mean += (double)fieldxy[z];
                    ++count;
                }
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final IntGrid3D setTo(int thisMuch) {
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = thisMuch;
                }
            }
        }
        return this;
    }

    public final IntGrid3D setTo(IntGrid3D values) {
        if (this.width != values.width || this.height != values.height || this.length != values.length) {
            int width = this.width = values.width;
            int height = this.height = values.height;
            this.length = values.length;
            this.field = new int[width][height][];
            int[][] fieldx = null;
            int[][] ofieldx = null;
            for (int x = 0; x < width; ++x) {
                fieldx = this.field[x];
                ofieldx = values.field[x];
                for (int y = 0; y < height; ++y) {
                    fieldx[y] = (int[])ofieldx[y].clone();
                }
            }
        } else {
            int[][] fieldx = null;
            int[][] ofieldx = null;
            for (int x = 0; x < this.width; ++x) {
                fieldx = this.field[x];
                ofieldx = values.field[x];
                for (int y = 0; y < this.height; ++y) {
                    System.arraycopy(ofieldx[y], 0, fieldx[y], 0, this.length);
                }
            }
        }
        return this;
    }

    public final IntGrid3D upperBound(int toNoMoreThanThisMuch) {
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] <= toNoMoreThanThisMuch) continue;
                    fieldxy[z] = toNoMoreThanThisMuch;
                }
            }
        }
        return this;
    }

    public final IntGrid3D lowerBound(int toNoLowerThanThisMuch) {
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] >= toNoLowerThanThisMuch) continue;
                    fieldxy[z] = toNoLowerThanThisMuch;
                }
            }
        }
        return this;
    }

    public final IntGrid3D add(int withThisMuch) {
        if ((double)withThisMuch == 0.0) {
            return this;
        }
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] + withThisMuch;
                }
            }
        }
        return this;
    }

    public final IntGrid3D add(IntGrid3D withThis) {
        int[][] fieldx = null;
        int[] fieldxy = null;
        int[][][] ofield = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final IntGrid3D multiply(int byThisMuch) {
        if ((double)byThisMuch == 1.0) {
            return this;
        }
        int[][] fieldx = null;
        int[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] * byThisMuch;
                }
            }
        }
        return this;
    }

    public final IntGrid3D multiply(IntGrid3D withThis) {
        int[][] fieldx = null;
        int[] fieldxy = null;
        int[][][] ofield = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final void getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getNeighborsMaxDistance(x, y, z, dist, toroidal, xPos, yPos, zPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]]);
        }
    }

    public final void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, z, dist, toroidal, xPos, yPos, zPos);
        result.clear();
        for (int i = 0; i < xPos.numObjs; ++i) {
            result.add(this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]]);
        }
    }
}

