/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.SparseField;
import sim.field.grid.Grid2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.MutableInt2D;

public class SparseGrid2D
extends SparseField
implements Grid2D {
    protected int width;
    protected int height;
    MutableInt2D speedyMutableInt2D = new MutableInt2D();

    public SparseGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final int tx(int x) {
        int width = this.width;
        if (x >= 0 && x < width) {
            return x;
        }
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    public final int ty(int y) {
        int height = this.height;
        if (y >= 0 && y < height) {
            return y;
        }
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    public int stx(int x) {
        if (x >= 0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    public int sty(int y) {
        if (y >= 0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    final int stx(int x, int width) {
        if (x >= 0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    final int sty(int y, int height) {
        if (y >= 0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public int ulx(int x, int y) {
        return x - 1;
    }

    public int uly(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    public int urx(int x, int y) {
        return x + 1;
    }

    public int ury(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    public int dlx(int x, int y) {
        return x - 1;
    }

    public int dly(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    public int drx(int x, int y) {
        return x + 1;
    }

    public int dry(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    public int upx(int x, int y) {
        return x;
    }

    public int upy(int x, int y) {
        return y - 1;
    }

    public int downx(int x, int y) {
        return x;
    }

    public int downy(int x, int y) {
        return y + 1;
    }

    public boolean trb(int x, int y) {
        return (x + y & 1) == 1;
    }

    public boolean trt(int x, int y) {
        return (x + y & 1) == 0;
    }

    public int numObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.numObjectsAtLocation(speedyMutableInt2D);
    }

    public Bag getObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.getObjectsAtLocation(speedyMutableInt2D);
    }

    public Double2D getObjectLocationAsDouble2D(Object obj) {
        Int2D loc = (Int2D)super.getRawObjectLocation(obj);
        if (loc == null) {
            return null;
        }
        return new Double2D(loc);
    }

    public Int2D getObjectLocation(Object obj) {
        return (Int2D)super.getRawObjectLocation(obj);
    }

    public Bag removeObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.removeObjectsAtLocation(speedyMutableInt2D);
    }

    public boolean setObjectLocation(Object obj, int x, int y) {
        return super.setObjectLocation(obj, new Int2D(x, y));
    }

    public boolean setObjectLocation(Object obj, Int2D location) {
        return super.setObjectLocation(obj, location);
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsMaxDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int xmin = x - dist;
            int xmax = x + dist;
            int ymin = y - dist;
            int ymax = y + dist;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                int x_0 = this.stx(x0, width);
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    int y_0 = this.sty(y0, height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                }
            }
        } else {
            int xmin = x - dist >= 0 ? x - dist : 0;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            int ymin = y - dist >= 0 ? y - dist : 0;
            int ymax = y + dist <= height - 1 ? y + dist : height - 1;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    xPos.add(x0);
                    yPos.add(y0);
                }
            }
        }
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int xmin;
            int xmax = x + dist;
            for (int x0 = xmin = x - dist; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = this.stx(x0, width);
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)); y0 <= ymax; ++y0) {
                    int y_0 = this.sty(y0, height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                }
            }
        } else {
            int xmin;
            int xmax = x + dist <= width - 1 ? x + dist : width - 1;
            for (int x0 = xmin = x - dist >= 0 ? x - dist : 0; x0 <= xmax; ++x0) {
                int ymin;
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) <= height - 1 ? y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : height - 1;
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) >= 0 ? y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : 0; y0 <= ymax; ++y0) {
                    xPos.add(x0);
                    yPos.add(y0);
                }
            }
        }
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        if (dist < 0) {
            throw new RuntimeException("Runtime exception in method getNeighborsHexagonalDistance: Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("Runtime exception in method getNeighborsHamiltonianDistance: xPos and yPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal && height % 2 == 1) {
            throw new RuntimeException("Runtime exception in getNeighborsHexagonalDistance: toroidal hexagonal environment should have even heights");
        }
        if (toroidal) {
            int y0;
            int temp_ymin;
            int i;
            int ymin = y - dist;
            int ymax = y + dist;
            int y02 = ymin;
            while (y02 <= ymax) {
                xPos.add(this.stx(x, width));
                yPos.add(this.sty(y02, height));
                y02 = this.downy(x, y02);
            }
            int x0 = x;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.stx(x0, width));
                    yPos.add(this.sty(y0, height));
                    y0 = this.downy(x0, y0);
                }
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.stx(x0, width));
                    yPos.add(this.sty(y0, height));
                    y0 = this.downy(x0, y0);
                }
            }
        } else {
            int y0;
            int temp_ymin;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height) {
                throw new RuntimeException("Runtime exception in method getNeighborsHexagonalDistance: invalid initial position");
            }
            int ylBound = y - dist;
            int yuBound = y + dist < height ? y + dist : height - 1;
            int y03 = ylBound;
            while (y03 <= yuBound) {
                xPos.add(x);
                yPos.add(y03);
                y03 = this.downy(x, y03);
            }
            int x0 = x;
            int ymin = y - dist;
            int ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                int n = yuBound = ymax < height ? ymax : height - 1;
                if (x0 < 0) continue;
                y0 = ylBound;
                while (y0 <= yuBound) {
                    if (y0 >= 0) {
                        xPos.add(x0);
                        yPos.add(y0);
                    }
                    y0 = this.downy(x0, y0);
                }
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            for (i = 1; i <= dist; ++i) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                int n = yuBound = ymax < height ? ymax : height;
                if (x0 >= width) continue;
                y0 = ymin;
                while (y0 <= yuBound) {
                    if (y0 >= 0) {
                        xPos.add(x0);
                        yPos.add(y0);
                    }
                    y0 = this.downy(x0, y0);
                }
            }
        }
    }

    public Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsMaxDistance(x, y, dist, toroidal, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHamiltonianDistance(x, y, dist, toroidal, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getNeighborsHexagonalDistance(x, y, dist, toroidal, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        for (int i = 0; i < len; ++i) {
            Bag temp = this.getObjectsAtLocation(xs[i], ys[i]);
            if (temp == null) continue;
            int n = temp.numObjs;
            if (n == 1) {
                result.add(temp.objs[0]);
                continue;
            }
            if (n <= 1) continue;
            result.addAll(temp);
        }
        return result;
    }
}

