/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import sim.field.network.Edge;
import sim.util.Bag;

public class Network
implements Serializable {
    public final boolean directed;
    public HashMap indexOutInHash = new HashMap();
    public Bag allNodes = new Bag();
    final Bag emptyBag = new Bag();
    static Edge[] emptyEdgeArray = new Edge[0];

    public Network(boolean directed) {
        this.directed = directed;
    }

    public Network() {
        this(true);
    }

    public Edge[][] getAdjacencyList(boolean outEdges) {
        Edge[][] list = new Edge[this.allNodes.numObjs][];
        for (int x = 0; x < this.allNodes.numObjs; ++x) {
            Bag edges = outEdges ? this.getEdgesOut(this.allNodes.objs[x]) : this.getEdgesIn(this.allNodes.objs[x]);
            list[x] = new Edge[edges.numObjs];
            Edge[] l = list[x];
            int n = edges.numObjs;
            Object[] objs = edges.objs;
            System.arraycopy(objs, 0, l, 0, n);
        }
        return list;
    }

    public Edge[][] getAdjacencyMatrix() {
        int n = this.allNodes.numObjs;
        Edge[][] matrix = new Edge[n][n];
        Iterator nodeIO = this.indexOutInHash.values().iterator();
        while (nodeIO.hasNext()) {
            IndexOutIn ioi = (IndexOutIn)nodeIO.next();
            if (ioi.out == null) continue;
            int outDegree = ioi.out.numObjs;
            Edge[] outEdges = matrix[ioi.index];
            Object sourceNode = this.allNodes.objs[ioi.index];
            for (int i = 0; i < outDegree; ++i) {
                Edge e;
                outEdges[((IndexOutIn)this.indexOutInHash.get((Object)e.getOtherNode((Object)sourceNode))).index] = e = (Edge)ioi.out.objs[i];
            }
        }
        return matrix;
    }

    public Edge[][][] getMultigraphAdjacencyMatrix() {
        int i;
        int n = this.allNodes.numObjs;
        Edge[][][] matrix = new Edge[n][n][];
        Iterator nodeIO = this.indexOutInHash.values().iterator();
        Bag[] tmp = new Bag[n];
        for (i = 0; i < n; ++i) {
            tmp[i] = new Bag(n);
        }
        while (nodeIO.hasNext()) {
            IndexOutIn ioi = (IndexOutIn)nodeIO.next();
            if (ioi.out == null) continue;
            int outDegree = ioi.out.numObjs;
            Object sourceNode = this.allNodes.objs[ioi.index];
            for (int i2 = 0; i2 < outDegree; ++i2) {
                Edge e = (Edge)ioi.out.objs[i2];
                int j = ((IndexOutIn)this.indexOutInHash.get((Object)e.getOtherNode((Object)sourceNode))).index;
                tmp[j].add(e);
            }
            Edge[][] outEdges = matrix[ioi.index];
            for (int i3 = 0; i3 < n; ++i3) {
                Bag b = tmp[i3];
                int ne = b.numObjs;
                outEdges[i3] = new Edge[ne];
                if (ne <= 0) continue;
                System.arraycopy(b.objs, 0, outEdges[i3], 0, ne);
                b.clear();
            }
        }
        for (i = 0; i < n; ++i) {
            Edge[][] e2 = matrix[i];
            if (e2[0] != null) continue;
            for (int j = 0; j < n; ++j) {
                e2[j] = emptyEdgeArray;
            }
        }
        return matrix;
    }

    public Bag getEdgesOut(Object node) {
        Bag b;
        IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
        if (ioi == null || (b = ioi.out) == null) {
            return this.emptyBag;
        }
        return b;
    }

    public Bag getEdgesIn(Object node) {
        Bag b;
        IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
        if (ioi == null || (b = ioi.in) == null) {
            return this.emptyBag;
        }
        return b;
    }

    public Bag getEdges(Object node, Bag bag) {
        if (!this.directed) {
            if (bag == null) {
                bag = new Bag();
            } else {
                bag.clear();
            }
            IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
            if (ioi == null) {
                return bag;
            }
            if (ioi.in != null && ioi.in.numObjs > 0) {
                bag.addAll(ioi.in);
            }
            return bag;
        }
        if (bag == null) {
            bag = new Bag();
        } else {
            bag.clear();
        }
        IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
        if (ioi == null) {
            return bag;
        }
        if (ioi.in != null && ioi.in.numObjs > 0) {
            bag.addAll(ioi.in);
        }
        if (ioi.out != null && ioi.out.numObjs > 0) {
            bag.addAll(ioi.out);
        }
        return bag;
    }

    public void addNode(Object node) {
        if (this.indexOutInHash.get(node) != null) {
            return;
        }
        this.allNodes.add(node);
        IndexOutIn ioih = new IndexOutIn(this.allNodes.numObjs - 1, null, null);
        this.indexOutInHash.put(node, ioih);
    }

    public void addEdge(Object from, Object to, Object info) {
        this.addEdge(new Edge(from, to, info));
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            throw new RuntimeException("Attempted to add a null Edge.");
        }
        if (edge.owner != null) {
            throw new RuntimeException("Attempted to add an Edge already added elsewhere");
        }
        edge.owner = this;
        edge.indexFrom = 0;
        edge.indexTo = 0;
        IndexOutIn outNode = (IndexOutIn)this.indexOutInHash.get(edge.from);
        if (outNode == null) {
            this.addNode(edge.from);
            outNode = (IndexOutIn)this.indexOutInHash.get(edge.from);
        }
        if (outNode.out == null) {
            outNode.out = this.directed ? new Bag() : (outNode.in != null ? outNode.in : (outNode.in = new Bag()));
        }
        outNode.out.add(edge);
        edge.indexFrom = outNode.out.numObjs - 1;
        IndexOutIn inNode = (IndexOutIn)this.indexOutInHash.get(edge.to);
        if (inNode == null) {
            this.addNode(edge.to);
            inNode = (IndexOutIn)this.indexOutInHash.get(edge.to);
        }
        if (inNode.in == null) {
            inNode.in = this.directed ? new Bag() : (inNode.out != null ? inNode.out : (inNode.out = new Bag()));
        }
        inNode.in.add(edge);
        edge.indexTo = inNode.in.numObjs - 1;
    }

    public Edge updateEdge(Edge edge, Object from, Object to, Object info) {
        if ((edge = this.removeEdge(edge)) != null) {
            edge.setTo(from, to, info, -1, -1);
            this.addEdge(edge);
        }
        return edge;
    }

    public Edge removeEdge(Edge edge) {
        if (edge == null) {
            return null;
        }
        if (edge.owner != this) {
            return null;
        }
        edge.owner = null;
        Bag outNodeBag = ((IndexOutIn)this.indexOutInHash.get((Object)edge.from)).out;
        outNodeBag.remove(edge.indexFrom);
        if (outNodeBag.numObjs > edge.indexFrom) {
            Edge shiftedEdge = (Edge)outNodeBag.objs[edge.indexFrom];
            int shiftedIndex = outNodeBag.numObjs;
            if (this.directed) {
                shiftedEdge.indexFrom = edge.indexFrom;
            } else if (shiftedEdge.indexFrom == shiftedIndex && shiftedEdge.from.equals(edge.from)) {
                shiftedEdge.indexFrom = edge.indexFrom;
            } else if (shiftedEdge.indexTo == shiftedIndex && shiftedEdge.to.equals(edge.from)) {
                shiftedEdge.indexTo = edge.indexFrom;
            } else {
                throw new InternalError("This shouldn't ever happen: #1");
            }
        }
        Bag inNodeBag = ((IndexOutIn)this.indexOutInHash.get((Object)edge.to)).in;
        inNodeBag.remove(edge.indexTo);
        if (inNodeBag.numObjs > edge.indexTo) {
            Edge shiftedEdge = (Edge)inNodeBag.objs[edge.indexTo];
            int shiftedIndex = inNodeBag.numObjs;
            if (this.directed) {
                shiftedEdge.indexTo = edge.indexTo;
            } else if (shiftedEdge.indexTo == shiftedIndex && shiftedEdge.to.equals(edge.to)) {
                shiftedEdge.indexTo = edge.indexTo;
            } else if (shiftedEdge.indexFrom == shiftedIndex && shiftedEdge.from.equals(edge.to)) {
                shiftedEdge.indexFrom = edge.indexTo;
            } else {
                throw new InternalError("This shouldn't ever happen: #2");
            }
        }
        return edge;
    }

    public Object removeNode(Object node) {
        IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
        if (ioi == null) {
            return null;
        }
        while (ioi.out != null && ioi.out.numObjs > 0) {
            this.removeEdge((Edge)ioi.out.objs[0]);
        }
        while (ioi.in != null && ioi.in.numObjs > 0) {
            this.removeEdge((Edge)ioi.in.objs[0]);
        }
        this.allNodes.remove(ioi.index);
        if (this.allNodes.numObjs > ioi.index) {
            ((IndexOutIn)this.indexOutInHash.get((Object)this.allNodes.objs[ioi.index])).index = ioi.index;
        }
        this.indexOutInHash.remove(node);
        return node;
    }

    public Bag clear() {
        this.indexOutInHash = new HashMap();
        Bag retval = this.allNodes;
        this.allNodes = new Bag();
        return retval;
    }

    public Bag removeAllNodes() {
        return this.clear();
    }

    public Bag getAllNodes() {
        return this.allNodes;
    }

    public Iterator iterator() {
        return this.allNodes.iterator();
    }

    public int getNodeIndex(Object node) {
        IndexOutIn ioi = (IndexOutIn)this.indexOutInHash.get(node);
        if (ioi == null) {
            throw new RuntimeException("Object parameter is not a node in the network.");
        }
        return ioi.index;
    }

    public void reverseAllEdges() {
        if (!this.directed) {
            return;
        }
        int n = this.allNodes.numObjs;
        Iterator i = this.indexOutInHash.values().iterator();
        for (int k = 0; k < n; ++k) {
            IndexOutIn ioi = (IndexOutIn)i.next();
            Bag tmpB = ioi.out;
            ioi.out = ioi.in;
            ioi.in = tmpB;
            if (ioi.in == null) continue;
            for (int j = 0; j < ioi.in.numObjs; ++j) {
                Edge e = (Edge)ioi.in.objs[j];
                Object tmpO = e.from;
                e.from = e.to;
                e.to = tmpO;
                int tmpI = e.indexFrom;
                e.indexFrom = e.indexTo;
                e.indexTo = tmpI;
            }
        }
    }

    public Network cloneGraph() {
        IndexOutIn oldIOI;
        int k;
        Network clone = new Network(this.directed);
        clone.allNodes.addAll(this.allNodes);
        int n = this.allNodes.numObjs;
        Iterator ioiIterator = this.indexOutInHash.values().iterator();
        IndexOutIn[] ioiArray = new IndexOutIn[n];
        for (k = 0; k < n; ++k) {
            Bag copyOutBag;
            oldIOI = (IndexOutIn)ioiIterator.next();
            int index = oldIOI.index;
            Bag bag = copyOutBag = oldIOI.out == null ? new Bag() : new Bag(oldIOI.out.numObjs);
            Bag copyInBag = this.directed ? (oldIOI.in == null ? new Bag() : new Bag(oldIOI.in.numObjs)) : copyOutBag;
            IndexOutIn clonedIOI = new IndexOutIn(oldIOI.index, copyOutBag, copyInBag);
            clone.indexOutInHash.put(this.allNodes.objs[index], clonedIOI);
            ioiArray[k] = oldIOI;
        }
        for (k = 0; k < n; ++k) {
            oldIOI = ioiArray[k];
            Object node_k = this.allNodes.objs[oldIOI.index];
            if (oldIOI.out == null) continue;
            for (int i = 0; i < oldIOI.out.numObjs; ++i) {
                Edge e = (Edge)oldIOI.out.objs[i];
                if (!this.directed && e.from != node_k) continue;
                clone.addEdge(new Edge(e.from, e.to, e.info));
            }
        }
        return clone;
    }

    public Network getGraphComplement(boolean allowSelfLoops) {
        Network complement = new Network(this.directed);
        complement.allNodes.addAll(this.allNodes);
        int n = this.allNodes.numObjs;
        Iterator ioiIterator = this.indexOutInHash.values().iterator();
        IndexOutIn[] ioiArray = new IndexOutIn[n];
        int maxDegree = n - 1 + (allowSelfLoops ? 1 : 0);
        for (int k = 0; k < n; ++k) {
            Bag newOutBag;
            IndexOutIn oldIOI = (IndexOutIn)ioiIterator.next();
            int index = oldIOI.index;
            Bag bag = newOutBag = oldIOI.out == null ? new Bag(maxDegree) : new Bag(maxDegree - oldIOI.out.numObjs);
            Bag newInBag = !this.directed ? newOutBag : (oldIOI.in == null ? new Bag(maxDegree) : new Bag(maxDegree - oldIOI.in.numObjs));
            IndexOutIn clonedIOI = new IndexOutIn(oldIOI.index, newOutBag, newInBag);
            complement.indexOutInHash.put(this.allNodes.objs[index], clonedIOI);
            ioiArray[k] = oldIOI;
        }
        boolean[] edgeArray = new boolean[n];
        for (int k = 0; k < n; ++k) {
            int i;
            IndexOutIn oldIOI = ioiArray[k];
            int nodeIndex = oldIOI.index;
            Object nodeObj = this.allNodes.objs[nodeIndex];
            for (i = 0; i < n; ++i) {
                edgeArray[i] = true;
            }
            if (!allowSelfLoops) {
                edgeArray[nodeIndex] = false;
            }
            if (oldIOI.out != null) {
                for (i = 0; i < oldIOI.out.numObjs; ++i) {
                    Edge e = (Edge)oldIOI.out.objs[i];
                    Object otherNode = e.getOtherNode(nodeObj);
                    int otherIndex = this.getNodeIndex(otherNode);
                    edgeArray[otherIndex] = false;
                }
            }
            for (i = 0; i < n; ++i) {
                if (!edgeArray[i] || !this.directed && nodeIndex > i) continue;
                complement.addEdge(nodeObj, this.allNodes.objs[i], null);
            }
        }
        return complement;
    }

    public static class IndexOutIn
    implements Serializable {
        public int index;
        public Bag out;
        public Bag in;

        public IndexOutIn(int index, Bag out, Bag in) {
            this.index = index;
            this.out = out;
            this.in = in;
        }
    }
}

