/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class DrawInfo2D {
    public Rectangle2D.Double draw;
    public Rectangle2D.Double clip;
    public boolean precise;

    public DrawInfo2D(Rectangle2D.Double draw, Rectangle2D.Double clip) {
        this.draw = draw;
        this.clip = clip;
        this.precise = false;
    }

    public DrawInfo2D(Rectangle draw, Rectangle clip) {
        this.draw = new Rectangle2D.Double(draw.x, draw.y, draw.width, draw.height);
        this.clip = new Rectangle2D.Double(clip.x, clip.y, clip.width, clip.height);
        this.precise = false;
    }

    public DrawInfo2D(RectangularShape draw, RectangularShape clip) {
        this.draw = new Rectangle2D.Double();
        this.draw.setRect(draw.getFrame());
        this.clip = new Rectangle2D.Double();
        this.clip.setRect(clip.getFrame());
        this.precise = false;
    }

    public DrawInfo2D(DrawInfo2D other, double translateX, double translateY) {
        Rectangle2D.Double odraw = other.draw;
        this.draw = new Rectangle2D.Double(odraw.x + translateX, odraw.y + translateY, odraw.width, odraw.height);
        Rectangle2D.Double oclip = other.clip;
        this.clip = new Rectangle2D.Double(oclip.x + translateX, oclip.y + translateY, oclip.width, oclip.height);
        this.precise = other.precise;
    }

    public DrawInfo2D(DrawInfo2D other) {
        this(other, 0.0, 0.0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DrawInfo2D) {
            DrawInfo2D other = (DrawInfo2D)obj;
            return this.draw.equals(other.draw) && this.clip.equals(other.clip) && other.precise == this.precise;
        }
        return false;
    }

    public String toString() {
        return "DrawInfo2D[ Draw: " + this.draw + " Clip: " + this.clip + " Precise: " + this.precise + "]";
    }
}

